/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.handlers;

import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.CharacterDataEditingSupport;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.SRFValueEditingSupport;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CustomPasteHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright (c) 2016 CA";
    Logger logger = Logger.getLogger(CustomPasteHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.logger.log(Level.INFO, "inside CustomPasteHandler");
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        IWorkbenchPart workbenchPart = page.getActivePart();
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        EditorView view = (EditorView)page.getActivePart();
        String mode = view.getDisplayMode(secondaryId);
        Event event2 = (Event)event.getTrigger();
        Widget obj = event2.widget;
        if (obj instanceof Table) {
            return null;
        }
        Text textWidget = (Text)obj;
        int caretPosition = textWidget.getCaretPosition();
        if (mode.equalsIgnoreCase("C")) {
            CharFormatMode charFormatMode = view.getCharMode();
            CharacterDataEditingSupport characterDataEditingSupport = charFormatMode.getCharacterDataEditingSupport();
            if (characterDataEditingSupport.getClipboardDataToBePasted() == null || characterDataEditingSupport.getClipboardDataToBePasted().length() == 0) {
                this.logger.log(Level.INFO, "nothing to paste");
                return null;
            }
            characterDataEditingSupport.initializeVariables(textWidget);
            if (characterDataEditingSupport.isInsertToggleFlag() || textWidget.getSelectionCount() > 0) {
                characterDataEditingSupport.pasteInsertMode(event2, textWidget, caretPosition, characterDataEditingSupport.getClipboardDataToBePasted());
            } else {
                characterDataEditingSupport.pasteOvertypeMode(event2, textWidget, caretPosition, characterDataEditingSupport.getClipboardDataToBePasted());
            }
        } else if (mode.equalsIgnoreCase("S")) {
            SingleRecordFormatMode singleRecordFormatMode = view.getSingleRecordFormatMode();
            SRFValueEditingSupport srfValueEditingSupport = singleRecordFormatMode.getSrfValueEditingSupport();
            if (srfValueEditingSupport.getClipboardDataToBePasted() == null || srfValueEditingSupport.getClipboardDataToBePasted().length() == 0) {
                this.logger.log(Level.INFO, "nothing to paste");
                return null;
            }
            srfValueEditingSupport.initializeVariables(textWidget);
            if (srfValueEditingSupport.isInsertToggleFlag() || textWidget.getSelectionCount() > 0) {
                srfValueEditingSupport.pasteInsertMode(event2, textWidget, caretPosition, srfValueEditingSupport.getClipboardDataToBePasted());
            } else {
                srfValueEditingSupport.pasteOvertypeMode(event2, textWidget, caretPosition, srfValueEditingSupport.getClipboardDataToBePasted());
            }
        }
        return null;
    }
}

