/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class RunGetGetRecords
implements Runnable {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String displayMode;
    private String uuid;
    private static final String SERVICE = "filemaster/fmp";
    private int start = 0;
    private int count = 0;
    private String direction = "";
    private String hexMode = "N";
    private Logger log = Logger.getLogger(RunGetGetRecords.class.getName());
    private EditorView editorView = new EditorView();

    public RunGetGetRecords(FileMasterServer server, String uuid, int start, int count, String displayMode, String hexMode) {
        this.start = start;
        this.count = count;
        this.displayMode = displayMode;
        this.server = server;
        this.hexMode = hexMode;
        this.uuid = uuid;
    }

    public RunGetGetRecords(FileMasterServer server, String uuid, int start, int count, String direction, String displayMode, String hexMode) {
        this.start = start;
        this.count = count;
        this.direction = direction;
        this.displayMode = displayMode;
        this.server = server;
        this.hexMode = hexMode;
        this.uuid = uuid;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = connection.connect("getre", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                Element reqElement = this.xml.getRoot();
                if (reqElement != null && (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16"))) {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = win.getActivePage();
                    String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
                    this.editorView.handleMissingSession(reqElement, page, secondaryID);
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        if (this.start == 0) {
            this.start = 1;
        }
        if (this.count == 0) {
            this.count = 50;
        }
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = this.start < 0 ? String.valueOf(command) + "<GetRecords start=\"4294967295\" count=\"" + this.count + "\">" : (!this.direction.isEmpty() ? String.valueOf(command) + "<GetRecords start=\"" + this.start + "\" count=\"" + this.count + "\" direction=\"" + this.direction + "\">" : String.valueOf(command) + "<GetRecords start=\"" + this.start + "\" count=\"" + this.count + "\">");
        command = String.valueOf(command) + "</GetRecords ></Edit></GUIRequest>";
        XMLDocument result = CommonMFCalls.createXMLDoc((String)command);
        this.log.log(Level.INFO, result.toString());
        return result;
    }
}

