/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.system;

import com.ca.symdump.Abend;
import com.ca.symdump.BuildDocument;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.GetDisplay;
import com.ca.symdump.RunGetTrace;
import com.ca.symdump.SymdumpHeaderMap;
import com.ca.symdump.system.Activator;
import com.ca.symdump.system.SymSysIndexMaintenance;
import com.ca.symdump.system.SymSysRunGetTrace;
import com.ca.symdump.system.SymSysTreeBuild;
import com.ca.symdump.system.SystemMemory;
import com.ca.symdump.views.report.ReportView;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymSysAbend
extends Abend {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private Image JobnameImage;
    private static final String keyFormat = "%-44s%-44s";
    public static final String SYMD = "SYS";

    public SymSysAbend(Element element, ArrayList<SymdumpHeaderMap> headerMap) {
        super(element);
        this.ObjectAddr = element.getAttribute("OBJADDR");
        String lineRecord = XMLFile.getStr((Element)element);
        this.setValues(headerMap, lineRecord);
    }

    public String getColumn(int column) {
        switch (column) {
            case 0: {
                return this.getColumn("JobName");
            }
            case 1: {
                return this.getColumn("Program");
            }
            case 2: {
                return this.getColumn("Offset");
            }
            case 3: {
                return this.getColumn("Comp");
            }
            case 4: {
                return this.getColumn("Date");
            }
            case 5: {
                return this.getColumn("Time");
            }
            case 100: {
                return this.getColumn("Time").replace('.', ':');
            }
            case 6: {
                return this.getColumn("UserId");
            }
            case 7: {
                return this.getColumn("Lock");
            }
            case 8: {
                return this.getColumn("System");
            }
            case 9: {
                return this.getColumn("Reports");
            }
            case 10: {
                return this.getColumn("Storage");
            }
            case 103: {
                String time = String.valueOf(this.getColumn("Date")) + " ";
                time = String.valueOf(time) + this.getColumn("Time").replace('.', ':');
                return time;
            }
        }
        return "";
    }

    public DumpTreeNode getDumpTree(boolean force) throws TTException {
        if (this.dumpTreeNode == null && force) {
            this.dumpTreeNode = new SymSysTreeBuild().getTree(this);
        }
        return this.dumpTreeNode;
    }

    public String getSysd() {
        return SYMD;
    }

    public XMLRequest getReport(DumpTreeNode node) {
        try {
            return GetDisplay.getDisplay((Abend)this, (DumpTreeNode)node);
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            XMLRequest xml = new XMLRequest();
            xml.setCommand("disp");
            xml.setStatus(16, HexUtil.getErrorText((Throwable)e));
            return xml;
        }
    }

    public XMLRequest getDisaReport(DumpTreeNode node) {
        try {
            return GetDisplay.getDisaDisplay((Abend)this, (String)node.getMiscData());
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            XMLRequest xml = new XMLRequest();
            xml.setCommand("disa");
            xml.setStatus(16, HexUtil.getErrorText((Throwable)e));
            return xml;
        }
    }

    public XMLRequest deleteDump() throws TTException, MalformedURLException {
        XMLRequest returnXML = new SymSysIndexMaintenance().deleteDump(this);
        return returnXML;
    }

    public XMLRequest lockDump() throws MalformedURLException, TTException {
        XMLRequest returnXML = new SymSysIndexMaintenance().lockDump(this);
        return returnXML;
    }

    public XMLRequest unlockDump() throws MalformedURLException, TTException {
        XMLRequest returnXML = new SymSysIndexMaintenance().unlockDump(this);
        return returnXML;
    }

    public String getKey() {
        return String.format(keyFormat, this.getColumn("Reports"), this.getColumn("Storage"));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ImageDescriptor tempImage;
            if (this.JobnameImage == null && (tempImage = Activator.getDefault().getImageRegistry().getDescriptor("com.ca.symdump.system.icon")) != null) {
                this.JobnameImage = tempImage.createImage(true);
            }
            return this.JobnameImage;
        }
        return null;
    }

    protected void doClose() {
        ServerConnect connect = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("uuid", this.getUuid());
        try {
            connect.connect("term", map, false);
        }
        catch (Exception exception) {}
    }

    public Data getData(DumpTreeNode node) {
        try {
            MFAddress address = new MFAddress(node.getMiscData());
            Data data = this.getData(address);
            data.setTitle(node.getTitle());
            data.setTooltipText(node.getFullTooltipText());
            return data;
        }
        catch (Exception e) {
            this.log.log(Level.FINE, e.getClass().getSimpleName(), e);
            return null;
        }
    }

    public IWatchData getMapData(DumpTreeNode node, IWorkbenchPart part) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream(4096);
        MFAddress address = MFAddress.ZERO_ADDR;
        MFAddress nextAddress = MFAddress.ZERO_ADDR;
        ServerConnect connect = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("uuid", this.getUuid());
        map.put("mapd", node.getMiscData());
        XMLRequest xml = new XMLRequest();
        XMLRequest xmlEx = new XMLRequest();
        Data parent = new Data("DSECT");
        parent.setMemoryManager(this.getMemoryManager());
        if (node.getParent().getTitle().matches("Loaded Programs")) {
            this.disaPgm(part, node);
            return null;
        }
        try {
            xml = connect.connect("mapd", map, false);
            Element element = xml.getCommand();
            NodeList nodes = element.getElementsByTagName("MapD");
            int index = 0;
            while (index < nodes.getLength()) {
                Element dline = (Element)nodes.item(index);
                if (index == 0) {
                    address = new MFAddress(dline.getAttribute("MFAddress"));
                    this.log.log(Level.FINE, "Address {0}", address);
                    parent = new Data(new byte[1], address, node.getTitle());
                    parent.setProperty(dline.getAttribute("Props"));
                    parent.setTooltipText(node.getFullTooltipText());
                    parent.setMemoryManager(this.getMemoryManager());
                } else {
                    String data;
                    byte[] bytes;
                    String nextAddr;
                    String currAddr = dline.getAttribute("MFAddress");
                    address = currAddr != "" ? new MFAddress(currAddr) : MFAddress.ZERO_ADDR;
                    Element nextLine = (Element)nodes.item(index + 1);
                    if (nextLine != null && (nextAddress = (nextAddr = nextLine.getAttribute("MFAddress")) != "" ? new MFAddress(nextAddr) : MFAddress.ZERO_ADDR).subtract(address) > 16L && !MFAddress.ZERO_ADDR.equals((Object)address)) {
                        map.put("uuid", this.getUuid());
                        map.put("dump", address.toString());
                        xmlEx = connect.connect("dump", map, false);
                        Element elementEx = xmlEx.getCommand();
                        NodeList nodesEx = elementEx.getElementsByTagName("Data");
                        int i = 0;
                        while (i < nodesEx.getLength()) {
                            Element dlineEx = (Element)nodesEx.item(i);
                            String data2 = dlineEx.getAttribute("Data");
                            byte[] bytes2 = HexUtil.HextoBytes((String)data2);
                            if (bytes2 != null && bytes2.length > 0) {
                                writer.write(bytes2);
                            }
                            ++i;
                        }
                    }
                    if ((bytes = HexUtil.HextoBytes((String)(data = dline.getAttribute("Hex")))) != null && bytes.length > 0) {
                        writer.write(bytes);
                    }
                    String label = dline.getAttribute("Label");
                    if (index != 0) {
                        String value = "+";
                        String offset = dline.getAttribute("Offset");
                        if (offset == "") {
                            value = "        ";
                            address = MFAddress.ZERO_ADDR;
                        } else {
                            value = String.valueOf(value) + offset;
                        }
                        label = String.format("%s %s", value, label);
                    }
                    Data child = new Data(writer.toByteArray(), address, label);
                    child.setProperty(dline.getAttribute("Props"));
                    child.setMemoryManager(this.getMemoryManager());
                    parent.addChild(child);
                    writer.reset();
                }
                ++index;
            }
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        return parent;
    }

    public String getSymDumpName() {
        return "CA SymDump System";
    }

    public IMemoryManager getMemoryManager() {
        if (this.dumpTreeNode == null) {
            this.memoryManager = null;
        } else if (this.memoryManager == null) {
            this.memoryManager = new SystemMemory(this.dumpTreeNode);
        }
        return this.memoryManager;
    }

    private Object disaPgm(IWorkbenchPart part, DumpTreeNode node) {
        IWorkbenchPage page = part.getSite().getPage();
        IViewPart viewPart = null;
        if (node.hasReport()) {
            IViewReference viewRef = page.findViewReference("com.ca.symdump.ui.views.reportsview", node.getAbend().getID());
            if (viewRef != null) {
                viewPart = viewRef.getView(true);
                if (viewPart instanceof ReportView) {
                    ReportView viewer = (ReportView)viewPart;
                    viewer.goTop(node);
                } else {
                    this.log.log(Level.FINE, "view not right class");
                }
            }
        } else {
            XMLRequest xml = this.getDisaReport(node);
            int result = xml.getErrorLevel();
            if (result != 0) {
                String title = "Request Failed for " + node.getText();
                if (result < 8) {
                    MessageDialog.openWarning(null, (String)title, (String)xml.getErrorMessage());
                } else {
                    TT_ErrorDialog.openError(null, (String)title, (String)xml.getErrorMessage());
                }
                return null;
            }
            viewPart = this.buildView(page, xml, node);
        }
        page.activate(viewPart);
        page.activate(part);
        return null;
    }

    protected IViewPart buildView(IWorkbenchPage page, XMLRequest xml, DumpTreeNode node) {
        try {
            IViewPart viewPart = page.showView("com.ca.symdump.ui.views.reportsview", node.getAbend().getID(), 1);
            if (viewPart instanceof ReportView) {
                ReportView viewer = (ReportView)viewPart;
                Document document = BuildDocument.buildDocument((XMLRequest)xml);
                node.insertReport(document, true);
                viewer.setContent(node.getAbend().getDocument(), node);
                viewer.goTop(node);
                return viewPart;
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        return null;
    }

    public Data getData(MFAddress address) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream(4096);
        ServerConnect connect = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("uuid", this.getUuid());
        map.put("dump", address.getText(false));
        XMLRequest xml = new XMLRequest();
        try {
            xml = connect.connect("dump", map, false);
            Element element = xml.getCommand();
            NodeList nodes = element.getElementsByTagName("Data");
            int index = 0;
            while (index < nodes.getLength()) {
                Element dline = (Element)nodes.item(index);
                if (index == 0) {
                    address = new MFAddress(dline.getAttribute("MFAddress"));
                    this.log.log(Level.FINE, "Address {0}", address.toString());
                }
                String data = dline.getAttribute("Data");
                this.log.log(Level.FINE, "Data {0}", data);
                byte[] bytes = HexUtil.HextoBytes((String)data);
                this.log.log(Level.FINE, "Data Dump", (Object)bytes);
                writer.write(bytes);
                ++index;
            }
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        Data data = new Data(writer.toByteArray(), address, "");
        data.setStride(32);
        data.setMemoryManager(this.getMemoryManager());
        return data;
    }

    public RunGetTrace getGetTrace(DumpTreeNode node) {
        return new SymSysRunGetTrace(node);
    }
}

