/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.ui.lister.util;

import com.ca.testingtools.protsym.Activator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class ReservedWordProvider {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static final int COBOL_RESERVED_WORDS = 1;
    public static final int COBOL_COMMENT_WORDS = 2;
    public static final int CICS_RESERVED_WORDS = 5;
    public static final int ASM_RESERVED_WORDS = 10;
    public static final int ASM_MACHINE_WORDS = 11;
    public static final int PLI_RESERVED_WORDS = 15;
    private static final String ATTRIBUTE_DELIMITER = ",";
    private static final String COBOL_ELEMENT_NAME = "COBOL";
    private static final String CICS_ELEMENT_NAME = "CICS";
    private static final String ASM_ELEMENT_NAME = "ASSEMBLER";
    private static final String ASM_MACHINE_ELEMENT_NAME = "ASM_MACHINE";
    private static final String PLI_ELEMENT_NAME = "PLI";
    private static final String ATTRIBUTE_NAME = "words";
    private static final HashMap<String, Object> cobolWords = new HashMap();
    private static final HashMap<String, Object> asmMachWords = new HashMap();
    private static final HashMap<String, Object> asmWords = new HashMap();
    private static final HashMap<String, Object> pliWords = new HashMap();

    static {
        try {
            String word;
            int n;
            int n2;
            String[] stringArray;
            String[] str;
            IMemento child;
            IMemento[] children;
            Bundle bundle = Activator.getDefault().getBundle();
            URL urlEntry = bundle.getEntry("reservedwords.xml");
            InputStream urlStream = urlEntry.openStream();
            InputStreamReader urlReader = new InputStreamReader(urlStream);
            XMLMemento memento = XMLMemento.createReadRoot((Reader)urlReader);
            IMemento[] iMementoArray = children = memento.getChildren(COBOL_ELEMENT_NAME);
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                child = iMementoArray[n4];
                stringArray = str = child.getString(ATTRIBUTE_NAME).split(ATTRIBUTE_DELIMITER);
                n2 = str.length;
                n = 0;
                while (n < n2) {
                    word = stringArray[n];
                    if ((word = word.trim()).length() > 0) {
                        cobolWords.put(word, null);
                    }
                    ++n;
                }
                ++n4;
            }
            iMementoArray = children = memento.getChildren(ASM_MACHINE_ELEMENT_NAME);
            n3 = children.length;
            n4 = 0;
            while (n4 < n3) {
                child = iMementoArray[n4];
                stringArray = str = child.getString(ATTRIBUTE_NAME).split(ATTRIBUTE_DELIMITER);
                n2 = str.length;
                n = 0;
                while (n < n2) {
                    word = stringArray[n];
                    if ((word = word.trim()).length() > 0) {
                        asmWords.put(word, null);
                    }
                    ++n;
                }
                ++n4;
            }
            iMementoArray = children = memento.getChildren(ASM_ELEMENT_NAME);
            n3 = children.length;
            n4 = 0;
            while (n4 < n3) {
                child = iMementoArray[n4];
                stringArray = str = child.getString(ATTRIBUTE_NAME).split(ATTRIBUTE_DELIMITER);
                n2 = str.length;
                n = 0;
                while (n < n2) {
                    word = stringArray[n];
                    if ((word = word.trim()).length() > 0) {
                        asmWords.put(word, null);
                    }
                    ++n;
                }
                ++n4;
            }
            iMementoArray = children = memento.getChildren(PLI_ELEMENT_NAME);
            n3 = children.length;
            n4 = 0;
            while (n4 < n3) {
                child = iMementoArray[n4];
                stringArray = str = child.getString(ATTRIBUTE_NAME).split(ATTRIBUTE_DELIMITER);
                n2 = str.length;
                n = 0;
                while (n < n2) {
                    word = stringArray[n];
                    if ((word = word.trim()).length() > 0) {
                        pliWords.put(word, null);
                    }
                    ++n;
                }
                ++n4;
            }
            urlReader.close();
            urlStream.close();
        }
        catch (Exception e) {
            String sourceClass = ReservedWordProvider.class.getName();
            Logger log = Logger.getLogger(sourceClass);
            log.log(Level.SEVERE, "ReservedWordsProvider()", e);
        }
    }

    public static boolean containsWord(String word, int wordGroup) {
        switch (wordGroup) {
            case 1: {
                return cobolWords.containsKey(word);
            }
            case 10: {
                return asmWords.containsKey(word);
            }
            case 11: {
                return asmMachWords.containsKey(word);
            }
            case 15: {
                return pliWords.containsKey(word);
            }
        }
        return false;
    }
}

