/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.selection.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterSelection;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.GenericLayoutBox;
import com.ca.filemaster.common.GenericSelectionCriteriaBox;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunPutSelectionMem;
import com.ca.filemaster.selection.views.SelectionView;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateUpdateSelcritWizardPage
extends FileMasterWizard
implements ModifyListener {
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.createselcrit";
    protected final String CONTEXT_Update_HELP_ID = "com.ca.filemaster.help.updateselcrit";
    private FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
    private FMSelectionTreeModel fmselModel = FMSelectionTreeModel.getInstance();
    protected TestingToolsWizardDialog dialog = null;
    private String initDSName;
    private FileMasterServer server;
    private FileMasterDataset FmLayoutDataset = new FileMasterDataset(null);
    private FileMasterMember FmLayoutMember = new FileMasterMember(null);
    private String memberName;
    private String description;
    private boolean isDirectoryListCaller = false;
    private Label serverNameLabel;
    private Label memberNameLabel;
    private Label descriptionLabel;
    private Combo serverNameCombo;
    private Text dataSetText;
    public Text memberNameText;
    private Text descriptionText;
    protected Button memberSelectBtn;
    private boolean isNewSelCrit;
    private String error = "";
    private String layoutDS;
    private String layoutMem;
    private String selcondition;
    private GenericSelectionCriteriaBox genericSelCrit;
    private GenericLayoutBox genericLayout;
    private Element msgElement;
    private Element rcElement;
    private String message;
    private String writeExistingSelMbr = "N";
    private String isNewMember = "";
    public boolean result;

    public CreateUpdateSelcritWizardPage(String pageName, FileMasterServer server, String datasetName, String memberName, String description, String layoutDS, String layoutMem, boolean isNewSelCrit) {
        super(pageName, datasetName, server);
        this.initDSName = datasetName;
        this.memberName = memberName;
        this.description = description;
        this.server = server;
        this.isNewSelCrit = isNewSelCrit;
        this.layoutDS = layoutDS;
        this.layoutMem = layoutMem;
        if (!isNewSelCrit) {
            this.setTitle(String.valueOf(this.initDSName) + "(" + memberName + ") " + "Update");
        } else {
            this.setTitle(pageName);
        }
    }

    public CreateUpdateSelcritWizardPage(String pageName, FileMasterServer server, String datasetName, String memberName, String description, String layoutDS, String layoutMem, String selCondition, boolean isNewSelCrit) {
        super(pageName, datasetName, server);
        this.initDSName = datasetName;
        this.memberName = memberName;
        this.isNewMember = memberName;
        this.description = description;
        this.server = server;
        this.selcondition = selCondition;
        this.layoutDS = layoutDS;
        this.layoutMem = layoutMem;
        this.setTitle(pageName);
        if (!isNewSelCrit) {
            this.setTitle(String.valueOf(this.initDSName) + "(" + memberName + ") " + "Update");
        } else {
            this.setTitle(pageName);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        ImportSelCritWizardPage.setConditions((String)"");
        this.setControl((Control)this.container);
        if (this.isNewSelCrit) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.createselcrit");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.updateselcrit");
        }
        GridData dataSetCompositeGridData = new GridData(16384, 0x1000000, true, false, 1, 1);
        dataSetCompositeGridData.widthHint = 685;
        this.dataSetComposite.setLayoutData((Object)dataSetCompositeGridData);
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Combo(this.dataSetComposite, 2056);
        GridData gd_serverNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.serverNameCombo.setLayoutData((Object)gd_serverNameCombo);
        this.serverNameCombo.setItems(this.getServers());
        if (this.getContainer().getCurrentPage() != null && this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Select Server")) {
            this.serverNameCombo.setText(this.server.getText());
        } else if (this.serverNameCombo.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer((String)"ServerCreateUpdateSelcritWizardPage");
            int count = 0;
            while (count < this.serverNameCombo.getItemCount()) {
                if (this.serverNameCombo.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.serverNameCombo.setText(this.serverNameCombo.getItem(count).toString());
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.serverNameCombo.setText(this.serverNameCombo.getItem(0));
            }
        }
        this.changeServer();
        this.serverNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateUpdateSelcritWizardPage.this.changeServer();
                CreateUpdateSelcritWizardPage.this.setPageComplete(CreateUpdateSelcritWizardPage.this.canFlipToNextPage());
                CreateUpdateSelcritWizardPage.this.genericSelCrit.setServer(CreateUpdateSelcritWizardPage.this.server);
            }
        });
        if (this.isDirectoryListCaller) {
            this.serverNameCombo.setEnabled(false);
        }
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        if (this.isNewSelCrit) {
            super.createDataSet();
            FMHistory.intializeComboBoxes((Combo)this.dataSetCombo, (String)"UpdateSelCritDSN");
            this.dataSetCombo.setText(this.initDSName);
            this.dataSetCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateUpdateSelcritWizardPage.this.initDSName = CreateUpdateSelcritWizardPage.this.dataSetCombo.getText();
                    CreateUpdateSelcritWizardPage.this.setPageComplete(CreateUpdateSelcritWizardPage.this.canFlipToNextPage());
                }
            });
        } else {
            this.dataSetLabel = new Label(this.dataSetComposite, 0);
            this.dataSetLabel.setText("&Data set name:");
            this.dataSetText = new Text(this.dataSetComposite, 2056);
            this.dataSetText.addModifyListener((ModifyListener)this);
            this.dataSetText.addVerifyListener((VerifyListener)new verifytoUpperCase());
            this.dataSetText.setText(this.initDSName);
            this.dataSetText.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
            TextUtil.setWidth((Text)this.dataSetText, (int)37);
            this.dataSetText.setTextLimit(44);
            new Label(this.dataSetComposite, 0);
            new Label(this.dataSetComposite, 0);
        }
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel.setText("&Member name:");
        this.memberNameText = new Text(this.dataSetComposite, 2048);
        GridData gd_memberNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.memberNameText.setLayoutData((Object)gd_memberNameCombo);
        this.memberNameText.setText(this.memberName);
        this.memberNameText.addModifyListener((ModifyListener)this);
        this.memberNameText.setTextLimit(8);
        this.memberNameText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.descriptionLabel = new Label(this.dataSetComposite, 0);
        this.descriptionLabel.setText("Descri&ption:");
        this.descriptionText = new Text(this.dataSetComposite, 2048);
        GridData gd_descriptionText = new GridData(4, 4, false, false, 1, 1);
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        this.descriptionText.setText(this.description);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.descriptionText.setTextLimit(40);
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.genericLayout = new GenericLayoutBox(this.server.getName(), (Object)this, this.layoutDS, this.layoutMem, "");
        this.genericLayout.createLayoutBox(this.container, "", "Layout vie&w:", "Da&ta set name:", "&Select...", "DSN &List...", "Member n&ame:", "S&elect...");
        this.genericLayout.setLayoutDataSetName(this.layoutDS);
        this.genericLayout.setLayoutMemberName(this.layoutMem);
        this.genericLayout.layoutDataSetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateUpdateSelcritWizardPage.this.layoutDS = ((CreateUpdateSelcritWizardPage)CreateUpdateSelcritWizardPage.this).genericLayout.layoutDataSetCombo.getText();
                CreateUpdateSelcritWizardPage.this.setPageComplete(CreateUpdateSelcritWizardPage.this.isPageComplete());
            }
        });
        this.genericLayout.layoutMemberNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateUpdateSelcritWizardPage.this.layoutMem = ((CreateUpdateSelcritWizardPage)CreateUpdateSelcritWizardPage.this).genericLayout.layoutMemberNameCombo.getText();
                CreateUpdateSelcritWizardPage.this.setPageComplete(CreateUpdateSelcritWizardPage.this.isPageComplete());
            }
        });
        this.genericSelCrit = this.isNewSelCrit ? new GenericSelectionCriteriaBox(this.server.getName(), (Object)this, this.genericLayout, false, this.dataSetCombo.getText(), this.memberNameText.getText()) : new GenericSelectionCriteriaBox(this.server.getName(), (Object)this, this.genericLayout, false, this.dataSetText.getText(), this.memberNameText.getText());
        this.genericSelCrit.createConditionBox(this.container, "La&yout...", "&Validate", "&Import...");
        if (this.getContainer().getCurrentPage() != null && this.getContainer().getCurrentPage().getName().equals("Select Server")) {
            this.genericSelCrit.AddLayoutSelCondition(this.selcondition);
        } else {
            this.getShell().getDefaultButton().setText("OK");
        }
        this.setPageComplete(this.isPageComplete());
        if (this.isNewSelCrit) {
            this.genericSelCrit.setLayoutButtonEnabled(false);
            this.dataSetCombo.setFocus();
        } else if (this.memberNameText != null) {
            if (this.genericLayout.layoutDataSetCombo.getText().length() > 0) {
                this.genericLayout.setDsnActive();
            } else {
                this.genericLayout.layoutViewRadio.setSelection(true);
                this.genericLayout.layoutViewCombo.setEnabled(true);
                this.genericLayout.layoutDsnRadio.setSelection(false);
                this.genericLayout.layoutDataSetCombo.setEnabled(false);
                this.genericLayout.layoutMemberNameCombo.setEnabled(false);
            }
        }
        if (!this.isNewSelCrit) {
            this.genericSelCrit.setFocus();
        }
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.fmstModel.getServers().length];
        int serverCount = 0;
        while (serverCount < this.fmstModel.getServers().length) {
            listOfServers[serverCount] = this.fmstModel.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        if (this.getContainer().getCurrentPage() != null && this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Select Server")) {
            this.serverNameCombo.setText(this.server.getText());
        } else if (!this.isDirectoryListCaller) {
            this.server = (FileMasterServer)this.fmstModel.getServers()[0].getServer();
        }
        this.serverChanged(this.server);
        return listOfServers;
    }

    public void serverChanged(FileMasterServer server) {
        super.serverChanged(server);
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverNameCombo.getText())) {
                this.server = (FileMasterServer)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class);
                this.serverChanged(this.server);
                break;
            }
            ++servers;
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean doFinish() {
        String[] selCond = this.genericSelCrit.getSelCriteriaBoxText().split("\\r\\n");
        int count = 0;
        while (count < selCond.length) {
            if (selCond[count].trim().length() > 74) {
                MessageDialog.openError(null, (String)"Selection Criteria Validation Error", (String)"Exceeded maximum number of characters per line. Only 74 is allowed.");
                return false;
            }
            ++count;
        }
        FMHistory.clearList((String)"ServerCreateUpdateSelcritWizardPage");
        FMHistory.insertHistory((Combo)this.serverNameCombo, (String)"ServerCreateUpdateSelcritWizardPage");
        if (this.isNewSelCrit) {
            FMHistory.insertHistory((Combo)this.dataSetCombo, (String)"UpdateSelCritDSN");
        }
        this.changeServer();
        ImportSelCritWizardPage.conditions = "";
        FileMasterDataset fmdataset = new FileMasterDataset(null);
        if (this.isNewSelCrit) {
            fmdataset.setName(this.dataSetCombo.getText().trim());
        } else {
            fmdataset.setName(this.dataSetText.getText().trim());
        }
        fmdataset.setDsOrg("PDS");
        FileMasterMember fmmember = new FileMasterMember(null);
        fmmember.setName(this.memberNameText.getText().trim());
        fmmember.setType("SELECT");
        String layoutDS = "";
        String layoutMem = "";
        if (this.genericLayout.isLayoutViewSelected() && !this.genericLayout.getLayoutViewComboString().equalsIgnoreCase("(none)")) {
            layoutDS = this.genericLayout.getLayoutViewComboString().split("\\(.+?\\)")[0];
            layoutMem = this.genericLayout.getLayoutViewComboString().split(".+?\\(")[1];
            layoutMem = layoutMem.substring(0, layoutMem.length() - 1);
        } else if (this.genericLayout.isLayoutSet()) {
            layoutDS = this.genericLayout.getLayoutDataSetName().trim();
            layoutMem = this.genericLayout.getLayoutMemberName().trim();
        }
        this.FmLayoutDataset.setName(layoutDS);
        this.FmLayoutMember.setName(layoutMem);
        FileMasterSelection fmselect = null;
        Element fmselectElement = null;
        TT_TreeItem dsItem = null;
        TT_TreeItem memItem = null;
        boolean result = true;
        this.genericSelCrit.setDisplayValidationErrors(false);
        if (this.genericSelCrit.validateButton.isEnabled() || this.genericSelCrit.getSelConditionText().length() == 0) {
            this.FmLayoutDataset = new FileMasterDataset(null);
            this.FmLayoutMember = new FileMasterMember(null);
            this.FmLayoutDataset.setName(layoutDS);
            this.FmLayoutMember.setName(layoutMem);
            XMLRequest ValidateXml = this.genericSelCrit.ValidateSelCriteria(this.server, this.FmLayoutDataset, this.FmLayoutMember, this.genericSelCrit.getSelConditionText());
            if (ValidateXml != null) {
                if (this.genericSelCrit.returnCode != null && this.genericSelCrit.returnCode.getFirstChild().getNodeValue().equals("16")) {
                    String question = "A syntax error has been detected in the selection conditions. Do you want to save this Selection Criteria Member?";
                    if (this.genericSelCrit.getSelConditionText().isEmpty()) {
                        question = "The record selection criteria is empty. Do you want to save this Selection Criteria Member?";
                    }
                    result = MessageDialog.openQuestion(null, (String)" Save Selection Criteria Member", (String)question);
                }
            } else {
                result = false;
            }
        }
        if (result) {
            if (this.isNewMember.equals(this.memberNameText.getText())) {
                this.writeExistingSelMbr = "Y";
            }
            XMLRequest xml = this.putSelectionMem();
            this.handleResponse(xml);
            boolean respond = true;
            String title = " Save Selection Criteria Member";
            if (this.msgElement != null && this.msgElement.getFirstChild().getNodeValue().startsWith("CAWA679E")) {
                title = String.valueOf(title) + " Error";
                TT_ErrorDialog.openError(null, (String)"Error", (String)title, (Throwable)new Throwable(this.msgElement.getFirstChild().getNodeValue()));
                respond = false;
            } else if (this.msgElement != null && this.msgElement.getFirstChild().getNodeValue().startsWith("CAWA695I")) {
                String question = String.valueOf(this.message) + "Do you want to overwrite the existing member?";
                respond = MessageDialog.openQuestion(null, (String)title, (String)question);
                if (respond) {
                    this.writeExistingSelMbr = "Y";
                    xml = this.putSelectionMem();
                    this.handleResponse(xml);
                    if (this.msgElement.getFirstChild().getNodeValue().startsWith("CAWA679E")) {
                        title = String.valueOf(title) + " Error";
                        TT_ErrorDialog.openError(null, (String)"Error", (String)title, (Throwable)new Throwable(this.msgElement.getFirstChild().getNodeValue()));
                        respond = false;
                    }
                } else {
                    this.writeExistingSelMbr = "N";
                }
            } else if (this.rcElement != null && this.rcElement.getFirstChild().getNodeValue().equals("16")) {
                title = String.valueOf(title) + " Error";
                TT_ErrorDialog.openError(null, (String)"Error", (String)title, (Throwable)new Throwable(this.msgElement.getFirstChild().getNodeValue()));
                respond = false;
            }
            if (respond) {
                if (this.isNewSelCrit || !this.isNewSelCrit && !this.memberName.equalsIgnoreCase(this.memberNameText.getText().trim())) {
                    dsItem = this.fmselModel.findObject((Object)fmdataset);
                    if (dsItem == null) {
                        FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN((String)fmdataset.getName(), (String)"", (FileMasterServer)this.server);
                        if (!CommonMFCalls.RETURN_CODE.equals("0")) {
                            return false;
                        }
                        if (FMDataSet.getDsOrg().equalsIgnoreCase("PDS") || FMDataSet.getDsOrg().equalsIgnoreCase("PDSE")) {
                            Element dsElement = this.fmselModel.addDataset(null, fmdataset);
                            dsItem = this.fmselModel.insertDataset(dsElement);
                        } else {
                            TT_ErrorDialog.openError(null, (String)"Error", (String)"FILE NOT A PDS", (Throwable)new Throwable("THE SPECIFIED DATASET '" + FMDataSet.getName() + "' IS NOT A PARTITIONED DATASET"));
                            return false;
                        }
                    }
                    if (this.fmselModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                        this.fmselModel.removeItem((Object)fmmember);
                    }
                    Element memElement = this.fmselModel.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType(), this.descriptionText.getText().trim(), layoutDS, layoutMem);
                    memItem = this.fmselModel.insertMember(dsItem, memElement);
                } else {
                    dsItem = this.fmselModel.findObject((Object)fmdataset);
                    int i = 0;
                    while (i < dsItem.getChildren().length) {
                        if (((TT_TreeItem)dsItem.getChildren()[i]).getName().equalsIgnoreCase(this.memberNameText.getText().trim())) {
                            memItem = (TT_TreeItem)dsItem.getChildren()[i];
                            break;
                        }
                        ++i;
                    }
                    memItem.getElement().setAttribute("description", this.descriptionText.getText().trim());
                    int numChildren = memItem.getChildren().length;
                    int i2 = numChildren - 1;
                    while (i2 >= 0) {
                        this.fmselModel.removeItem((Object)((TT_TreeItem)memItem.getChildren()[i2]), memItem);
                        --i2;
                    }
                }
                memItem.getElement().setAttribute("layoutDS", layoutDS);
                memItem.getElement().setAttribute("layoutMem", layoutMem);
                int i = 0;
                while (i < selCond.length) {
                    if (!selCond[i].trim().isEmpty()) {
                        fmselect = new FileMasterSelection(null);
                        fmselect.setName(selCond[i]);
                        fmselectElement = this.fmselModel.addSelection(memItem.getElement(), fmselect.getName());
                        this.fmselModel.insertSelection(memItem, fmselectElement);
                    }
                    ++i;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Shell shell = window.getShell();
                shell.setMinimized(false);
                shell.forceActive();
                shell.forceFocus();
                try {
                    IWorkbenchPage page = window.getActivePage();
                    IViewPart view = page.showView("com.ca.filemaster.selection.views.selectionview");
                    if (view instanceof SelectionView) {
                        TreeViewer viewer = ((SelectionView)view).getViewer();
                        if (viewer != null) {
                            TT_TreeItem selection = this.fmselModel.findObjectInTree((Object)fmmember, this.fmselModel.findObject((Object)fmdataset));
                            Object[] expandedElements = viewer.getExpandedElements();
                            viewer.setInput((Object)this.fmselModel.getDatasets());
                            viewer.refresh(true);
                            viewer.setExpandedElements(expandedElements);
                            viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                            view = page.showView("com.ca.filemaster.selection.views.selectionview");
                            page.activate((IWorkbenchPart)view);
                            page.bringToTop((IWorkbenchPart)view);
                        }
                        view.setFocus();
                    }
                }
                catch (PartInitException partInitException) {}
                this.fmselModel.save();
                return true;
            }
        }
        return false;
    }

    private void handleResponse(XMLRequest xml) {
        if (xml != null) {
            Element element = xml.getRoot();
            NodeList messages = element.getElementsByTagName("Message");
            NodeList retCode = element.getElementsByTagName("ReturnCode");
            this.message = "";
            if (messages.getLength() > 0) {
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    this.msgElement = (Element)msgNode;
                    this.message = String.valueOf(this.message) + this.getTagValue("Message", this.msgElement);
                    ++i;
                }
                Node rcNode = retCode.item(0);
                this.rcElement = (Element)rcNode;
            }
        }
    }

    private XMLRequest putSelectionMem() {
        RunPutSelectionMem runner = new RunPutSelectionMem(this.server, this.initDSName, this.memberNameText.getText(), this.genericSelCrit.getContent(), this.descriptionText.getText(), this.writeExistingSelMbr);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        return runner.getXml();
    }

    private String getTagValue(String sTag, Element msgElement) {
        NodeList nlList = msgElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isPageComplete() {
        boolean prevError;
        boolean bl = prevError = !super.isPageComplete();
        if (this.memberNameText != null && !prevError && this.error.length() == 0) {
            switch (Validator.member((String)this.memberNameText.getText(), (boolean)true)) {
                case 6: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameText.getText(), (boolean)true)] + "\n ";
                    break;
                }
                case 7: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameText.getText(), (boolean)true)] + "\n ";
                    break;
                }
                case 5: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameText.getText(), (boolean)true)] + "\n ";
                    break;
                }
            }
            if (this.error.length() == 0 && this.descriptionText.getText().trim().equalsIgnoreCase("")) {
                this.error = String.valueOf(this.error) + "Missing description\n ";
            }
        }
        if (!prevError && this.error.length() == 0 && this.genericLayout != null) {
            this.error = this.genericLayout.validateLayoutBox();
        }
        if (!prevError && this.error.length() == 0 && this.genericSelCrit != null) {
            this.error = this.genericSelCrit.validateCriteriaBox();
        }
        if (this.error.length() > 0) {
            if (this.genericSelCrit != null) {
                this.genericSelCrit.enableSelCrtButton(false);
            }
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(this.error);
                this.error = new String();
                return false;
            }
            if (!this.getErrorMessage().equalsIgnoreCase(this.error)) {
                this.setErrorMessage(this.error);
                this.error = new String();
                return false;
            }
            this.error = new String();
            return false;
        }
        if (prevError) {
            if (this.genericSelCrit != null) {
                this.genericSelCrit.enableSelCrtButton(false);
            }
        } else if (this.genericSelCrit != null) {
            this.genericSelCrit.enableSelCrtButton(true);
        }
        if (prevError) return false;
        this.setErrorMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        return !this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Selection Condition Update");
    }

    public void AddLayoutSelCondition(String layoutSelCondition) {
        this.genericSelCrit.setText(layoutSelCondition);
    }

    public String getSelcondition() {
        return this.selcondition;
    }

    public void setSelcondition(String selcondition) {
        this.selcondition = selcondition;
    }
}

