/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.selection.wizards;

import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.selection.wizards.CreateUpdateSelcritWizardPage;
import com.ca.filemaster.selection.wizards.CreateUpdateServerWizardPage;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateUpdateSelcritWizard
extends Wizard
implements INewWizard {
    private CreateUpdateSelcritWizardPage page1;
    private FMSelectionTreeModel selectionModel = FMSelectionTreeModel.getInstance();
    private boolean isSelectionTreeItem = false;
    private FileMasterServer server = null;
    private FileMasterDataset dataset = null;
    private FileMasterMember member = null;
    private TT_TreeItem treeItem;
    private boolean isNewSelCrit = false;
    private String title;
    private CreateUpdateServerWizardPage page2;

    public CreateUpdateSelcritWizard(boolean isNewSelCrit) {
        this.isNewSelCrit = isNewSelCrit;
        this.title = isNewSelCrit ? "Create Selection Criteria Member" : "Selection Condition Update";
        this.setWindowTitle(this.title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TrayDialog.setDialogHelpAvailable((boolean)true);
        Object object = selection.getFirstElement();
        if (object != null) {
            this.treeItem = this.selectionModel.findObject(object);
            this.isSelectionTreeItem = true;
            if (this.treeItem != null) {
                if (this.isSelectionTreeItem) {
                    this.server = null;
                    if (this.treeItem.getParent() != null) {
                        if (!this.isNewSelCrit) {
                            this.member = (FileMasterMember)this.treeItem.getAdapter(FileMasterMember.class);
                        }
                        this.dataset = (FileMasterDataset)this.treeItem.getParent().getAdapter(FileMasterDataset.class);
                    } else {
                        this.member = null;
                        this.dataset = (FileMasterDataset)this.treeItem.getAdapter(FileMasterDataset.class);
                    }
                }
            } else {
                this.dataset = null;
                this.member = null;
                this.server = null;
            }
        }
    }

    public void addPages() {
        String datasetName = "";
        String memberName = "";
        String description = "";
        String layoutDS = "";
        String layoutMem = "";
        if (this.dataset != null) {
            this.dataset.setName(this.dataset.getName().trim());
            datasetName = this.dataset.getName();
        }
        if (this.member != null) {
            memberName = this.member.getName();
            description = this.treeItem.getElement().getAttribute("description");
            layoutDS = this.treeItem.getElement().getAttribute("layoutDS");
            layoutMem = this.treeItem.getElement().getAttribute("layoutMem");
        }
        if (this.isNewSelCrit) {
            this.page1 = new CreateUpdateSelcritWizardPage(this.title, this.server, datasetName, memberName, description, layoutDS, layoutMem, this.isNewSelCrit);
            this.addPage((IWizardPage)this.page1);
        } else {
            this.setForcePreviousAndNextButtons(true);
            this.page2 = new CreateUpdateServerWizardPage("Select Server", datasetName, memberName);
            this.addPage((IWizardPage)this.page2);
        }
    }

    public boolean performFinish() {
        if (this.page1 != null) {
            return this.page1.doFinish();
        }
        return ((CreateUpdateSelcritWizardPage)this.page2.getNextPage()).doFinish();
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Select Server")) {
            return false;
        }
        if (this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Create Selection Criteria Member")) {
            return ((CreateUpdateSelcritWizardPage)this.getContainer().getCurrentPage()).isPageComplete();
        }
        return ((CreateUpdateSelcritWizardPage)this.getContainer().getCurrentPage()).isPageComplete();
    }
}

