/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class PerFieldAnalyzerWrapper
extends Analyzer {
    private Analyzer defaultAnalyzer;
    private Map analyzerMap = new HashMap();

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this(defaultAnalyzer, null);
    }

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map fieldAnalyzers) {
        this.defaultAnalyzer = defaultAnalyzer;
        if (fieldAnalyzers != null) {
            this.analyzerMap.putAll(fieldAnalyzers);
        }
        this.setOverridesTokenStreamMethod(PerFieldAnalyzerWrapper.class);
    }

    public void addAnalyzer(String fieldName, Analyzer analyzer) {
        this.analyzerMap.put(fieldName, analyzer);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyzer = (Analyzer)this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.tokenStream(fieldName, reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        Analyzer analyzer = (Analyzer)this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.reusableTokenStream(fieldName, reader);
    }

    public int getPositionIncrementGap(String fieldName) {
        Analyzer analyzer = (Analyzer)this.analyzerMap.get(fieldName);
        if (analyzer == null) {
            analyzer = this.defaultAnalyzer;
        }
        return analyzer.getPositionIncrementGap(fieldName);
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + this.analyzerMap + ", default=" + this.defaultAnalyzer + ")";
    }
}

