/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IParseSource;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.tools.ITHexUtilException;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.tools.XMLFile;
import com.ca.intertest.tools.XMLRequest;
import com.ca.intertest.tools.scanPLI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Element;

abstract class parseSource
implements IParseSource {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final boolean useFullLine = false;
    protected XMLFile xml = null;
    protected Element member = null;
    protected HashMap<Integer, Integer> statementXref = new HashMap(0);
    protected final Statement rootstatement = Statement.emptyStatement();
    protected TreeMap<Element, Object> elements;
    protected IScanSource scansource;
    private int first = -1;
    private int last = 0;
    protected int lang;
    protected int version = 0;
    protected ArrayList<String> structs = new ArrayList();
    protected ArrayList<Integer> structSizes = new ArrayList();
    private int inXref = 0;
    private String saveVar = "";
    protected HashMap<String, String> altVarnames = new HashMap();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    public static String parseSource_0 = "Ordinary Symbol and Literal Cross Reference";
    public static String parseSource_1 = "Macro and Copy Code Source Summary";
    public static String parseSource_2 = "Unreferenced Symbols Defined in CSECTs";
    public static String parseSource_warning = "Import warning at line";
    private static final String[] sema4 = new String[]{parseSource_0, parseSource_1, parseSource_2};
    private static final String[] attrName = new String[]{"name", "length", "structureoffset", "gt_dscid", "gt_dptyp"};

    public parseSource(XMLFile xml, Element member) {
        this.xml = xml;
        this.member = member;
        this.Init();
    }

    protected parseSource() {
    }

    private void Init() {
        comparer comparator = this.getComparator();
        if (comparator == null) {
            comparator = new comparer();
        }
        this.elements = new TreeMap(comparator);
    }

    abstract void parseVariableElement(Element var1);

    abstract Element getParent(Element var1, Element var2);

    abstract void parseLabelElement(Element var1);

    abstract void parseLine(String var1, int var2, int var3);

    abstract int checkLevel1();

    abstract void loadLevel1(Element var1, int var2);

    abstract boolean checkExcludeVariable(Element var1);

    abstract Comparator<Element> getComparator();

    @Override
    public void parseListing(int records, InputStreamReader listing, ZipOutputStream zipwriter, int fixedLength) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)zipwriter, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected");
            logrecord.setParameters(new Object[]{e.getClass()});
            logrecord.setThrown(e);
            this.log.log(logrecord);
            return;
        }
        this.statementXref = new HashMap(records / 4);
        Integer statementnumber = 0;
        LineNumberReader reader = null;
        String line = null;
        int minlength = this.scansource.getSourceLength() + this.scansource.getStmtStart();
        reader = new LineNumberReader(listing);
        try {
            line = this.readLine(reader, fixedLength);
            while (line != null) {
                if (this.lang == 16) {
                    try {
                        this.checkXref(line);
                    }
                    catch (Exception exception) {
                        this.log.info(String.valueOf(parseSource_warning) + line);
                    }
                }
                if ((statementnumber = Integer.valueOf(this.scansource.getStatement(line))) >= 0) {
                    Integer linenumber = reader.getLineNumber();
                    this.last = linenumber;
                    if (this.first == -1) {
                        this.first = this.last;
                    }
                    if (statementnumber > 0) {
                        this.statementXref.put(statementnumber, linenumber);
                    }
                    this.parseLine(line, statementnumber, linenumber);
                }
                out.write(line);
                out.newLine();
                line = this.readLine(reader, fixedLength);
            }
        }
        catch (IOException e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected");
            logrecord.setParameters(new Object[]{e.getClass()});
            logrecord.setThrown(e);
            this.log.log(logrecord);
        }
        try {
            reader.close();
            out.flush();
        }
        catch (IOException iOException) {}
    }

    private String readLine(LineNumberReader reader, int fixedLength) throws IOException {
        if (fixedLength == 0) {
            return reader.readLine();
        }
        char[] line = new char[fixedLength];
        int linesize = reader.read(line, 0, fixedLength);
        if (linesize > 0) {
            int i = linesize - 1;
            while (i > 1 && line[i] == ' ') {
                --i;
            }
            return new String(line, 1, i);
        }
        return "";
    }

    @Override
    public void parseVariables(InputStreamReader variables) {
        Integer length = 0;
        try {
            BufferedReader inReader = new BufferedReader(variables);
            String line = inReader.readLine();
            while (line != null) {
                String[] attributes = line.split(";");
                Element variable = this.xml.createElement("variables");
                String[] stringArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    String[] args = element.split("=", 2);
                    if (args.length == 2) {
                        args[0] = args[0].trim();
                        if (args[0].length() > 0) {
                            args[1] = args[1].trim();
                            if (args[1].length() > 0) {
                                variable.setAttribute(args[0], args[1]);
                            }
                        }
                    }
                    ++n2;
                }
                String value = variable.getAttribute("gt_name");
                if (value.length() != 0 && this.checkExcludeVariable(variable)) {
                    this.parseVariableElement(variable);
                    Integer statement = XMLRequest.getInt("statementnumber", variable);
                    Integer linenum = this.statementXref.get(statement);
                    if (linenum == null) {
                        linenum = 0;
                    }
                    variable.setAttribute("linenumber", linenum.toString());
                    int level = XMLRequest.getInt("level", variable);
                    try {
                        length = this.lang == 16 && level > 1 ? Integer.valueOf(variable.getAttribute("gt_alng")) : Integer.valueOf(XMLRequest.getInt("gt_fsiz", variable) + 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        length = 0;
                    }
                    if (level == 99) {
                        length = 4;
                    }
                    variable.setAttribute("length", length.toString());
                    if (this.lang == 16) {
                        int type = XMLRequest.getInt("gt_fl", variable);
                        if (type == 32) {
                            variable.setAttribute("level", "0");
                        } else if (level == 0) {
                            variable.setAttribute("level", "1");
                        }
                    }
                    this.elements.put(variable, null);
                    this.addVerb(StatementType.VARIABLE.name(), null, statement, 0, linenum, 0);
                }
                line = inReader.readLine();
            }
            inReader.close();
        }
        catch (FileNotFoundException e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected");
            logrecord.setParameters(new Object[]{e.getClass()});
            logrecord.setThrown(e);
            this.log.log(logrecord);
        }
        catch (IOException e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected");
            logrecord.setParameters(new Object[]{e.getClass()});
            logrecord.setThrown(e);
            this.log.log(logrecord);
        }
    }

    @Override
    public void parseLabels(InputStreamReader labels) {
        BufferedReader inReader = new BufferedReader(labels);
        try {
            String line = inReader.readLine();
            while (line != null) {
                String[] attributes = line.split(";");
                boolean found = false;
                Element label = this.xml.createElement("pgmlabel");
                String[] stringArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    String[] args = element.split("=", 2);
                    if (args.length == 2) {
                        args[0] = args[0].trim();
                        if (args[0].length() > 0) {
                            args[1] = args[1].trim();
                            if (args[1].length() > 0) {
                                label.setAttribute(args[0], args[1]);
                                found = true;
                            }
                        }
                    }
                    ++n2;
                }
                if (found) {
                    String value = label.getAttribute("lablstmt");
                    if (this.lang == 16 && "0".equals(value)) {
                        found = false;
                    } else {
                        boolean bl = found = value.length() != 0;
                        if (!found) {
                            value = label.getAttribute("pl1estmt");
                            boolean bl2 = found = value.length() != 0;
                        }
                    }
                    if (found) {
                        Integer statement;
                        Integer linenum;
                        this.parseLabelElement(label);
                        int offset = 0;
                        String disp = label.getAttribute("labldisp");
                        if (disp.length() > 0) {
                            label.setAttribute("statementoffset", disp);
                            try {
                                offset = Integer.parseInt(disp);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if ((linenum = this.statementXref.get(statement = XMLRequest.getInt("statementnumber", label))) == null) {
                            linenum = 0;
                        }
                        label.setAttribute("linenumber", linenum.toString());
                        this.elements.put(label, null);
                        this.addVerb(StatementType.LABEL.name(), null, statement, 0, linenum, offset);
                    }
                }
                line = inReader.readLine();
            }
            inReader.close();
        }
        catch (IOException e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected");
            logrecord.setParameters(new Object[]{e.getClass()});
            logrecord.setThrown(e);
            this.log.log(logrecord);
        }
    }

    @Override
    public void parseVerbs(InputStream verbsfile) {
        byte[] bytes = new byte[this.getVersion() > 0 ? 9 : 5];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int read = 0;
        int offset = 0;
        byte[] buf = new byte[4];
        try {
            read = verbsfile.read(bytes);
            while (read != -1) {
                buffer.position(0);
                byte type = buffer.get();
                int statement = buffer.getInt();
                int subindex = statement % 10;
                statement /= 10;
                if (this.getVersion() > 0) {
                    buffer.get(buf);
                    offset = new BigInteger(buf).intValue();
                } else {
                    offset = 0;
                }
                Integer linenum = this.statementXref.get(new Integer(statement));
                if (linenum == null) {
                    linenum = new Integer(0);
                }
                if (type == 0) {
                    this.addVerb(StatementType.LABEL.name(), null, statement, subindex, linenum, offset);
                } else {
                    this.addVerb(StatementType.VERB.name(), new Byte(type), statement, subindex, linenum, offset);
                }
                read = verbsfile.read(bytes);
            }
            verbsfile.close();
        }
        catch (IOException e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected");
            logrecord.setParameters(new Object[]{e.getClass()});
            logrecord.setThrown(e);
            this.log.log(logrecord);
        }
    }

    @Override
    public void dispose() {
        this.statementXref.clear();
        this.elements.clear();
    }

    protected final void removeUnusedAttrs(Element element, String[] unusedAttrs) {
        String[] stringArray = unusedAttrs;
        int n = unusedAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            element.removeAttribute(item);
            ++n2;
        }
    }

    @Override
    public final void populateXML() {
        Element parent = this.member;
        this.member.setAttribute("firststatement", Integer.toString(this.first));
        this.member.setAttribute("laststatement", Integer.toString(this.last));
        if (this.scansource.getType() == 128) {
            this.member.setAttribute("scantype", Integer.toString(((scanPLI)this.scansource).getScantype()));
        }
        Element symbols = this.xml.createElement("symbols");
        int structCnt = this.checkLevel1();
        parent = (Element)parent.appendChild(symbols);
        String name = "";
        Set<Element> elementSet = this.elements.keySet();
        for (Element item : elementSet) {
            this.loadLevel1(item, structCnt);
            parent = this.getParent(parent, item);
            name = item.getAttribute("name");
            if (name.length() <= 0) continue;
            parent = (Element)parent.appendChild(item);
        }
        Element xref = this.xml.createElement("linenumbers");
        parent = (Element)this.member.appendChild(xref);
        Iterator<Map.Entry<Integer, Integer>> it2 = this.statementXref.entrySet().iterator();
        while (it2.hasNext()) {
            Element item = this.xml.createElement("xref");
            Map.Entry<Integer, Integer> entry = it2.next();
            item.setAttribute("statementnumber", entry.getKey().toString());
            item.setAttribute("linenumber", entry.getValue().toString());
            xref.appendChild(item);
        }
        Element verbtable = this.xml.createElement("statement");
        parent = (Element)this.member.appendChild(verbtable);
        this.rootstatement.sort();
        Statement[] statements = this.rootstatement.getChildren(null);
        int index = 1;
        while (index < statements.length) {
            Integer last = statements[index].getStatement();
            int loopFlag = 0;
            last = last - 1;
            while (loopFlag == 0) {
                if (last < 1) {
                    loopFlag = 2;
                } else if (this.statementXref.containsKey(last)) {
                    loopFlag = 1;
                }
                last = last - 1;
            }
            if (loopFlag == 1) {
                last = last + 1;
                statements[index - 1].setLaststatement(last);
                statements[index - 1].setLastline(this.statementXref.get(last));
            }
            ++index;
        }
        if (statements.length > 0 && this.statementXref.size() > 0) {
            index = statements.length - 1;
            int lastix = statements[index].getStatement();
            while (this.statementXref.containsKey(lastix)) {
                ++lastix;
            }
            statements[index].setLaststatement(--lastix);
            Integer statmentlast = this.statementXref.get(new Integer(lastix));
            if (statmentlast != null) {
                statmentlast = this.statementXref.get(new Integer(lastix + 1));
            }
            if (statmentlast != null) {
                statements[index].setLastline(statmentlast);
            }
        }
        int lastoffset = 0;
        statements = this.rootstatement.getChildren(StatementType.VERB);
        int index2 = 1;
        while (index2 < statements.length) {
            int offset = statements[index2 - 1].getOffset();
            int newoffset = statements[index2].getOffset();
            lastoffset = Math.max(lastoffset, newoffset - 1);
            if ((long)offset != 0L) {
                statements[index2 - 1].setLastOffset(lastoffset);
            }
            if (newoffset > 0) {
                statements[index2].setLastOffset(Integer.MAX_VALUE);
            }
            ++index2;
        }
        this.rootstatement.buildElement(verbtable);
        if (!this.altVarnames.isEmpty()) {
            Element altvarnames = this.xml.createElement("altvarnames");
            parent = (Element)this.member.appendChild(altvarnames);
            Set<String> altKeys = this.altVarnames.keySet();
            for (String item : altKeys) {
                String[] attributes = this.altVarnames.get(item).split(";");
                Element altvar = this.xml.createElement("altvar");
                String[] stringArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String attr = stringArray[n2];
                    String[] args = attr.split("=", 2);
                    if (args.length == 2) {
                        args[0] = args[0].trim();
                        if (args[0].length() > 0) {
                            args[1] = args[1].trim();
                            if (args[1].length() > 0) {
                                altvar.setAttribute(args[0], args[1]);
                            }
                        }
                    }
                    ++n2;
                }
                altvarnames.appendChild(altvar);
            }
        }
    }

    @Override
    public Element getMember() {
        return this.member;
    }

    @Override
    public HashMap<Integer, Integer> getStatementXref() {
        return this.statementXref;
    }

    protected void addVerb(String statementtype, Object data, int statement, int subindex, int linenum, int offset) {
        if (linenum == 0) {
            return;
        }
        Statement candidate = this.rootstatement.hasStatement(statement);
        if (candidate == null) {
            candidate = this.rootstatement;
        } else if (candidate.getType().equals((Object)Enum.valueOf(StatementType.class, statementtype)) && candidate.getSubindex() == subindex && candidate.getLine() == linenum) {
            if (candidate.getOffset() == offset) {
                return;
            }
            candidate.setOffset(offset);
            return;
        }
        Statement child = new Statement(statementtype, statement, subindex, offset);
        child.setLine(linenum);
        child.getType().setData(data);
        candidate.addChild(child);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    private void checkXref(String line) {
        String[] attrValue = new String[5];
        String semi = ";";
        String equ = "=";
        if (this.inXref == 2) {
            return;
        }
        if (this.inXref == 0) {
            int idx = line.indexOf(sema4[0]);
            if (idx > -1) {
                this.inXref = 1;
            }
            return;
        }
        int i = 1;
        while (i < sema4.length) {
            int idx = line.indexOf(sema4[i]);
            if (idx > -1) {
                this.inXref = 2;
                return;
            }
            ++i;
        }
        Character ch0 = Character.valueOf(line.charAt(0));
        if (ch0.charValue() == '=') {
            return;
        }
        String[] tokens = line.split("\\s+");
        if (tokens.length == 1) {
            this.saveVar = tokens[0];
            ch0 = Character.valueOf(this.saveVar.charAt(0));
            if (ch0.charValue() < 'A' || ch0.charValue() > 'Z') {
                this.saveVar = "";
            }
            return;
        }
        if (line.length() < 15) {
            return;
        }
        Character ch = Character.valueOf(line.charAt(14));
        if (ch.charValue() >= '0' && ch.charValue() <= '9') {
            String var;
            if (this.saveVar.length() > 0) {
                var = this.saveVar;
                this.saveVar = "";
            } else {
                var = tokens[0];
            }
            if (var.length() > 0 && (ch0 = Character.valueOf(var.charAt(0))).charValue() >= 'A' && ch0.charValue() <= 'Z') {
                attrValue[0] = var;
                attrValue[1] = tokens[1];
                attrValue[2] = String.valueOf(Long.parseLong(tokens[2], 16));
                attrValue[3] = tokens[3];
                String type = tokens[4];
                byte[] inbytes = new byte[1];
                try {
                    HexUtil.StringtoBytes(type, inbytes);
                    attrValue[4] = HexUtil.toHex(inbytes).toLowerCase();
                }
                catch (ITHexUtilException iTHexUtilException) {
                    attrValue[4] = "";
                }
                StringBuilder sbAttr = new StringBuilder();
                int i2 = 0;
                while (i2 < attrValue.length) {
                    sbAttr.append(String.valueOf(attrName[i2]) + equ + attrValue[i2] + semi);
                    ++i2;
                }
                String attr = sbAttr.toString().substring(0, sbAttr.length() - 1);
                this.altVarnames.put(var, attr);
            }
        }
    }

    private class comparer
    implements Comparator<Element> {
        private comparer() {
        }

        @Override
        public int compare(Element e1, Element e2) {
            Integer e2_v;
            int result = -1;
            Integer e1_v = XMLRequest.getInt("statementnumber", e1);
            if (e1_v.equals(e2_v = XMLRequest.getInt("statementnumber", e2)) && (e1_v = XMLRequest.getInt("statement_sub_number", e1)).equals(e2_v = XMLRequest.getInt("statement_sub_number", e2)) && (e1_v = XMLRequest.getInt("offset", e1)).equals(e2_v = XMLRequest.getInt("offset", e2))) {
                e1_v = XMLRequest.getInt("level", e1);
                e2_v = XMLRequest.getInt("level", e2);
            }
            if ((result = e1_v.compareTo(e2_v)) == 0) {
                result = e1.getAttribute("name").compareTo(e2.getAttribute("name"));
            }
            return result;
        }
    }
}

