/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.ITException;
import java.nio.ByteBuffer;

public class SynchSymbolicMessage
extends DebugMessage
implements IDebugMessage {
    public static final short CANCEL = 2;
    public static final short NOMON = 3;
    public static final short SELECT = 1;
    public static final short LIST = 4;
    public static final short LIST_LOADED = 5;
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static int MESSAGE_SIZE = 61;
    private String DDName;
    private String DSN;
    private byte selection;
    private int date;
    private int time;

    public SynchSymbolicMessage() {
        super(false);
        this.submessageID = 1;
    }

    public String getDDName() {
        return this.DDName == null ? "" : this.DDName.trim();
    }

    public String getDSN() {
        return this.DSN == null ? "" : this.DSN.trim();
    }

    public byte getSelection() {
        return this.selection;
    }

    public void setDDName(String name) {
        this.DDName = name;
    }

    public void setDSN(String dsn) {
        this.DSN = dsn;
    }

    public void setSelection(int selection) {
        this.selection = (byte)selection;
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                super.setSubmessageID(submessageID);
                return;
            }
        }
        throw new ITException("Invalid subtype for " + this.getClass().getSimpleName());
    }

    @Override
    protected short _defaultID() {
        return 42;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.selection = newbuffer.get();
        this.getProgram(newbuffer);
        if (newbuffer.remaining() >= 8) {
            byte[] buf = new byte[8];
            newbuffer.get(buf);
            this.DDName = new String(buf, "IBM1047").trim();
            if (newbuffer.remaining() >= 44) {
                buf = new byte[44];
                newbuffer.get(buf);
                this.DSN = new String(buf, "IBM1047").trim();
            }
        }
    }

    @Override
    protected int _getMessageSize() {
        return MESSAGE_SIZE;
    }

    @Override
    protected String _toString() {
        return String.format("%1$s DDNAME:%2$s DSN:%3$s", this.getProgram(), this.getDDName(), this.getDSN());
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.selection);
        this.buffer.put(this.putProgram());
        this.buffer.put(HexUtil.spaceFill(this.getDDName(), 8).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.getDSN(), 44).getBytes("IBM1047"));
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }
}

