/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class SchedulingUpdateMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected byte func = 0;
    protected byte last = 0;
    protected int hexslot = 0;
    protected byte hexflag = 1;
    protected String database = "D";
    protected String onetime = "Y";
    protected String jobname = "";
    protected String charslot = "";
    protected String userid = "";
    protected String imsUserId = "";
    protected String imsTransaction = "";

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.func);
        this.buffer.put(this.last);
        this.buffer.putShort(Numbers.putUShort(this.hexslot));
        this.buffer.put(this.hexflag);
        this.buffer.put(this.database.getBytes("IBM1047"));
        this.buffer.put(this.onetime.getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.jobname, 8).getBytes("IBM1047"));
        this.buffer.put(this.putProgram());
        this.buffer.put(HexUtil.spaceFill(this.charslot, 2).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.userid, 8).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.imsUserId, 8).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.imsTransaction, 8).getBytes("IBM1047"));
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        try {
            this.func = this.buffer.get();
            this.last = this.buffer.get();
            this.hexslot = Numbers.getUShort(this.buffer.getShort());
            this.hexflag = this.buffer.get();
            byte[] byte1 = new byte[1];
            this.buffer.get(byte1);
            this.database = new String(byte1, "IBM1047");
            byte1 = new byte[1];
            this.buffer.get(byte1);
            this.onetime = new String(byte1, "IBM1047");
            byte[] bytes = new byte[8];
            this.buffer.get(bytes);
            this.jobname = HexUtil.rightTrim(new String(bytes, "IBM1047"));
            this.getProgram(newbuffer);
            byte[] bytes2 = new byte[2];
            this.buffer.get(bytes2);
            this.charslot = HexUtil.rightTrim(new String(bytes2, "IBM1047"));
            bytes = new byte[8];
            this.buffer.get(bytes);
            this.userid = HexUtil.rightTrim(new String(bytes, "IBM1047"));
            bytes = new byte[8];
            this.buffer.get(bytes);
            this.imsUserId = HexUtil.rightTrim(new String(bytes, "IBM1047"));
            bytes = new byte[8];
            this.buffer.get(bytes);
            this.imsTransaction = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        }
        catch (Exception e) {
            throw new ITException(e);
        }
    }

    public byte getFunc() {
        return this.func;
    }

    public void setFunc(byte func) {
        this.func = func;
    }

    public byte getlast() {
        return this.func;
    }

    public void setLast(byte last) {
        this.last = last;
    }

    public int getHexslot() {
        return this.hexslot;
    }

    public void setHexslot(short hexslot) {
        this.hexslot = hexslot;
    }

    public byte getHexflag() {
        return this.hexflag;
    }

    public void setHexflag(byte hexflag) {
        this.hexflag = hexflag;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String sDatabase) {
        this.database = (String.valueOf(sDatabase) + " ").substring(0, 1);
    }

    public String getOnetime() {
        return this.onetime;
    }

    public void setOnetime(String sOnetime) {
        this.onetime = (String.valueOf(sOnetime) + " ").substring(0, 1);
    }

    public String getJobname() {
        if (this.jobname != null) {
            return this.jobname.trim();
        }
        return null;
    }

    public void setJobname(String name) {
        this.jobname = String.format("%-8s", name);
    }

    public String getCharslot() {
        if (this.charslot != null) {
            return this.charslot.trim();
        }
        return null;
    }

    public void setCharslot(String name) {
        this.charslot = String.format("%-2s", name);
    }

    @Override
    protected short _defaultID() {
        return 46;
    }

    @Override
    protected int _getMessageSize() {
        return 2000;
    }

    @Override
    protected String _toString() {
        return null;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getImsUserId() {
        return this.imsUserId;
    }

    public void setImsUserId(String usrId) {
        this.imsUserId = usrId;
    }

    public String getImsTransaction() {
        return this.imsTransaction;
    }

    public void setImsTransaction(String transaction) {
        this.imsTransaction = transaction;
    }
}

