/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.ITException;
import java.nio.ByteBuffer;

public class MonitorMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final short CVMI_MON_OFF = 1;
    public static final short CVMI_MON_ON = 0;
    public static final short CVMI_MON_SUSPEND = 2;
    protected static final int AVAILABLE = 19;
    protected boolean enabled = true;

    public MonitorMessage() {
        this(true);
    }

    public MonitorMessage(boolean useloadmodule) {
        super(useloadmodule);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.submessageID = (short)(!enabled ? 1 : 0);
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 1: {
                this.enabled = false;
            }
            case 0: {
                this.enabled = true;
                break;
            }
            default: {
                throw new ITException("Invalid subtype for message");
            }
        }
        super.setSubmessageID(submessageID);
    }

    @Override
    protected short _defaultID() {
        return 18;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.setSubmessageID(this.submessageID);
        this.getProgram(this.buffer);
        switch (this.buffer.get()) {
            case 2: {
                this.filetype = FileType.TERMID;
                break;
            }
            case 1: {
                this.filetype = FileType.TRANID;
                break;
            }
            default: {
                this.filetype = FileType.PROGID;
            }
        }
        this.getAvailable(this.buffer, 19);
    }

    @Override
    protected int _getMessageSize() {
        return 36;
    }

    @Override
    protected String _toString() {
        String format = "%s %s %s";
        return String.format(format, this.filetype.toString(), this.getProgram(), this.enabled ? "enabled" : "disabled");
    }

    @Override
    protected void buildMessage() throws Exception {
        this.submessageID = this.enabled ? (short)0 : 1;
        this.buffer.put(this.putProgram());
        switch (this.filetype) {
            case TERMID: {
                this.buffer.put((byte)2);
                break;
            }
            case TRANID: {
                this.buffer.put((byte)1);
                break;
            }
            default: {
                this.buffer.put((byte)0);
            }
        }
        this.buffer.put(this.putAvailable(19));
    }
}

