/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.StdoutHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Logger {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static ArrayList<Handler> handlers = new ArrayList(1);
    private static boolean trace;
    private static boolean logpackets;
    private static final String format = "%s:%s";
    private static final DateFormat df;
    public static final String LINEFEED;
    private static LinkedBlockingQueue<LogRecord> queue;

    static {
        handlers.add(new StdoutHandler());
        trace = true;
        logpackets = false;
        df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss z");
        LINEFEED = System.getProperty("line.separator");
        queue = null;
    }

    private Logger() {
    }

    public static synchronized String addTime(String message) {
        return String.format(format, df.format(new Date()), message);
    }

    public static void loggit(Throwable e) {
        StringWriter string = new StringWriter();
        PrintWriter pw = new PrintWriter(string);
        e.printStackTrace(pw);
        Logger.handle(string.toString());
    }

    private static void handle(String string) {
        if (queue == null) {
            String value = System.getenv("LOG_CAPACITY");
            int capacity = 1024;
            try {
                capacity = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
            queue = new LinkedBlockingQueue(capacity);
        }
        LogRecord record = new LogRecord(Level.ALL, string);
        if (queue.remainingCapacity() == 0) {
            queue.poll();
        }
        try {
            queue.put(record);
        }
        catch (InterruptedException interruptedException) {}
        for (Handler handler : handlers) {
            handler.publish(record);
        }
    }

    private static String parseErrorlevel(int errorlevel) {
        if (errorlevel == 0) {
            return "";
        }
        if (errorlevel < 5) {
            return String.format("Warning:%d ", errorlevel);
        }
        return String.format("Error:%d ", errorlevel);
    }

    public static void loggit(int errorlevel, String message) {
        if (errorlevel > 0 || Logger.isTrace()) {
            Logger.handle(Logger.addTime(String.format("%s%s", Logger.parseErrorlevel(errorlevel), message)));
        }
    }

    public static void trace(String message) {
        if (Logger.isTrace()) {
            Logger.handle(Logger.addTime(message));
        }
    }

    public static void loggit(String message) {
        Logger.handle(Logger.addTime(message));
    }

    public static void loggit(int errorlevel, String message, Throwable e) {
        Logger.loggit(errorlevel, message);
        Logger.loggit(e);
    }

    public static void loggit(int errorlevel, String[] messages) {
        int length = 0;
        StringBuilder text = new StringBuilder("");
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            text.append(HexUtil.rightTrim(line));
            length = text.length();
            text.append(LINEFEED);
            ++n2;
        }
        text.setLength(length);
        Logger.loggit(errorlevel, text.toString());
    }

    public static void logPacket(byte[] buffer, Class<?> bufferClass, String prefix) {
        if (!logpackets) {
            return;
        }
        if (DSECT.class.isAssignableFrom(bufferClass)) {
            Logger.loggit(HexUtil.toHexDump(buffer, prefix, 32, 0));
        } else {
            String message = String.format("Unhandled class:%s", bufferClass.getSimpleName());
            Logger.loggit(message);
        }
    }

    public static boolean isTrace() {
        return trace;
    }

    public static void setTrace(boolean trace) {
        if (Logger.trace == trace) {
            return;
        }
        if (Logger.trace) {
            Logger.loggit("Trace Log disabled");
        }
        if (Logger.trace = trace) {
            Logger.loggit("Trace Log enabled");
        }
    }

    public static String getLINEFEED() {
        return LINEFEED;
    }

    public static boolean isLogpackets() {
        return logpackets;
    }

    public static void setLogpackets(boolean logpackets) {
        Logger.logpackets = logpackets;
        if (logpackets) {
            Logger.setTrace(true);
        }
    }

    public static void close() {
        for (Handler handler : handlers) {
            handler.close();
        }
    }

    public static void flush() {
        for (Handler handler : handlers) {
            handler.flush();
        }
    }

    public static void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (!handlers.contains(handler)) {
            handlers.add(handler);
            Iterator<LogRecord> it = queue.iterator();
            while (it.hasNext()) {
                handler.publish(it.next());
            }
        }
    }

    public static boolean removeHandler(Handler handler) {
        return handlers.remove(handler);
    }

    public static Object getHandler(Handler handler) {
        int ix = handlers.indexOf(handler);
        return ix == -1 ? null : handlers.get(ix);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }
}

