/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import java.nio.ByteBuffer;

public class ListQueueMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final short USE_PLI = 1;
    public static final int SELECTION_SIZE = 56;
    private String selection = HexUtil.spaceFill(null, 56);
    private String ipaddr = new String();
    private int port = 0;
    private int UID = 0;
    private String userid = new String();

    public void setSelection(String select) {
        if (select != null || select.length() < 56) {
            this.selection = HexUtil.spaceFill(select, 56);
        }
        this.selection = select;
    }

    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUID(int uid) {
        this.UID = uid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(HexUtil.spaceFill(this.ipaddr, 16).getBytes("IBM1047"));
        this.buffer.put(String.format("%0$05d", this.port).getBytes("IBM1047"));
        this.buffer.put(String.format("%0$08X", this.UID).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.userid, 8).getBytes("IBM1047"));
        this.setSelection(this.selection);
        this.buffer.put(this.selection.getBytes("IBM1047"));
    }

    @Override
    protected short _defaultID() {
        return 32;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] bytes = new byte[16];
        this.buffer.get(bytes);
        this.ipaddr = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        bytes = new byte[5];
        this.buffer.get(bytes);
        String temp = new String(bytes, "IBM1047");
        this.port = Integer.parseInt(temp);
        bytes = new byte[8];
        this.buffer.get(bytes);
        temp = new String(bytes, "IBM1047");
        this.UID = Integer.parseInt(temp, 16);
        bytes = new byte[8];
        this.buffer.get(bytes);
        this.userid = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        this.selection = new String(bytes, "IBM1047");
    }

    public String getIpaddr() {
        return this.ipaddr;
    }

    public int getPort() {
        return this.port;
    }

    public String getSelection() {
        return this.selection;
    }

    public int getUID() {
        return this.UID;
    }

    public String getUserid() {
        return this.userid;
    }

    @Override
    protected int _getMessageSize() {
        this.setSelection(this.selection);
        return 37 + this.selection.length();
    }

    @Override
    protected String _toString() {
        return null;
    }
}

