/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ConvertedJCLMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final short OK = 0;
    public static final short EDSN = 1;
    public static final short EMBR = 2;
    public static final short ESTEP = 3;
    public static final short EDSNT = 4;
    public static final short FAIL = 5;
    private ArrayList<String> members = null;
    private ArrayList<String> steps = null;
    private FileName target = null;

    public String[] getMembers() {
        this._checkmembers();
        return this.members.toArray(new String[this.members.size()]);
    }

    private void _checkmembers() {
        if (this.members == null) {
            this.members = new ArrayList();
        }
    }

    public short getResult() {
        return this.submessageID;
    }

    public String[] getSteps() {
        this._checksteps();
        return this.steps.toArray(new String[this.steps.size()]);
    }

    private void _checksteps() {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
    }

    public FileName getTarget() {
        return this.target;
    }

    public void setMembers(ArrayList<String> members) {
        try {
            this.setResult((short)2);
            this.members = members;
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
    }

    public void setResult(short result) throws ITException {
        this.setSubmessageID(result);
        switch (result) {
            case 0: {
                this.members = null;
                this.steps = null;
                break;
            }
            case 1: {
                this.members = null;
                this.steps = null;
                this.target = null;
                break;
            }
            case 2: {
                this.steps = null;
                this.target = null;
                this._checkmembers();
                break;
            }
            case 3: {
                this.members = null;
                this.target = null;
                this._checksteps();
                break;
            }
            case 4: 
            case 5: {
                this.members = null;
                this.steps = null;
            }
        }
    }

    public void setSteps(ArrayList<String> steps) {
        try {
            this.setResult((short)3);
            this.steps = steps;
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
    }

    public void setTarget(FileName target) {
        this.target = target;
    }

    @Override
    protected short _defaultID() {
        return 8;
    }

    @Override
    protected void buildMessage() throws Exception {
        switch (this.submessageID) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                this.buffer.put(this.target.getBuffer());
                break;
            }
            case 2: {
                this.buffer.putShort((short)this.members.size());
                for (String item : this.members) {
                    this.buffer.put(HexUtil.spaceFill(item, 10).getBytes("IBM1047"));
                }
                break;
            }
            case 3: {
                this.buffer.putShort((short)this.steps.size());
                for (String item : this.steps) {
                    this.buffer.put(HexUtil.spaceFill(item, 80).getBytes("IBM1047"));
                }
                break;
            }
        }
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.setResult(this.submessageID);
        switch (this.submessageID) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                this.target = new FileName(this.buffer);
                break;
            }
            case 2: {
                int size = Numbers.getUShort(this.buffer.getShort());
                this.members.clear();
                int i = 0;
                while (i < size) {
                    byte[] bytes = new byte[10];
                    this.buffer.get(bytes);
                    this.members.add(HexUtil.rightTrim(new String(bytes, "IBM1047")));
                    ++i;
                }
                break;
            }
            case 3: {
                int size = Numbers.getUShort(this.buffer.getShort());
                this.steps.clear();
                int i = 0;
                while (i < size) {
                    byte[] bytes = new byte[80];
                    this.buffer.get(bytes);
                    this.steps.add(HexUtil.rightTrim(new String(bytes, "IBM1047")));
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                super.setSubmessageID(submessageID);
                break;
            }
            default: {
                throw new ITException("Invalid ConvertedJCL Result");
            }
        }
    }

    @Override
    protected int _getMessageSize() {
        int capacity = 2;
        switch (this.submessageID) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                capacity = this.target.getSize();
                break;
            }
            case 2: {
                capacity += 10 * this.members.size();
                break;
            }
            case 3: {
                capacity += 80 * this.steps.size();
            }
        }
        return capacity;
    }

    @Override
    protected String _toString() {
        return null;
    }
}

