/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BreakMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final short UBP = 1;
    public static final short CBP = 2;
    public static final short VBP = 3;
    public static final short RBP = 4;
    public static final short STP = 5;
    public static final short ABP = 6;
    public static final short EXT_XCTL = 7;
    public static final short EXT_LINK = 8;
    public static final short EXT_RETURN = 9;
    public static final short INITIAL_BP = 10;
    public static final short BACK_TRACE_STOP = 11;
    public static final short EXEC_FROM_STOP = 12;
    public static final String[] names = new String[]{"Unknown Break Type", "Unconditional Breakpoint", "Conditional Breakpoint", "Variable Change Breakpoint", "Request Breakpoint", "Single-Step Breakpoint", "Automatic Breakpoint", "XCTL To Other Program", "LINK To Other Program", "Exit From Program", "Initial Breakpoint", "Stop At Statement Trace Point", "Statement Repositioned"};
    protected int statement = 0;
    protected String text = "";
    protected long breakpointID = 0L;
    protected String destinationpgm = "";
    protected short type = 0;
    protected int sessionID;
    protected String DSName;
    protected int time = 0;
    protected int date = 0;
    protected byte[] sToken = null;
    private static final byte[] emptyToken;
    protected static final String linefeed;

    static {
        byte[] byArray = emptyToken = new byte[12];
        int n = emptyToken.length;
        int n2 = 0;
        while (n2 < n) {
            ++n2;
        }
        linefeed = System.getProperty("line.separator");
    }

    public BreakMessage() {
        super(true);
    }

    @Override
    protected void _extractMessage(ByteBuffer buffer) throws Exception {
        this.type = this.submessageID;
        this.sToken = new byte[12];
        buffer.get(this.sToken);
        this.text = null;
        this.setProgram(this.getProgram(buffer));
        this.getAvailable(buffer);
        byte[] dsn = new byte[44];
        buffer.get(dsn);
        this.DSName = HexUtil.rightTrim(new String(dsn, "IBM1047"));
        byte[] buf = new byte[3];
        buffer.get(buf);
        if (buf[2] != 0) {
            this.date = Numbers.unpack(buf).intValue();
        }
        buf = new byte[4];
        buffer.get(buf);
        if (buf[3] != 0) {
            this.time = Numbers.unpack(buf).intValue();
        }
        this.sessionID = buffer.getInt();
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.breakpointID = buffer.getLong();
                this.statement = buffer.getInt();
                this.getText(buffer);
                break;
            }
            case 10: {
                buffer.getLong();
                this.breakpointID = 0L;
                this.statement = buffer.getInt();
                this.getText(buffer);
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                this.statement = buffer.getInt();
                this.getText(buffer);
                break;
            }
            case 6: {
                this.statement = buffer.getInt();
                this.getText(buffer);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.destinationpgm = this.getProgram(buffer);
                this.statement = buffer.getInt();
                this.getText(buffer);
                break;
            }
            default: {
                throw new ITException("Invalid Break type:" + this.type);
            }
        }
    }

    protected void getText(ByteBuffer buffer) {
        if (buffer.remaining() >= 2) {
            int txtlen = Numbers.getUShort(buffer.getShort());
            if (txtlen > buffer.remaining()) {
                txtlen = buffer.remaining();
                Logger.loggit(4, "Malformed BreakMessage detected");
            }
            if (txtlen > 0) {
                byte[] txt = new byte[txtlen];
                buffer.get(txt);
                try {
                    String textString = new String(txt, "IBM1047");
                    this.text = this.getMessageText(textString);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.loggit(e);
                    this.text = HexUtil.Squeeze(HexUtil.toString(txt));
                }
            }
        }
    }

    @Override
    protected void buildMessage() throws Exception {
        this.submessageID = this.type;
        this.buffer.put(this.putProgram());
        this.buffer.put(this.putAvailable());
        this.buffer.put(HexUtil.spaceFill(this.DSName, 44).getBytes("IBM1047"));
        this.buffer.put(Numbers.pack(this.date, 3));
        this.buffer.put(Numbers.pack(this.time, 4));
        this.buffer.putInt(this.sessionID);
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.buffer.putLong(this.breakpointID);
                this.buffer.putInt(this.statement);
                break;
            }
            case 5: {
                this.buffer.putInt(this.statement);
                break;
            }
            case 6: {
                this.buffer.putInt(this.statement);
                String temp = this.text.trim();
                this.buffer.putShort((short)this.text.length());
                this.buffer.put(temp.getBytes("IBM1047"));
                break;
            }
            case 10: {
                this.buffer.putInt(this.statement);
                this.buffer.put(HexUtil.sizeBytes(this.sToken, 12));
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.buffer.put(this.putProgram(this.destinationpgm));
                this.buffer.putInt(this.statement);
            }
        }
    }

    public String getDestinationpgm() {
        return this.destinationpgm;
    }

    public int getStatement() {
        return this.statement;
    }

    public String getText() {
        int index;
        if (this.text == null || this.text.length() == 0) {
            this.text = this.submessageID >= names.length ? names[0] : names[this.submessageID];
        }
        if ((index = this.text.indexOf(linefeed)) == -1) {
            return this.text;
        }
        return this.text.substring(0, index).trim();
    }

    public String getLongText() {
        return this.text;
    }

    public long getBreakpointID() {
        return this.breakpointID;
    }

    public void setBreakpointID(long breakpointID) {
        this.breakpointID = breakpointID;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public void setDestinationpgm(String destinationpgm) {
        this.destinationpgm = destinationpgm;
    }

    public void setStatement(int statement) {
        this.statement = statement;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public String getDSName() {
        return this.DSName;
    }

    public void setDSName(String name) {
        this.DSName = name;
    }

    public Integer getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    @Override
    protected short _defaultID() {
        return 1;
    }

    @Override
    protected int _getMessageSize() {
        return 500;
    }

    @Override
    protected String _toString() {
        return String.format("Pgm: %1$s Stat#%2$d DSN:%3$s:%4$s", this.getProgram(), this.getStatement(), this.DSName, this.getText());
    }

    public byte[] getSToken() {
        if (this.sToken != null && !Arrays.equals(this.sToken, emptyToken)) {
            return this.sToken;
        }
        return null;
    }

    public void setSToken(byte[] token) {
        this.sToken = (byte[])(token != null ? HexUtil.sizeBytes(token, 12) : null);
    }

    private String getMessageText(String text) {
        if (text == null) {
            return "";
        }
        String[] lines = text.split("\u0000");
        int count = lines.length;
        int i = 0;
        while (i < lines.length) {
            lines[i] = HexUtil.rightTrim(lines[i]);
            ++i;
        }
        i = lines.length - 1;
        while (i > 0) {
            if (lines[i].length() != 0) break;
            lines[i] = null;
            --count;
            --i;
        }
        while (i > 0) {
            if (lines[i].length() == 0 && lines[i - 1].length() == 0) {
                lines[i] = null;
                --count;
            }
            --i;
        }
        String[] result = new String[count];
        count = 0;
        i = 0;
        while (i < lines.length) {
            if (lines[i] != null) {
                result[count++] = lines[i];
            }
            ++i;
        }
        StringBuilder string = new StringBuilder("");
        int deleteix = 0;
        String[] stringArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            string.append(line);
            deleteix = string.length();
            string.append(linefeed);
            ++n2;
        }
        string.setLength(deleteix);
        return string.toString();
    }
}

