/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.views.properties;

import com.ca.filemaster.common.FMPGDGDataset;
import com.ca.filemaster.views.properties.IFMFile;
import com.ca.filemaster.views.properties.Parameter;
import com.ca.filemaster.views.properties.ParametersCategory;
import java.util.ArrayList;

public class FMGDG
implements IFMFile {
    private FMPGDGDataset dataSet;

    public FMGDG(FMPGDGDataset dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Object[] buildParametersForDisplay() {
        ArrayList<ParametersCategory> categories = new ArrayList<ParametersCategory>();
        ParametersCategory category = null;
        category = new ParametersCategory("GDG Attributes");
        categories.add(category);
        category.getParameters().add(new Parameter("Name", this.dataSet.getName()));
        category.getParameters().add(new Parameter("Maximum Generations", this.dataSet.getGdgMaxGens()));
        category.getParameters().add(new Parameter("Uncatalog All", this.dataSet.getGdgUnctlg()));
        category.getParameters().add(new Parameter("Scratch Dataset", this.dataSet.getGdgScratch()));
        category.getParameters().add(new Parameter("Owner Id", this.dataSet.getGdgOwnerid()));
        category.getParameters().add(new Parameter("Active Associations", String.valueOf(this.dataSet.getGdgAssocStart()) + "-" + this.dataSet.getGdgAssocEnd()));
        category = new ParametersCategory("Activity Dates");
        categories.add(category);
        category.getParameters().add(new Parameter("Creation date", this.dataSet.getDateCreated()));
        category.getParameters().add(new Parameter("Last Alteration date", this.dataSet.getGdgDateLastAltered()));
        category.getParameters().add(new Parameter("Expiration date", this.dataSet.getExpirationDate()));
        return categories.toArray();
    }
}

