/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.print;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.utility.print.PrintPageOneTable;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageFour;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageThree;
import com.ca.filemaster.utility.print.PrintUtilityWizardPageTwo;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyDigit;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class PrintUtilityWizardPageOne
extends FileMasterWizard
implements FocusListener {
    public PrintPageOneTable table;
    public FileMasterServer server;
    public String serverName;
    public static String newDatasetName;
    public static String oldDatasetName;
    public String initDsName;
    public String memberName = "";
    public Label serverNameLabel;
    public Label memberNameLabel;
    public Label volSerialLabel;
    public Label startKeyLabel;
    public Label printLimitLabel;
    public Text serverNameCombo;
    public Combo memberNameCombo;
    private Text FromDatasetCombo;
    public Combo volumeCombo;
    public Text startKeyText;
    public Text printLimitText;
    public Button btnMemberSelect;
    private boolean isGenericOpen;
    private Button DirListInsert;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.printOne";
    private static IPreferenceStore store;
    private static Boolean ShowDialog;
    private static boolean pendingMessage;
    private static boolean msgDisplayed;
    private String fileType;
    private String subTypeOfDSN;
    private Map<String, String> map;
    private FileMasterDataset dataSet;
    protected FileMasterMember member;
    static int returnDDCM;

    static {
        store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
        ShowDialog = false;
        pendingMessage = false;
    }

    public PrintUtilityWizardPageOne(String titlePageOne, FileMasterServer server, FileMasterDataset dataSet, FileMasterMember member, String fileType, String subTypeOfDSN, Map<String, String> map) {
        super(titlePageOne, dataSet.getName(), server);
        this.serverName = server.getName();
        this.server = server;
        this.dataSet = dataSet;
        oldDatasetName = dataSet.getName();
        this.initDsName = dataSet.getName();
        if (member != null) {
            this.memberName = member.getName();
        }
        this.fileType = fileType;
        this.subTypeOfDSN = subTypeOfDSN;
        this.map = map;
        this.setTitle(titlePageOne);
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.printOne");
        super.createControl(parent);
        this.data = new GridData();
        this.data.horizontalAlignment = 4;
        this.data.verticalAlignment = 0;
        this.data.grabExcessHorizontalSpace = true;
        this.data.grabExcessVerticalSpace = true;
        this.data.horizontalSpan = 1;
        this.data.verticalSpan = 1;
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Text(this.dataSetComposite, 2056);
        this.serverNameCombo.setLayoutData((Object)this.data);
        this.serverNameCombo.setText(this.server.getText());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.FromDatasetCombo = new Text(this.dataSetComposite, 2056);
        this.FromDatasetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.FromDatasetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.FromDatasetCombo, (int)37);
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.FromDatasetCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!msgDisplayed) {
                    oldDatasetName = PrintUtilityWizardPageOne.this.FromDatasetCombo.getText();
                }
                msgDisplayed = false;
            }
        });
        this.FromDatasetCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                PrintUtilityWizardPageOne.this.validateDataSet();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.FromDatasetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrintUtilityWizardPageOne.this.validateDataSet();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.initDsName != null) {
            this.FromDatasetCombo.setText(this.initDsName);
        }
        this.createMember();
        this.createVolSerial();
        this.startKeyLabel = new Label(this.dataSetComposite, 0);
        this.startKeyLabel.setText("Starting &key:");
        Composite labelComp = new Composite(this.dataSetComposite, 0);
        GridLayout printOptionsGL = new GridLayout(3, false);
        printOptionsGL.horizontalSpacing = 5;
        printOptionsGL.marginWidth = 0;
        printOptionsGL.verticalSpacing = 0;
        printOptionsGL.marginTop = 0;
        printOptionsGL.marginLeft = 0;
        printOptionsGL.marginHeight = 0;
        printOptionsGL.marginBottom = 0;
        labelComp.setLayout((Layout)printOptionsGL);
        this.startKeyText = new Text(labelComp, 2048);
        this.startKeyText.setLayoutData((Object)this.data);
        TextUtil.setWidth((Text)this.startKeyText, (int)10);
        this.startKeyText.addModifyListener((ModifyListener)this);
        this.startKeyText.setTextLimit(28);
        this.startKeyText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.printLimitLabel = new Label(labelComp, 0);
        this.printLimitLabel.setText("    Print limi&t:");
        this.printLimitText = new Text(labelComp, 2048);
        this.printLimitText.setLayoutData((Object)this.data);
        this.printLimitText.addVerifyListener((VerifyListener)new verifyDigit(false));
        TextUtil.setWidth((Text)this.printLimitText, (int)10);
        this.printLimitText.setTextLimit(9);
        this.table = new PrintPageOneTable(this.container);
        this.table.createTable();
        if (this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential") || this.fileType.equalsIgnoreCase("Direct Access")) {
            PrintPageOneTable.viewer.getTable().setEnabled(false);
        } else {
            PrintPageOneTable.viewer.getTable().setEnabled(true);
        }
        PrintPageOneTable.clearSelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrintPageOneTable.clearSelBtn.getText() == "Select &All") {
                    PrintPageOneTable.viewer.setAllChecked(true);
                    PrintPageOneTable.clearSelBtn.setText("&Clear Selections");
                } else {
                    PrintPageOneTable.clearSelBtn.setText("Select &All");
                    PrintPageOneTable.viewer.setAllChecked(false);
                }
                PrintUtilityWizardPageOne.this.setPageComplete(PrintUtilityWizardPageOne.this.isPageComplete());
            }
        });
        PrintPageOneTable.deleteListBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                returnDDCM = PrintUtilityWizardPageOne.this.displayDatasetChangedMsg();
                if (returnDDCM == -1) {
                    String message = "Are you sure you want to delete the existing member list? Clicking Yes will delete the existing member list";
                    boolean result = MessageDialog.openQuestion(null, (String)"Warning", (String)message);
                    if (result) {
                        PrintPageOneTable.viewer.getTable().removeAll();
                        PrintPageOneTable.clearSelBtn.setEnabled(false);
                        PrintPageOneTable.deleteListBtn.setEnabled(false);
                        PrintUtilityWizardPageOne.this.setPageComplete(PrintUtilityWizardPageOne.this.isPageComplete());
                    }
                } else if (returnDDCM == 3) {
                    PrintUtilityWizardPageOne.this.FromDatasetCombo.setFocus();
                }
            }
        });
        PrintPageOneTable.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (PrintPageOneTable.viewer.getCheckedElements().length >= 1) {
                    PrintPageOneTable.clearSelBtn.setText("&Clear Selections");
                } else {
                    PrintPageOneTable.clearSelBtn.setText("Select &All");
                }
                if (PrintPageOneTable.viewer.getCheckedElements().length == 0) {
                    PrintPageOneTable.clearSelBtn.setText("Select &All");
                }
                PrintUtilityWizardPageOne.this.setPageComplete(PrintUtilityWizardPageOne.this.isPageComplete());
            }
        });
        if (this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential") || this.fileType.equalsIgnoreCase("Direct Access")) {
            this.memberNameCombo.setEnabled(false);
            this.btnMemberSelect.setEnabled(false);
            this.table.memberGroup.setEnabled(false);
            this.FromDatasetCombo.setFocus();
        } else {
            this.memberNameCombo.setFocus();
        }
        this.setControl((Control)this.container);
        if (!FMPreferences.disabledPreview()) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
        }
        if (this.getWizard().getPageCount() == 6) {
            this.isGenericOpen = true;
            if (this.isGenericOpen) {
                this.DirListInsert = new Button(this.container, 32);
                this.DirListInsert.setText("Add to Director&y List view");
            }
        }
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (PrintUtilityWizardPageOne.this.getWizard().getContainer().getCurrentPage().getName().endsWith("Print")) {
                    if (FMPreferences.disabledPreview()) {
                        PrintUtilityWizardPageOne.this.map.put("Action", "Finish");
                    } else {
                        PrintUtilityWizardPageOne.this.map.put("Action", "Preview");
                    }
                    PrintUtilityWizardPageOne.this.getWizard().getContainer().showPage(PrintUtilityWizardPageOne.this.getWizard().getPage("Summary"));
                }
            }
        });
        this.canFlipToNextPage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.map.put("Action", "Finish");
            if (!FMPreferences.disabledPreview()) {
                ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
            }
        }
        if (this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential") || this.fileType.equalsIgnoreCase("Direct Access")) {
            this.FromDatasetCombo.setFocus();
        } else {
            this.memberNameCombo.setFocus();
        }
    }

    public void createMember() {
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 0);
        this.memberNameCombo.setLayoutData((Object)this.data);
        this.memberNameCombo.setTextLimit(8);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        TextUtil.setWidth((Combo)this.memberNameCombo, (int)37);
        FMHistory.intializeComboBoxes(this.memberNameCombo, "PrintUtilPgOneMember");
        this.memberNameCombo.setText(this.memberName);
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.btnMemberSelect = new Button(this.dataSetComposite, 0);
        this.btnMemberSelect.setText("S&elect...");
        this.btnMemberSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                returnDDCM = PrintUtilityWizardPageOne.this.displayDatasetChangedMsg();
                if (returnDDCM == 2 || returnDDCM == -1) {
                    PrintUtilityWizardPageOne.this.dataSet.setName(PrintUtilityWizardPageOne.this.FromDatasetCombo.getText().trim());
                    PrintUtilityWizardPageOne.this.member = new FileMasterMember(null);
                    PrintUtilityWizardPageOne.this.member.setName(PrintUtilityWizardPageOne.this.memberNameCombo.getText());
                    WizardDialog dialog = new WizardDialog(PrintUtilityWizardPageOne.this.getShell(), (IWizard)new MemberWizard(PrintUtilityWizardPageOne.this.member, PrintUtilityWizardPageOne.this.dataSet, PrintUtilityWizardPageOne.this.server, false, PrintUtilityWizardPageOne.this.table.getPrintTblMembers()));
                    dialog.create();
                    dialog.open();
                } else if (returnDDCM == 3) {
                    PrintUtilityWizardPageOne.this.FromDatasetCombo.setFocus();
                }
                PrintUtilityWizardPageOne.this.setPageComplete(PrintUtilityWizardPageOne.this.isPageComplete());
            }
        });
        new Label(this.dataSetComposite, 0);
    }

    public void createVolSerial() {
        this.volSerialLabel = new Label(this.dataSetComposite, 0);
        this.volSerialLabel.setText("&Volume serial:");
        this.volumeCombo = new Combo(this.dataSetComposite, 2048);
        this.volumeCombo.setLayoutData((Object)this.data);
        TextUtil.setWidth((Combo)this.volumeCombo, (int)37);
        this.volumeCombo.setTextLimit(6);
        this.volumeCombo.addModifyListener((ModifyListener)this);
        this.volumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.volumeCombo, "PrintUtilPgOneVolume");
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
    }

    @Override
    public void serverChanged(FileMasterServer server) {
        super.serverChanged(server);
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public int displayDatasetChangedMsg() {
        msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (pendingMessage) {
            pendingMessage = false;
            if (PrintPageOneTable.viewer.getTable().getItemCount() > 0 || !newDatasetName.equals(oldDatasetName)) {
                String question = "Are you sure you want to change the data set? Clicking Yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    oldDatasetName = newDatasetName;
                    this.dataSet = new FileMasterDataset(null);
                    store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        ShowDialog = false;
                    }
                    PrintPageOneTable.viewer.getTable().removeAll();
                    PrintPageOneTable.viewer.setInput(null);
                    this.memberNameCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        ShowDialog = false;
                    }
                    this.FromDatasetCombo.setText(oldDatasetName);
                    newDatasetName = oldDatasetName;
                }
            }
        }
        if (this.dataSet == null) {
            this.dataSet = new FileMasterDataset(null);
        }
        this.dataSet.setName(newDatasetName);
        return returncode;
    }

    private void validateDataSet() {
        boolean datasetError;
        newDatasetName = this.FromDatasetCombo.getText().trim();
        ShowDialog = !store.getBoolean("CLOSE_VALUE");
        boolean bl = datasetError = Validator.dataset(this.FromDatasetCombo.getText(), true) != 0 && Validator.dataset(this.FromDatasetCombo.getText(), true) != 3 && Validator.dataset(this.FromDatasetCombo.getText(), true) != 1;
        if (!(!ShowDialog.booleanValue() || datasetError || PrintPageOneTable.viewer.getTable().getItemCount() <= 1 && this.memberNameCombo.getText().isEmpty() || oldDatasetName.equalsIgnoreCase(newDatasetName))) {
            pendingMessage = true;
        } else {
            pendingMessage = false;
            if (!oldDatasetName.equalsIgnoreCase(newDatasetName)) {
                oldDatasetName = newDatasetName;
                PrintPageOneTable.viewer.getTable().removeAll();
                PrintPageOneTable.viewer.setInput(null);
                this.memberNameCombo.setText("");
            }
        }
        this.displayDatasetChangedMsg();
    }

    public void focusGained(FocusEvent e) {
        returnDDCM = this.displayDatasetChangedMsg();
        if (returnDDCM == 3) {
            this.FromDatasetCombo.setFocus();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean doFinish() {
        if (this.map.get("Action") == "Preview") {
            return false;
        }
        FMHistory.insertHistory(this.memberNameCombo, "PrintUtilPgOneMember");
        FMHistory.insertHistory(this.volumeCombo, "PrintUtilPgOneVolume");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            if (this.memberNameCombo != null) {
                switch (Validator.member(this.memberNameCombo.getText(), true)) {
                    case 7: {
                        this.btnMemberSelect.setEnabled(true);
                        if (PrintPageOneTable.viewer.getCheckedElements().length != 0 || this.memberNameCombo.getText().contains("*") && this.memberNameCombo.getText().length() == 1) break;
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.memberNameCombo.getText(), true)] + "\n";
                        break;
                    }
                    case 6: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.memberNameCombo.getText(), false)] + "\n ";
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 0: {
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 5: {
                        if (!this.memberNameCombo.isEnabled() || this.table == null || this.table.getViewer() == null || this.table.getViewer().getCheckedElements().length != 0) break;
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.memberNameCombo.getText(), true)] + "\n ";
                        this.btnMemberSelect.setEnabled(true);
                        break;
                    }
                }
            }
            if (this.volumeCombo != null) {
                switch (Validator.volume(this.volumeCombo.getText(), false)) {
                    case 9: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.volumeCombo.getText(), false)] + "\n ";
                        break;
                    }
                }
            }
            if (this.startKeyText != null && this.fileType != null && this.fileType.trim().length() != 0) {
                switch (Validator.printStartingKey(this.startKeyText.getText(), this.fileType, this.subTypeOfDSN)) {
                    case 45: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[45] + "\n";
                        break;
                    }
                    case 46: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[46] + "\n";
                        break;
                    }
                }
            }
            if (this.error.length() > 0) {
                if (this.getErrorMessage() == null) {
                    this.setErrorMessage(this.error);
                    this.error = new String();
                    return false;
                }
                if (!this.getErrorMessage().equalsIgnoreCase(this.error)) {
                    this.setErrorMessage(this.error);
                    this.error = new String();
                    return false;
                }
                this.error = new String();
            } else {
                this.setErrorMessage(null);
            }
        }
        if (this.getErrorMessage() == null && this.FromDatasetCombo.getText() != "") {
            if (FMPreferences.disabledPreview()) {
                return true;
            }
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(15).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (PrintUtilityWizardPageOne.this.getWizard().getContainer().getCurrentPage() instanceof PrintUtilityWizardPageThree) {
                        PrintUtilityWizardPageOne.this.map.put("Action", "Finish");
                    }
                }
            });
            this.getWizard().getContainer().getShell().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    if (event.stateMask == 65536) {
                        if (event.character == 'p' || event.character == 'P') {
                            PrintUtilityWizardPageOne.this.map.put("Action", "Finish");
                            PrintUtilityWizardPageOne.this.getWizard().getContainer().showPage(PrintUtilityWizardPageOne.this.getWizard().getPage("Summary"));
                        }
                        if ((event.character == 'b' || event.character == 'B') && PrintUtilityWizardPageOne.this.map.get("Action") == "Finish") {
                            PrintUtilityWizardPageOne.this.map.put("Action", "Preview");
                        }
                        if (event.character == 'n' || event.character == 'N') {
                            System.out.println(true);
                            if (PrintUtilityWizardPageOne.this.getWizard().getContainer().getCurrentPage() instanceof PrintUtilityWizardPageThree) {
                                PrintUtilityWizardPageOne.this.map.put("Action", "Finish");
                            }
                        }
                    }
                    if (!(event.character != '\r' || Display.getCurrent().getFocusControl() instanceof Text && (PrintUtilityWizardPageOne.this.getWizard().getContainer().getCurrentPage() instanceof PrintUtilityWizardPageTwo || PrintUtilityWizardPageOne.this.getWizard().getContainer().getCurrentPage() instanceof PrintUtilityWizardPageFour))) {
                        if (((Shell)event.widget).getDefaultButton().getText().equalsIgnoreCase("&Preview")) {
                            if (PrintUtilityWizardPageOne.this.map.get("Action") == null) {
                                PrintUtilityWizardPageOne.this.map.put("Action", "Preview");
                            }
                            PrintUtilityWizardPageOne.this.map.put("Action", "Preview");
                            PrintUtilityWizardPageOne.this.getWizard().getContainer().showPage(PrintUtilityWizardPageOne.this.getWizard().getPage("Summary"));
                        }
                        if (((Shell)event.widget).getDefaultButton().getText().equals("< &Back") && PrintUtilityWizardPageOne.this.map.get("Action") == "Finish") {
                            PrintUtilityWizardPageOne.this.map.put("Action", "Preview");
                        }
                        if (((Shell)event.widget).getDefaultButton().getText().equals("&Next >") && PrintUtilityWizardPageOne.this.getWizard().getContainer().getCurrentPage() instanceof PrintUtilityWizardPageThree) {
                            PrintUtilityWizardPageOne.this.map.put("Action", "Finish");
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    public String getServerName() {
        return this.serverName;
    }

    public FileMasterServer getServer() {
        return this.server;
    }

    @Override
    public String getDataSetName() {
        return this.FromDatasetCombo.getText().trim();
    }

    public String getMemberName() {
        String members = "";
        int numCheckedMembers = this.table.getViewer().getCheckedElements().length;
        if (numCheckedMembers > 0) {
            int i = 0;
            while (i < numCheckedMembers) {
                members = ((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i])).getNewName().isEmpty() ? String.valueOf(members) + ((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i])).getName() + "     " : String.valueOf(members) + "[" + ((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i])).getName() + "," + ((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i])).getNewName() + "]     ";
                ++i;
            }
            return members;
        }
        return this.memberNameCombo.getText();
    }

    public ArrayList<String> getMembersAsArray() {
        ArrayList<String> members = new ArrayList<String>();
        int numCheckedMembers = this.table.getViewer().getCheckedElements().length;
        if (numCheckedMembers > 0) {
            int i = 0;
            while (i < numCheckedMembers) {
                if (((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i])).getNewName().isEmpty()) {
                    members.add(((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i])).getName());
                }
                ++i;
            }
            return members;
        }
        members.add(this.memberNameCombo.getText());
        return members;
    }

    public Combo getVolumeSerialCombo() {
        return this.volumeCombo;
    }

    public Text getStartingKey() {
        return this.startKeyText;
    }

    public Text getPrinLimit() {
        return this.printLimitText;
    }

    public void setDatasetCombo(String datasetname) {
        if (this.FromDatasetCombo != null) {
            this.FromDatasetCombo.setText(datasetname);
        }
    }

    public void setVolumeSerial(String volumeSerial) {
        this.volumeCombo.setText(volumeSerial);
    }

    public void setFileType(String typeOfDSN) {
        if (PrintPageOneTable.viewer != null && this.memberNameCombo != null && this.btnMemberSelect != null && this.table != null && this.FromDatasetCombo != null) {
            if (typeOfDSN.equalsIgnoreCase("VSAM") || typeOfDSN.equalsIgnoreCase("PS") || typeOfDSN.equalsIgnoreCase("PSL") || typeOfDSN.equalsIgnoreCase("Sequential") || typeOfDSN.equalsIgnoreCase("Direct Access")) {
                PrintPageOneTable.viewer.getTable().setEnabled(false);
                this.memberNameCombo.setText("");
                this.memberNameCombo.setEnabled(false);
                this.btnMemberSelect.setEnabled(false);
                this.table.memberGroup.setEnabled(false);
                this.FromDatasetCombo.setFocus();
            } else {
                this.memberNameCombo.setFocus();
                this.memberNameCombo.setEnabled(true);
                this.btnMemberSelect.setEnabled(true);
                this.table.memberGroup.setEnabled(true);
                PrintPageOneTable.viewer.getTable().setEnabled(true);
            }
        }
        this.fileType = typeOfDSN;
    }

    public void setSubTypeOfDSN(String subTypeOfDSN) {
        this.subTypeOfDSN = subTypeOfDSN;
    }

    public void clearTable() {
        PrintPageOneTable.viewer.getTable().removeAll();
    }

    public void insertIntoDirecotryList() {
        if (this.DirListInsert != null && this.DirListInsert.getSelection()) {
            int numCheckedMembers;
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.FromDatasetCombo.getText());
            fmdataset.setDsOrg(this.fileType);
            TT_TreeItem dsItem = null;
            int index = 0;
            int i = 0;
            while (i < this.model.getServers().length) {
                if (this.model.getServers()[i].getName().equals(this.serverName)) {
                    index = i;
                    break;
                }
                ++i;
            }
            dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
            if (dsItem == null) {
                Element dsElement = this.model.addDataset(this.server.getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
                dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            }
            if ((numCheckedMembers = this.table.getViewer().getCheckedElements().length) > 0) {
                int i2 = 0;
                while (i2 < numCheckedMembers) {
                    this.insertMemberToTree(dsItem, ((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i2])).getName().trim());
                    ++i2;
                }
            } else {
                this.insertMemberToTree(dsItem, this.memberNameCombo.getText().trim());
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            shell.setMinimized(false);
            shell.forceActive();
            shell.forceFocus();
            try {
                TreeViewer viewer;
                IWorkbenchPage page = window.getActivePage();
                IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                    viewer.refresh(true);
                    view = page.showView("com.ca.filemaster.views.directorylist");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {}
            this.model.save();
        }
    }

    private void insertMemberToTree(TT_TreeItem dsItem, String name) {
        boolean isDuplicatedMember = false;
        FileMasterMember fmmember = new FileMasterMember(null);
        if (name.length() != 0) {
            fmmember.setName(name.trim());
            fmmember.setType("MEMBER");
            if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                isDuplicatedMember = true;
            }
            if (!isDuplicatedMember) {
                Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.model.insertMember(dsItem, memItem);
            }
        }
    }

    public void insertDSNToField(String value) {
        this.FromDatasetCombo.setText(value);
    }

    public Text getDataSetText() {
        return this.FromDatasetCombo;
    }
}

