/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.print;

import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.CreatedLabelProvider;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.MemberSorter;
import com.ca.filemaster.ui.wizards.RecordCountLabelProvider;
import com.ca.filemaster.ui.wizards.TimeChangedLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PrintPageOneTable {
    public Composite container;
    public Group memberGroup;
    public static CheckboxTableViewer viewer;
    public Listener sortListener;
    public static Button clearSelBtn;
    public static Button deleteListBtn;
    private static ArrayList<String> memberList;

    public PrintPageOneTable(Composite container) {
        this.container = container;
    }

    public void createTable() {
        Composite tableComp = new Composite(this.container, 0);
        GridLayout table_Layout = new GridLayout(1, false);
        tableComp.setLayout((Layout)table_Layout);
        this.memberGroup = new Group(this.container, 0);
        this.memberGroup.setSize(this.memberGroup.computeSize(-1, -1));
        this.memberGroup.setText("Members");
        this.memberGroup.setLayout((Layout)new GridLayout(1, false));
        this.memberGroup.setRedraw(true);
        this.createViewer((Composite)this.memberGroup);
        this.createButtons((Composite)this.memberGroup);
    }

    public void createButtons(Composite parent) {
        Composite btncomposite = new Composite(parent, 0);
        btncomposite.setLayout((Layout)new GridLayout(2, false));
        btncomposite.setSize(btncomposite.computeSize(-1, -1));
        clearSelBtn = new Button(btncomposite, 0x1000000);
        GridData gd_btnClear = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnClear.widthHint = 120;
        clearSelBtn.setLayoutData((Object)gd_btnClear);
        clearSelBtn.setText("&Clear Selections");
        clearSelBtn.setEnabled(false);
        clearSelBtn.setEnabled(false);
        deleteListBtn = new Button(btncomposite, 0x1000000);
        deleteListBtn.setText("Dele&te List");
        deleteListBtn.setEnabled(false);
    }

    private void createViewer(Composite parent) {
        viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        int i = 0;
        while (i < viewer.getTable().getItemCount()) {
            viewer.getTable().setLinesVisible(true);
            ++i;
        }
        viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_table.heightHint = 160;
        gd_table.widthHint = 620;
        viewer.getTable().setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(null);
    }

    private void createColumns(Composite parent) {
        String[] titles = new String[]{"Member", "Record Count", "Created", "Changed", "Time Changed", "ID"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 100};
        viewer.setSorter((ViewerSorter)new MemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    viewer.getTable().setSortColumn(tableColumn);
                    viewer.getTable().setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableColumn.setAlignment(131072);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new RecordCountLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new TimeChangedLabelProvider());
                    break;
                }
                case 5: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                viewer.refresh();
            }
        };
    }

    public static void insertMembersToTable(List<FileMasterMember> members) {
        ArrayList<FileMasterMember> oldMembers = new ArrayList<FileMasterMember>();
        int i = 0;
        while (i < viewer.getTable().getItemCount()) {
            if (viewer.getTable().getItem(i).getChecked()) {
                oldMembers.add((FileMasterMember)((Object)viewer.getElementAt(i)));
            }
            ++i;
        }
        i = 0;
        while (i < members.size()) {
            oldMembers.add(members.get(i));
            ++i;
        }
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)oldMembers.toArray());
        viewer.setAllChecked(true);
        if (viewer.getTable().getItemCount() == 0) {
            clearSelBtn.setEnabled(false);
        }
        if (viewer.getCheckedElements().length == viewer.getTable().getItemCount()) {
            clearSelBtn.setText("&Clear Selections");
        } else {
            clearSelBtn.setText("Select &All");
        }
        if (members.size() > 0) {
            i = 0;
            while (i < viewer.getTable().getItemCount()) {
                ((FileMasterMember)((Object)viewer.getTable().getItems()[i].getData())).setChecked(true);
                ++i;
            }
            clearSelBtn.setEnabled(true);
            deleteListBtn.setEnabled(true);
        }
    }

    public CheckboxTableViewer getViewer() {
        return viewer;
    }

    public ArrayList<String> getPrintTblMembers() {
        memberList = new ArrayList();
        int i = 0;
        while (i < viewer.getTable().getItemCount()) {
            memberList.add(((FileMasterMember)((Object)viewer.getTable().getItems()[i].getData())).getName());
            ++i;
        }
        return memberList;
    }
}

