/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetCopyDS;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.utilities.AllocateNewDataSetWizard;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizard;
import com.ca.filemaster.utility.copy.CopyPDSToWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMFromWizardPage;
import com.ca.filemaster.utility.copy.CopyVSAMSummaryPage;
import com.ca.filemaster.utility.copy.SelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.VSAMSelectionCrtLayoutWizardPage;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopyVSAMToWizardPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(CopyVSAMToWizardPage.class.getName());
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copyVSAMToWizardPage";
    private String ReplaceKeys;
    private Label VolumeLabel;
    private Label toMemberLabel;
    private Combo ToDatasetCombo;
    private Combo ToVolumeCombo;
    private Combo toMemberCombo;
    private Button btnMemberSelect;
    private Button btnshr;
    private Button btnold;
    private Button btnnew;
    private Button btnpds;
    private Button btnseq;
    private Button btnvsam;
    private Button btnAllocate;
    private Button dirListInsert;
    private Button btnduplicateKeys;
    private Button btnlikenamedMembers;
    private String ReplaceMem;
    private boolean isCopyVSAMWizard;
    private Group disp_grp;
    private Group optionsGroup;
    private Group new_alloc_grp;
    protected Map<String, String> map;
    private FileMasterServer server;
    protected FileMasterDataset dataSet;
    protected FileMasterMember member;
    private ArrayList<FileMasterDataset> datasetsList = new ArrayList();
    private ArrayList<FileMasterMember> membersList = new ArrayList();
    private FileMasterMember layoutMembers = new FileMasterMember(null);
    private FileMasterDataset layoutDataset = new FileMasterDataset(null);
    private ArrayList<String> selCrit = new ArrayList();
    FileMasterDataset datasetfrom = new FileMasterDataset(null);
    FileMasterDataset datasetto = new FileMasterDataset(null);
    private boolean performCopy = true;
    private FileMasterDataset fmDataset = new FileMasterDataset(null);
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private String memberList = "";

    protected CopyVSAMToWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, boolean isCopyVSAMWizard) {
        super(pageName, "", server);
        this.setTitle("Copy VSAM To");
        this.server = server;
        this.dataSet = dataSet;
        this.ReplaceKeys = "N";
    }

    @Override
    public void createControl(Composite parent) {
        GridData data = new GridData(4, 0, true, true, 1, 1);
        this.map = new HashMap<String, String>();
        super.createControl(parent);
        super.createDataSet();
        this.ToDatasetCombo = this.dataSetCombo;
        FMHistory.intializeComboBoxes(this.ToDatasetCombo, "ToDatasetListCopyVSAM");
        this.toMemberLabel = new Label(this.dataSetComposite, 0);
        this.toMemberLabel.setText("&Member name:");
        this.toMemberCombo = new Combo(this.dataSetComposite, 0);
        this.toMemberCombo.setLayoutData((Object)data);
        this.toMemberCombo.setTextLimit(8);
        GridData gd_toMemberComboo = new GridData(4, 4, false, false, 1, 1);
        gd_toMemberComboo.widthHint = 107;
        this.toMemberCombo.addModifyListener((ModifyListener)this);
        this.toMemberCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.toMemberCombo, "ToMemberListCopySeq");
        this.btnMemberSelect = new Button(this.dataSetComposite, 0);
        this.btnMemberSelect.setText("S&elect...");
        this.btnMemberSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyVSAMToWizardPage.this.dataSet = new FileMasterDataset(null);
                CopyVSAMToWizardPage.this.dataSet.setName(CopyVSAMToWizardPage.this.ToDatasetCombo.getText());
                CopyVSAMToWizardPage.this.member = new FileMasterMember(null);
                CopyVSAMToWizardPage.this.member.setName(CopyVSAMToWizardPage.this.toMemberCombo.getText());
                CopyVSAMToWizardPage.this.fmdataset = CommonMFCalls.getFQDSN(CopyVSAMToWizardPage.this.ToDatasetCombo.getText(), CopyVSAMToWizardPage.this.ToVolumeCombo.getText(), CopyVSAMToWizardPage.this.server);
                if (!CopyVSAMToWizardPage.this.fmdataset.getName().isEmpty()) {
                    WizardDialog dialog = new WizardDialog(CopyVSAMToWizardPage.this.getShell(), (IWizard)new MemberWizard(CopyVSAMToWizardPage.this.member, CopyVSAMToWizardPage.this.fmdataset, CopyVSAMToWizardPage.this.server, true));
                    dialog.create();
                    dialog.open();
                }
            }
        });
        new Label(this.dataSetComposite, 0);
        this.VolumeLabel = new Label(this.dataSetComposite, 0);
        this.VolumeLabel.setText("&Volume serial:");
        this.ToVolumeCombo = new Combo(this.dataSetComposite, 2048);
        TextUtil.setWidth((Combo)this.ToVolumeCombo, (int)37);
        this.ToVolumeCombo.setTextLimit(6);
        this.ToVolumeCombo.addModifyListener((ModifyListener)this);
        this.ToVolumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.ToVolumeCombo.setLayoutData((Object)data);
        FMHistory.intializeComboBoxes(this.ToVolumeCombo, "ToVolumeListCopyVSAM");
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.createDispGroup();
        this.createAllocationGroup();
        this.createOptionsGroup();
        if (!this.isCopyVSAMWizard) {
            this.dirListInsert = new Button(this.container, 32);
            this.dirListInsert.setText("Add to Director&y List view");
        }
        this.setControl((Control)this.container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copyVSAMToWizardPage");
        this.toggleAllocationGroup(false);
        this.ReplaceMem = "N";
    }

    public void createDispGroup() {
        this.disp_grp = new Group(this.container, 0);
        this.disp_grp.setText("Disposition");
        this.disp_grp.setLayout((Layout)new GridLayout(3, false));
        GridData gd_disp = new GridData(4, 128, true, false);
        this.disp_grp.setLayoutData((Object)gd_disp);
        this.btnshr = new Button((Composite)this.disp_grp, 16);
        this.btnshr.setText("S&HR");
        this.btnshr.setSelection(true);
        this.btnold = new Button((Composite)this.disp_grp, 16);
        this.btnold.setText("&OLD");
        this.btnnew = new Button((Composite)this.disp_grp, 16);
        this.btnnew.setText("N&EW");
        this.btnnew.setEnabled(false);
    }

    public void createAllocationGroup() {
        this.new_alloc_grp = new Group(this.container, 0);
        this.new_alloc_grp.setText("New allocation");
        this.new_alloc_grp.setLayout((Layout)new GridLayout(4, false));
        GridData gd_new_alloc = new GridData(4, 128, true, false);
        this.new_alloc_grp.setLayoutData((Object)gd_new_alloc);
        this.btnpds = new Button((Composite)this.new_alloc_grp, 16);
        this.btnpds.setText("&PDS");
        this.btnpds.setSelection(false);
        this.btnseq = new Button((Composite)this.new_alloc_grp, 16);
        this.btnseq.setText("SE&Q");
        this.btnseq.setSelection(false);
        this.btnvsam = new Button((Composite)this.new_alloc_grp, 16);
        this.btnvsam.setText("VS&AM");
        this.btnvsam.setSelection(true);
        this.btnAllocate = new Button((Composite)this.new_alloc_grp, 8);
        this.btnAllocate.addSelectionListener((SelectionListener)this);
        this.btnAllocate.setText("Allo&cate...");
    }

    public void createOptionsGroup() {
        this.optionsGroup = new Group(this.container, 0);
        this.optionsGroup.setText("Options");
        this.optionsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd_options = new GridData(4, 128, true, false);
        this.optionsGroup.setLayoutData((Object)gd_options);
        this.btnduplicateKeys = new Button((Composite)this.optionsGroup, 32);
        this.btnduplicateKeys.setText("Replace duplicate &keys in KSDS");
        this.btnduplicateKeys.addSelectionListener((SelectionListener)this);
        this.btnlikenamedMembers = new Button((Composite)this.optionsGroup, 32);
        this.btnlikenamedMembers.setText("&Replace like-named members");
        this.btnlikenamedMembers.addSelectionListener((SelectionListener)this);
        this.btnnew.addSelectionListener((SelectionListener)this);
        this.btnshr.addSelectionListener((SelectionListener)this);
        this.btnold.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("Allo&cate...")) {
            if (this.btnvsam.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewVSAMDataSetWizard(this.ToDatasetCombo.getText(), this.server, ((CopyVSAMFromWizardPage)this.getPreviousPage()).getFromDataSetName()));
                this.dialog.create();
                this.dialog.open();
            } else if (this.btnpds.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(true, this.ToDatasetCombo.getText().trim(), false, this.server, ""));
                this.dialog.create();
                this.dialog.open();
            } else if (this.btnseq.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(false, this.ToDatasetCombo.getText().trim(), false, this.server, ""));
                this.dialog.create();
                this.dialog.open();
            }
        } else if (((Button)source).getText().equals("S&HR") || ((Button)source).getText().equals("&OLD")) {
            this.toggleAllocationGroup(false);
        } else if (((Button)source).getText().equals("N&EW")) {
            this.toggleAllocationGroup(true);
            this.setPageComplete(this.isPageComplete());
        } else if (((Button)source).getText().equals("Replace duplicate &keys in KSDS")) {
            this.ReplaceKeys = this.btnduplicateKeys.getSelection() ? "Y" : "N";
        } else if (((Button)source).getText().equals("&Replace like-named members")) {
            this.ReplaceMem = this.btnlikenamedMembers.getSelection() ? "Y" : "N";
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    @Override
    public boolean isPageComplete() {
        this.error = "";
        if (((CopyVSAMFromWizardPage)this.getWizard().getPage("Copy VSAM From")).getFromDataSetName().equalsIgnoreCase(this.ToDatasetCombo.getText().trim())) {
            this.setErrorMessage("Duplicate From and To data set names");
            return false;
        }
        if (this.ToVolumeCombo != null && this.btnnew != null) {
            if (!this.btnnew.getSelection()) {
                this.btnnew.setEnabled(false);
                this.toggleAllocationGroup(false);
            }
            if (this.btnnew.isEnabled() && this.btnnew.getSelection()) {
                this.error = String.valueOf(this.error) + Validator.errorMsg[11] + "\n";
            }
            switch (Validator.member(this.toMemberCombo.getText(), false)) {
                case 7: {
                    if (Validator.dataset(this.ToDatasetCombo.getText(), true) != 0) break;
                    this.btnMemberSelect.setEnabled(true);
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.toMemberCombo.getText(), false)] + "\n ";
                    this.btnMemberSelect.setEnabled(false);
                    break;
                }
                case 0: {
                    this.btnMemberSelect.setEnabled(false);
                }
            }
            if (this.toMemberCombo.getText().trim().length() == 0 && Validator.dataset(this.ToDatasetCombo.getText(), true) == 0) {
                this.btnMemberSelect.setEnabled(true);
            }
            switch (Validator.volume(this.ToVolumeCombo.getText(), false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.ToVolumeCombo.getText(), false)] + "\n ";
                }
            }
            if (super.isPageComplete()) {
                this.btnnew.setEnabled(true);
                if (this.btnnew.getSelection()) {
                    this.toggleAllocationGroup(true);
                }
                if (this.getErrorMessage() == null && this.dataSetCombo.getText() != "") {
                    if (FMPreferences.disabledPreview()) {
                        return true;
                    }
                    ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (CopyVSAMToWizardPage.this.map.get("Action") == null) {
                                CopyVSAMToWizardPage.this.map.put("Action", "Preview");
                            }
                            this.displaySummaryPage();
                        }

                        private void displaySummaryPage() {
                            ((CopyVSAMSummaryPage)CopyVSAMToWizardPage.this.getWizard().getPage("Copy VSAM Summary")).presetText();
                            CopyVSAMToWizardPage.this.getWizard().getContainer().showPage((IWizardPage)((CopyVSAMSummaryPage)CopyVSAMToWizardPage.this.getWizard().getPage("Copy VSAM Summary")));
                        }
                    });
                    ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(15).addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (CopyVSAMToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopyVSAMSummaryPage) {
                                CopyVSAMToWizardPage.this.setAction("Finish");
                            }
                        }
                    });
                    this.getWizard().getContainer().getShell().addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent event) {
                            if (event.stateMask == 65536) {
                                if (event.character == 'p' || event.character == 'P') {
                                    CopyVSAMToWizardPage.this.setAction("Finish");
                                    ((CopyVSAMSummaryPage)CopyVSAMToWizardPage.this.getWizard().getPage("Copy Summary")).presetText();
                                    CopyVSAMToWizardPage.this.getWizard().getContainer().showPage(CopyVSAMToWizardPage.this.getWizard().getPage("Copy Summary"));
                                }
                                if ((event.character == 'n' || event.character == 'N') && CopyVSAMToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopyVSAMSummaryPage) {
                                    CopyVSAMToWizardPage.this.setAction("Finish");
                                }
                            }
                            if (event.character == '\r' && !(Display.getCurrent().getFocusControl() instanceof Text)) {
                                if (((Shell)event.widget).getDefaultButton().getText() == "&Preview") {
                                    if (CopyVSAMToWizardPage.this.getAction() == null) {
                                        CopyVSAMToWizardPage.this.setAction("Preview");
                                    }
                                    ((CopyVSAMSummaryPage)CopyVSAMToWizardPage.this.getWizard().getPage("Copy Summary")).presetText();
                                    CopyVSAMToWizardPage.this.getWizard().getContainer().showPage(CopyVSAMToWizardPage.this.getWizard().getPage("Copy Summary"));
                                }
                                if (((Shell)event.widget).getDefaultButton().getText().equals("< &Back") && CopyVSAMToWizardPage.this.getAction() == "Finish") {
                                    ((TestingToolsWizardDialog)CopyVSAMToWizardPage.this.getWizard().getContainer()).getButton(16).setText("&Preview");
                                    CopyVSAMToWizardPage.this.setAction("Preview");
                                }
                                if (((Shell)event.widget).getDefaultButton().getText().equals("&Next >") && CopyVSAMToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopyVSAMSummaryPage) {
                                    CopyVSAMToWizardPage.this.setAction("Finish");
                                }
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
            if (this.error.contains("Missing")) {
                this.btnnew.setEnabled(false);
                this.toggleAllocationGroup(false);
            }
            return false;
        }
        return false;
    }

    private void toggleAllocationGroup(boolean enabled) {
        if (this.btnpds != null && this.btnseq != null && this.btnvsam != null && this.btnAllocate != null) {
            this.btnpds.setEnabled(enabled);
            this.btnseq.setEnabled(enabled);
            this.btnvsam.setEnabled(enabled);
            this.btnAllocate.setEnabled(enabled);
        }
    }

    public String getAction() {
        return this.map.get("Action");
    }

    public void setAction(String action) {
        this.map.put("Action", action);
    }

    public IWizardPage getNextPage() {
        return (SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options");
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setDisp(String disp) {
        if (disp.equalsIgnoreCase("SHR")) {
            this.btnshr.setSelection(true);
            this.btnold.setSelection(false);
            this.btnnew.setSelection(false);
        }
        this.toggleAllocationGroup(false);
        this.setPageComplete(this.isPageComplete());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.ToDatasetCombo.setFocus();
    }

    public boolean doFinish() {
        ImportSelCritWizardPage.conditions = "";
        if (this.getAction() == "Preview") {
            this.setAction("Finish");
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Finish");
            return false;
        }
        XMLRequest xml = this.doConnection();
        this.handleResponse(xml);
        if (this.dirListInsert != null && this.dirListInsert.getSelection() && this.performCopy) {
            String typeOfDSN = "";
            if (this.fmdataset != null && this.fmdataset.getName().equalsIgnoreCase(this.dataSetCombo.getText().trim())) {
                typeOfDSN = this.fmdataset.getDsOrg();
                if (typeOfDSN.trim().isEmpty()) {
                    typeOfDSN = this.fmdataset.getFileType();
                }
            } else {
                FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(this.dataSetCombo.getText(), this.ToVolumeCombo.getText(), this.server);
                if (CommonMFCalls.RETURN_CODE.equals("0")) {
                    typeOfDSN = FMDataSet.getDsOrg();
                    if (typeOfDSN.trim().isEmpty()) {
                        typeOfDSN = this.fmdataset.getFileType();
                    }
                } else {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + CommonMFCalls.RETURN_CODE), (Throwable)new Throwable(CommonMFCalls.MESSAGE));
                }
            }
            if (typeOfDSN.isEmpty()) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set");
            }
            this.datasetto.setDsOrg(typeOfDSN);
            this.memberList = ((CopyVSAMToWizardPage)this.getWizard().getPage("Copy VSAM To")).getToMemberCombo().getText();
            this.insertIntoDirecotryList(this.datasetto);
        }
        if (((CopyVSAMFromWizardPage)this.getPreviousPage()).dirListInsertFrom()) {
            this.fmDataset.setName(((CopyVSAMFromWizardPage)this.getWizard().getPage("Copy VSAM From")).getFromDataSetName());
            this.insertIntoDirecotryList(this.datasetfrom);
        }
        FMHistory.insertHistory(this.ToDatasetCombo, "ToDatasetListCopyVSAM");
        FMHistory.insertHistory(this.ToVolumeCombo, "ToVolumeListCopyVSAM");
        if (((VSAMSelectionCrtLayoutWizardPage)this.getNextPage()).getDataSetCombo() != null && ((VSAMSelectionCrtLayoutWizardPage)this.getNextPage()).getMemberCombo() != null) {
            FMHistory.insertHistory(((VSAMSelectionCrtLayoutWizardPage)this.getNextPage()).getDataSetCombo(), "VSAMCopyLayoutPageDatasetList");
            FMHistory.insertHistory(((VSAMSelectionCrtLayoutWizardPage)this.getNextPage()).getMemberCombo(), "VSAMCopyLayoutPageMemberList");
        }
        return true;
    }

    private void handleResponse(XMLRequest xml) {
        ArrayList<String> contentAL = new ArrayList<String>();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Line");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + CopyVSAMToWizardPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = CopyVSAMToWizardPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    int returnCodeInt = Integer.parseInt(returnCode);
                    if (returnCodeInt > 4) {
                        this.performCopy = false;
                    }
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element lineElement = (Element)nodes.item(i);
                        String line = new String();
                        line = CopyVSAMToWizardPage.getTagValue("Line", lineElement);
                        contentAL.add(line);
                        ++i;
                    }
                    super.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                }
            }
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    private XMLRequest doConnection() {
        this.datasetsList = new ArrayList();
        this.datasetfrom = new FileMasterDataset(null);
        this.datasetfrom.setName(((CopyVSAMFromWizardPage)this.getWizard().getPage("Copy VSAM From")).getFromDataSetName());
        this.datasetfrom.setDsOrg(this.dataSet.getDsOrg());
        this.datasetsList.add(0, this.datasetfrom);
        this.datasetto = new FileMasterDataset(null);
        this.datasetto.setName(((CopyVSAMToWizardPage)this.getWizard().getPage("Copy VSAM To")).getToDataSetCombo().getText());
        this.datasetto.setVolume(((CopyVSAMToWizardPage)this.getWizard().getPage("Copy VSAM To")).getToVolumeCombo().getText());
        this.datasetsList.add(1, this.datasetto);
        this.membersList = new ArrayList();
        FileMasterMember memberTo = new FileMasterMember(null);
        memberTo.setName(((CopyVSAMToWizardPage)this.getWizard().getPage("Copy VSAM To")).getToMemberCombo().getText());
        memberTo.setNewName("");
        this.membersList.add(memberTo);
        String disposition = ((CopyVSAMToWizardPage)this.getWizard().getPage("Copy VSAM To")).getDisp();
        switch (CopyPDSToWizardPage.DispositionEnum.valueOf(disposition)) {
            case MOD: {
                disposition = "M";
                break;
            }
            case NEW: {
                disposition = "N";
                break;
            }
            case SHR: {
                disposition = "S";
                break;
            }
            case OLD: {
                disposition = "O";
            }
        }
        if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).isLayoutView()) {
            String layout = ((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutViewCombo();
            String string = layout = layout.equals("(none)") ? "" : layout;
            if (layout.length() > 0) {
                int left = layout.indexOf("(");
                int right = layout.indexOf(")");
                this.layoutDataset.setName(layout.substring(0, left));
                this.datasetsList.add(2, this.layoutDataset);
                this.layoutMembers.setName(layout.substring(left + 1, right));
            } else {
                this.layoutDataset.setName("");
                this.datasetsList.add(2, this.layoutDataset);
                this.layoutMembers.setName("");
            }
        } else if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).isDSN()) {
            this.layoutDataset.setName(((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutDataset());
            this.datasetsList.add(2, this.layoutDataset);
            this.layoutMembers.setName(((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutMember());
        }
        if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton != null && ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton.isEnabled()) {
            ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.displayMessage = false;
            ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton.notifyListeners(13, new Event());
        }
        String selCritContent = "";
        int i = 0;
        while (i < ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.getContent().size()) {
            selCritContent = String.valueOf(selCritContent) + ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.getContent().get(i).toString() + "\r\n";
            ++i;
        }
        this.selCrit.add(0, selCritContent);
        RunGetCopyDS runner = new RunGetCopyDS(this.server, this.datasetsList, this.membersList, this.ReplaceMem, this.ReplaceKeys, disposition, this.layoutMembers, this.selCrit, "VSAM");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        return runner.getXml();
    }

    public Combo getToDataSetCombo() {
        return this.ToDatasetCombo;
    }

    public Combo getToMemberCombo() {
        return this.toMemberCombo;
    }

    public Combo getToVolumeCombo() {
        return this.ToVolumeCombo;
    }

    public String getDisp() {
        if (this.btnold.getSelection()) {
            return "OLD";
        }
        return "SHR";
    }

    public String getOpts() {
        if (this.btnduplicateKeys.getSelection()) {
            return " Replace duplicate keys in KSDS";
        }
        return "";
    }

    public String getOptions() {
        if (this.btnlikenamedMembers.getSelection()) {
            this.ReplaceMem = "Y";
            return "Replace liked-named members";
        }
        this.ReplaceMem = "N";
        return "";
    }

    public void insertMemberToField(String value) {
        this.toMemberCombo.setText(value);
    }

    public void insertDSNToField(String value) {
        this.ToDatasetCombo.setText(value);
    }

    public void insertIntoDirecotryList(FileMasterDataset dataset) {
        TT_TreeItem dsItem = null;
        int index = 0;
        int i = 0;
        while (i < this.model.getServers().length) {
            if (this.model.getServers()[i].getName().equals(this.server.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        dsItem = this.model.findObjectInTree((Object)dataset, this.model.getServers()[index]);
        if (dsItem == null) {
            Element dsElement = this.model.addDataset(this.server.getElement(), dataset.getName(), "", "", "", dataset.getDsOrg());
            dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
        }
        if (!this.memberList.isEmpty()) {
            this.insertMemberToTree(dsItem, this.memberList);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
            if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                viewer.refresh(true);
                view = page.showView("com.ca.filemaster.views.directorylist");
                page.activate((IWorkbenchPart)view);
                page.bringToTop((IWorkbenchPart)view);
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {}
        this.model.save();
    }

    private void insertMemberToTree(TT_TreeItem dsItem, String name) {
        boolean isDuplicatedMember = false;
        FileMasterMember fmmember = new FileMasterMember(null);
        if (name.length() != 0) {
            fmmember.setName(name.trim());
            fmmember.setType("MEMBER");
            if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                isDuplicatedMember = true;
            }
            if (!isDuplicatedMember) {
                Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.model.insertMember(dsItem, memItem);
            }
        }
    }
}

