/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetCopyDS;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.utilities.AllocateNewDataSetWizard;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizard;
import com.ca.filemaster.utility.copy.CopySeqFromWizardPage;
import com.ca.filemaster.utility.copy.CopySequentialSummaryPage;
import com.ca.filemaster.utility.copy.SelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.SeqSelectionCrtLayoutWizardPage;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopySeqToWizardPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(CopySeqToWizardPage.class.getName());
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copySEQToWizardPage";
    Shell shell;
    private Label volSerialLabel;
    private Label toMemberLabel;
    private Combo toDataSetCombo;
    private Combo toMemberCombo;
    private Combo toVolumeCombo;
    private Button btnMemberSelect;
    private Button btnshr;
    private Button btnold;
    private Button btnmod;
    private Button btnnew;
    private Button btnpds;
    private Button btnseq;
    private Button btnvsam;
    private Button btnAllocate;
    private Button dirListInsert;
    private Button btnlikenamedMembers;
    private FileMasterDataset fmDataset = new FileMasterDataset(null);
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    FileMasterDataset datasetfrom = new FileMasterDataset(null);
    FileMasterDataset datasetto = new FileMasterDataset(null);
    private boolean performCopy = true;
    private String memberList = "";
    private boolean isCopySeqWizard;
    private FileMasterServer server;
    protected Map<String, String> map;
    protected FileMasterDataset dataSet;
    protected FileMasterMember member;
    ArrayList<FileMasterDataset> datasetsList = new ArrayList();
    ArrayList<FileMasterMember> membersList = new ArrayList();
    FileMasterMember layoutMembers = new FileMasterMember(null);
    FileMasterDataset layoutDataset = new FileMasterDataset(null);
    ArrayList<String> selCrit = new ArrayList();
    private String ReplaceMem = "N";
    private Button btnduplicateKeys;
    private String replaceKSDSDupKeys = "N";

    public CopySeqToWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, boolean isCopySeqWizard) {
        super(pageName, "", server);
        this.server = server;
        this.dataSet = dataSet;
        this.setTitle("Copy Sequential To");
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copySEQToWizardPage");
        this.map = new HashMap<String, String>();
        super.createControl(parent);
        super.createDataSet();
        this.toDataSetCombo = this.dataSetCombo;
        FMHistory.intializeComboBoxes(this.toDataSetCombo, "ToDatasetListCopySEQ");
        this.toMemberLabel = new Label(this.dataSetComposite, 0);
        this.toMemberLabel.setText("Membe&r name:");
        this.toMemberCombo = new Combo(this.dataSetComposite, 0);
        this.toMemberCombo.setLayoutData((Object)this.data);
        this.toMemberCombo.setTextLimit(8);
        GridData gd_toMemberComboo = new GridData(4, 4, false, false, 1, 1);
        gd_toMemberComboo.widthHint = 107;
        this.toMemberCombo.addModifyListener((ModifyListener)this);
        this.toMemberCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.toMemberCombo, "ToMemberListCopySeq");
        this.btnMemberSelect = new Button(this.dataSetComposite, 0);
        this.btnMemberSelect.setText("S&elect...");
        this.btnMemberSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopySeqToWizardPage.this.dataSet = new FileMasterDataset(null);
                CopySeqToWizardPage.this.dataSet.setName(CopySeqToWizardPage.this.toDataSetCombo.getText());
                CopySeqToWizardPage.this.member = new FileMasterMember(null);
                CopySeqToWizardPage.this.member.setName(CopySeqToWizardPage.this.toMemberCombo.getText());
                CopySeqToWizardPage.this.fmdataset = CommonMFCalls.getFQDSN(CopySeqToWizardPage.this.toDataSetCombo.getText(), CopySeqToWizardPage.this.toVolumeCombo.getText(), CopySeqToWizardPage.this.server);
                if (!CopySeqToWizardPage.this.fmdataset.getName().isEmpty()) {
                    WizardDialog dialog = new WizardDialog(CopySeqToWizardPage.this.getShell(), (IWizard)new MemberWizard(CopySeqToWizardPage.this.member, CopySeqToWizardPage.this.fmdataset, CopySeqToWizardPage.this.server, true));
                    dialog.create();
                    dialog.open();
                }
            }
        });
        new Label(this.dataSetComposite, 0);
        this.volSerialLabel = new Label(this.dataSetComposite, 0);
        this.volSerialLabel.setText("&Volume serial:");
        this.toVolumeCombo = new Combo(this.dataSetComposite, 2048);
        TextUtil.setWidth((Combo)this.toVolumeCombo, (int)37);
        this.toVolumeCombo.setTextLimit(6);
        this.toVolumeCombo.addModifyListener((ModifyListener)this);
        this.toVolumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.toVolumeCombo, "ToVolumeListCopySeq");
        this.toVolumeCombo.setLayoutData((Object)this.data);
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.createDispGroup();
        this.createAllocationGroup();
        this.createOptionsGroup();
        if (!this.isCopySeqWizard) {
            this.dirListInsert = new Button(this.container, 32);
            this.dirListInsert.setText("Add to Director&y List view");
        }
        this.isPageComplete();
        this.setControl((Control)this.container);
        this.toggleAllocationGroup(false);
        this.ReplaceMem = "N";
    }

    public void createDispGroup() {
        Group disp_grp = new Group(this.container, 0);
        disp_grp.setText("Disposition");
        disp_grp.setLayout((Layout)new GridLayout(5, false));
        GridData gd_disp = new GridData(4, 128, true, false);
        disp_grp.setLayoutData((Object)gd_disp);
        this.btnshr = new Button((Composite)disp_grp, 16);
        this.btnshr.addSelectionListener((SelectionListener)this);
        this.btnshr.setText("S&HR");
        this.btnshr.setSelection(true);
        this.btnold = new Button((Composite)disp_grp, 16);
        this.btnold.setText("&OLD");
        this.btnold.addSelectionListener((SelectionListener)this);
        this.btnmod = new Button((Composite)disp_grp, 16);
        this.btnmod.setText("&MOD");
        this.btnmod.addSelectionListener((SelectionListener)this);
        this.btnnew = new Button((Composite)disp_grp, 16);
        this.btnnew.addSelectionListener((SelectionListener)this);
        this.btnnew.addSelectionListener((SelectionListener)this);
        this.btnnew.setText("N&EW");
        this.btnnew.setEnabled(false);
    }

    public void createAllocationGroup() {
        Group grpnewAllocation = new Group(this.container, 0);
        grpnewAllocation.setText("New Allocation");
        grpnewAllocation.setLayout((Layout)new GridLayout(5, false));
        GridData gd_new_alloc = new GridData(4, 128, true, false);
        grpnewAllocation.setLayoutData((Object)gd_new_alloc);
        this.btnpds = new Button((Composite)grpnewAllocation, 16);
        this.btnpds.addSelectionListener((SelectionListener)this);
        this.btnpds.setText("&PDS");
        this.btnseq = new Button((Composite)grpnewAllocation, 16);
        this.btnseq.setText("SE&Q");
        this.btnseq.setSelection(true);
        this.btnvsam = new Button((Composite)grpnewAllocation, 16);
        this.btnvsam.setText("VS&AM");
        this.btnAllocate = new Button((Composite)grpnewAllocation, 8);
        this.btnAllocate.addSelectionListener((SelectionListener)this);
        this.btnAllocate.setToolTipText("Output dataset does not currently exist and will be allocated before proceeding with the copy");
        this.btnAllocate.setText("Allo&cate...");
    }

    public void createOptionsGroup() {
        Group optionsGroup = new Group(this.container, 0);
        optionsGroup.setText("Options");
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd_options = new GridData(4, 128, true, false);
        optionsGroup.setLayoutData((Object)gd_options);
        this.btnduplicateKeys = new Button((Composite)optionsGroup, 32);
        this.btnduplicateKeys.setText("Replace duplicate &keys in KSDS");
        this.btnduplicateKeys.addSelectionListener((SelectionListener)this);
        this.btnlikenamedMembers = new Button((Composite)optionsGroup, 32);
        this.btnlikenamedMembers.setText("&Replace like-named members");
        this.btnlikenamedMembers.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    @Override
    public boolean isPageComplete() {
        this.error = "";
        if (((CopySeqFromWizardPage)this.getWizard().getPage("Copy Sequential From")).getFromDataSetName().equalsIgnoreCase(this.toDataSetCombo.getText().trim())) {
            this.setErrorMessage("Duplicate From and To data set names");
            return false;
        }
        if (this.btnMemberSelect != null && this.btnnew != null && this.toVolumeCombo != null) {
            if (!this.btnnew.getSelection()) {
                this.btnnew.setEnabled(false);
                this.toggleAllocationGroup(false);
            }
            if (this.btnnew.isEnabled() && this.btnnew.getSelection()) {
                this.error = String.valueOf(this.error) + Validator.errorMsg[11] + "\n";
            }
            switch (Validator.member(this.toMemberCombo.getText(), false)) {
                case 7: {
                    if (Validator.dataset(this.toDataSetCombo.getText(), true) != 0) break;
                    this.btnMemberSelect.setEnabled(true);
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.toMemberCombo.getText(), false)] + "\n ";
                    this.btnMemberSelect.setEnabled(false);
                    break;
                }
                case 0: {
                    this.btnMemberSelect.setEnabled(false);
                }
            }
            if (this.toMemberCombo.getText().trim().length() == 0 && Validator.dataset(this.toDataSetCombo.getText(), true) == 0) {
                this.btnMemberSelect.setEnabled(true);
            }
            switch (Validator.volume(this.toVolumeCombo.getText(), false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.toVolumeCombo.getText(), false)] + "\n ";
                }
            }
            if (super.isPageComplete()) {
                this.btnnew.setEnabled(true);
                if (this.btnnew.getSelection()) {
                    this.toggleAllocationGroup(true);
                }
                if (this.getErrorMessage() == null && this.dataSetCombo.getText() != "") {
                    if (FMPreferences.disabledPreview()) {
                        return true;
                    }
                    ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (CopySeqToWizardPage.this.map.get("Action") == null) {
                                CopySeqToWizardPage.this.map.put("Action", "Preview");
                            }
                            this.displaySummaryPage();
                        }

                        private void displaySummaryPage() {
                            ((CopySequentialSummaryPage)CopySeqToWizardPage.this.getWizard().getPage("Copy SEQ Summary")).presetText();
                            CopySeqToWizardPage.this.getWizard().getContainer().showPage((IWizardPage)((CopySequentialSummaryPage)CopySeqToWizardPage.this.getWizard().getPage("Copy SEQ Summary")));
                        }
                    });
                    ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(15).addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (CopySeqToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopySequentialSummaryPage) {
                                CopySeqToWizardPage.this.setAction("Finish");
                            }
                        }
                    });
                    this.getWizard().getContainer().getShell().addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent event) {
                            if (event.stateMask == 65536) {
                                if (event.character == 'p' || event.character == 'P') {
                                    CopySeqToWizardPage.this.setAction("Finish");
                                    ((CopySequentialSummaryPage)CopySeqToWizardPage.this.getWizard().getPage("Copy Summary")).presetText();
                                    CopySeqToWizardPage.this.getWizard().getContainer().showPage(CopySeqToWizardPage.this.getWizard().getPage("Copy Summary"));
                                }
                                if ((event.character == 'n' || event.character == 'N') && CopySeqToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopySequentialSummaryPage) {
                                    CopySeqToWizardPage.this.setAction("Finish");
                                }
                            }
                            if (event.character == '\r' && !(Display.getCurrent().getFocusControl() instanceof Text)) {
                                if (((Shell)event.widget).getDefaultButton().getText() == "&Preview") {
                                    if (CopySeqToWizardPage.this.getAction() == null) {
                                        CopySeqToWizardPage.this.setAction("Preview");
                                    }
                                    ((CopySequentialSummaryPage)CopySeqToWizardPage.this.getWizard().getPage("Copy Summary")).presetText();
                                    CopySeqToWizardPage.this.getWizard().getContainer().showPage(CopySeqToWizardPage.this.getWizard().getPage("Copy Summary"));
                                }
                                if (((Shell)event.widget).getDefaultButton().getText().equals("< &Back") && CopySeqToWizardPage.this.getAction() == "Finish") {
                                    ((TestingToolsWizardDialog)CopySeqToWizardPage.this.getWizard().getContainer()).getButton(16).setText("&Preview");
                                    CopySeqToWizardPage.this.setAction("Preview");
                                }
                                if (((Shell)event.widget).getDefaultButton().getText().equals("&Next >") && CopySeqToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopySequentialSummaryPage) {
                                    CopySeqToWizardPage.this.setAction("Finish");
                                }
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
            if (this.error.contains("Missing")) {
                this.btnnew.setEnabled(false);
                this.toggleAllocationGroup(false);
            }
            return false;
        }
        return false;
    }

    public String getAction() {
        return this.map.get("Action");
    }

    public void setAction(String action) {
        this.map.put("Action", action);
    }

    public IWizardPage getNextPage() {
        return (SeqSelectionCrtLayoutWizardPage)this.getWizard().getPage("Options");
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("Allo&cate...")) {
            if (this.btnvsam.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewVSAMDataSetWizard(this.toDataSetCombo.getText(), this.server, ""));
                this.dialog.create();
                this.dialog.open();
            } else if (this.btnpds.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(true, this.toDataSetCombo.getText().trim(), false, this.server, ""));
                this.dialog.create();
                this.dialog.open();
            } else if (this.btnseq.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(false, this.toDataSetCombo.getText().trim(), false, this.server, ((CopySeqFromWizardPage)this.getPreviousPage()).getFromDataSetName()));
                this.dialog.create();
                this.dialog.open();
            }
        } else if (((Button)source).getText().equals("S&HR") || ((Button)source).getText().equals("&OLD") || ((Button)source).getText().equals("&MOD")) {
            this.toggleAllocationGroup(false);
        } else if (((Button)source).getText().equals("N&EW")) {
            this.toggleAllocationGroup(true);
            this.setPageComplete(this.isPageComplete());
        } else if (((Button)source).getText().equals("Replace duplicate &keys in KSDS")) {
            this.replaceKSDSDupKeys = this.btnduplicateKeys.getSelection() ? "Y" : "N";
        } else if (((Button)source).getText().equals("&Replace like-named members")) {
            this.ReplaceMem = this.btnlikenamedMembers.getSelection() ? "Y" : "N";
        }
    }

    private void toggleAllocationGroup(boolean enabled) {
        if (this.btnpds != null && this.btnseq != null && this.btnvsam != null && this.btnAllocate != null) {
            this.btnpds.setEnabled(enabled);
            this.btnseq.setEnabled(enabled);
            this.btnvsam.setEnabled(enabled);
            this.btnAllocate.setEnabled(enabled);
        }
    }

    public void setDisp(String disp) {
        if (disp.equalsIgnoreCase("SHR")) {
            this.btnshr.setSelection(true);
            this.btnold.setSelection(false);
            this.btnnew.setSelection(false);
        }
        this.toggleAllocationGroup(false);
        this.setPageComplete(this.isPageComplete());
    }

    public boolean doFinish() {
        ImportSelCritWizardPage.conditions = "";
        if (this.getAction() == "Preview") {
            this.setAction("Finish");
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Finish");
            return false;
        }
        XMLRequest xml = this.doConnection();
        this.handleResponse(xml);
        if (this.dirListInsert != null && this.dirListInsert.getSelection() && this.performCopy) {
            String typeOfDSN = "";
            if (this.fmdataset != null && this.fmdataset.getName().equalsIgnoreCase(this.dataSetCombo.getText().trim())) {
                typeOfDSN = this.fmdataset.getDsOrg();
                if (typeOfDSN.trim().isEmpty()) {
                    typeOfDSN = this.fmdataset.getFileType();
                }
            } else {
                FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(this.dataSetCombo.getText(), this.toVolumeCombo.getText(), this.server);
                if (CommonMFCalls.RETURN_CODE.equals("0")) {
                    typeOfDSN = FMDataSet.getDsOrg();
                    if (typeOfDSN.trim().isEmpty()) {
                        typeOfDSN = this.fmdataset.getFileType();
                    }
                } else {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + CommonMFCalls.RETURN_CODE), (Throwable)new Throwable(CommonMFCalls.MESSAGE));
                }
            }
            if (typeOfDSN.isEmpty()) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set");
            }
            this.datasetto.setDsOrg(typeOfDSN);
            this.insertIntoDirecotryList(this.datasetto);
        }
        if (((CopySeqFromWizardPage)this.getPreviousPage()).dirListInsertFrom() && this.performCopy) {
            this.fmDataset.setName(((CopySeqFromWizardPage)this.getWizard().getPage("Copy Sequential From")).getFromDataSetName());
            this.insertIntoDirecotryList(this.datasetfrom);
        }
        FMHistory.insertHistory(((CopySeqFromWizardPage)this.getWizard().getPage("Copy Sequential From")).getFromVolumeCombo(), "FromVolumeListCopySeq");
        FMHistory.insertHistory(this.toDataSetCombo, "ToDatasetListCopySEQ");
        FMHistory.insertHistory(this.toVolumeCombo, "ToVolumeListCopySeq");
        FMHistory.insertHistory(this.toMemberCombo, "ToMemberListCopySeq");
        if (((SeqSelectionCrtLayoutWizardPage)this.getNextPage()).getDataSetCombo() != null && ((SeqSelectionCrtLayoutWizardPage)this.getNextPage()).getMemberCombo() != null) {
            FMHistory.insertHistory(((SeqSelectionCrtLayoutWizardPage)this.getNextPage()).getDataSetCombo(), "SeqCopyLayoutPageDatasetList");
            FMHistory.insertHistory(((SeqSelectionCrtLayoutWizardPage)this.getNextPage()).getMemberCombo(), "SeqCopyLayoutPageMemberList");
        }
        return true;
    }

    private void handleResponse(XMLRequest xml) {
        ArrayList<String> contentAL = new ArrayList<String>();
        if (xml != null) {
            Element element = xml.getRoot();
            if (!element.getAttribute("errorlevel").equalsIgnoreCase("0")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Line");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + CopySeqToWizardPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = CopySeqToWizardPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    int returnCodeInt = Integer.parseInt(returnCode);
                    if (returnCodeInt > 4) {
                        this.performCopy = false;
                    }
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element lineElement = (Element)nodes.item(i);
                        String line = new String();
                        line = CopySeqToWizardPage.getTagValue("Line", lineElement);
                        contentAL.add(line);
                        ++i;
                    }
                    super.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                }
            }
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    private XMLRequest doConnection() {
        this.datasetsList = new ArrayList();
        this.datasetfrom = new FileMasterDataset(null);
        this.datasetfrom.setName(((CopySeqFromWizardPage)this.getWizard().getPage("Copy Sequential From")).getFromDataSetName());
        this.datasetfrom.setDsOrg(this.dataSet.getDsOrg());
        this.datasetfrom.setVolume(((CopySeqFromWizardPage)this.getWizard().getPage("Copy Sequential From")).getFromVolumeCombo().getText());
        this.datasetsList.add(0, this.datasetfrom);
        this.datasetto = new FileMasterDataset(null);
        this.datasetto.setName(((CopySeqToWizardPage)this.getWizard().getPage("Copy Sequential To")).getToDataSetCombo().getText());
        this.datasetto.setVolume(((CopySeqToWizardPage)this.getWizard().getPage("Copy Sequential To")).getToVolumeCombo().getText());
        this.datasetsList.add(1, this.datasetto);
        this.membersList = new ArrayList();
        FileMasterMember memberTo = new FileMasterMember(null);
        memberTo.setName(((CopySeqToWizardPage)this.getWizard().getPage("Copy Sequential To")).getToMemberCombo().getText());
        memberTo.setNewName("");
        this.membersList.add(memberTo);
        String disposition = ((CopySeqToWizardPage)this.getWizard().getPage("Copy Sequential To")).getDisp();
        switch (DispositionEnum.valueOf(disposition)) {
            case MOD: {
                disposition = "M";
                break;
            }
            case NEW: {
                disposition = "N";
                break;
            }
            case SHR: {
                disposition = "S";
                break;
            }
            case OLD: {
                disposition = "O";
            }
        }
        if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).isLayoutView()) {
            String layout = ((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutViewCombo();
            String string = layout = layout.equals("(none)") ? "" : layout;
            if (layout.length() > 0) {
                int left = layout.indexOf("(");
                int right = layout.indexOf(")");
                this.layoutDataset.setName(layout.substring(0, left));
                this.datasetsList.add(2, this.layoutDataset);
                this.layoutMembers.setName(layout.substring(left + 1, right));
            } else {
                this.layoutDataset.setName("");
                this.datasetsList.add(2, this.layoutDataset);
                this.layoutMembers.setName("");
            }
        } else if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).isDSN()) {
            this.layoutDataset.setName(((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutDataset());
            this.datasetsList.add(2, this.layoutDataset);
            this.layoutMembers.setName(((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutMember());
        }
        if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton != null && ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton.isEnabled()) {
            ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.displayMessage = false;
            ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton.notifyListeners(13, new Event());
        }
        String selCritContent = "";
        int i = 0;
        while (i < ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.getContent().size()) {
            selCritContent = String.valueOf(selCritContent) + ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.getContent().get(i).toString() + "\r\n";
            ++i;
        }
        this.selCrit.add(0, selCritContent);
        RunGetCopyDS runner = new RunGetCopyDS(this.server, this.datasetsList, this.membersList, this.ReplaceMem, this.replaceKSDSDupKeys, disposition, this.layoutMembers, this.selCrit, "SEQ");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        return runner.getXml();
    }

    public String getOptions() {
        if (this.btnlikenamedMembers.getSelection()) {
            this.ReplaceMem = "Y";
            return "Replace liked-named members";
        }
        this.ReplaceMem = "N";
        return "";
    }

    public void insertDSNToField(String value) {
        this.toDataSetCombo.setText(value);
    }

    public void insertMemberToField(String value) {
        this.toMemberCombo.setText(value);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.toDataSetCombo.setFocus();
    }

    public Combo getToDataSetCombo() {
        return this.toDataSetCombo;
    }

    public Combo getToMemberCombo() {
        return this.toMemberCombo;
    }

    public Combo getToVolumeCombo() {
        return this.toVolumeCombo;
    }

    public String getDisp() {
        if (this.btnold.getSelection()) {
            return "OLD";
        }
        if (this.btnmod.getSelection()) {
            return "MOD";
        }
        return "SHR";
    }

    public void insertIntoDirecotryList(FileMasterDataset dataset) {
        TT_TreeItem dsItem = null;
        int index = 0;
        int i = 0;
        while (i < this.model.getServers().length) {
            if (this.model.getServers()[i].getName().equals(this.server.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        dsItem = this.model.findObjectInTree((Object)dataset, this.model.getServers()[index]);
        if (dsItem == null) {
            Element dsElement = this.model.addDataset(this.server.getElement(), dataset.getName(), "", "", "", dataset.getDsOrg());
            dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
        }
        if (!this.memberList.isEmpty()) {
            this.insertMemberToTree(dsItem, this.memberList);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
            if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                viewer.refresh(true);
                view = page.showView("com.ca.filemaster.views.directorylist");
                page.activate((IWorkbenchPart)view);
                page.bringToTop((IWorkbenchPart)view);
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {}
        this.model.save();
    }

    private void insertMemberToTree(TT_TreeItem dsItem, String name) {
        boolean isDuplicatedMember = false;
        FileMasterMember fmmember = new FileMasterMember(null);
        if (name.length() != 0) {
            fmmember.setName(name.trim());
            fmmember.setType("MEMBER");
            if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                isDuplicatedMember = true;
            }
            if (!isDuplicatedMember) {
                Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.model.insertMember(dsItem, memItem);
            }
        }
    }

    public static enum DispositionEnum {
        MOD,
        NEW,
        OLD,
        SHR;

    }
}

