/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.utilities.CopyGenericWizard;
import com.ca.filemaster.utility.copy.CopySeqToWizardPage;
import com.ca.filemaster.utility.copy.CopySequentialWizard;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CopySeqFromWizardPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(CopySeqFromWizardPage.class.getName());
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copySEQWizardPage";
    private String fromDataSetName;
    private Label serverNameLabel;
    private Label volSerialLabel;
    private Text serverNameCombo;
    private Text fromdataSetCombo;
    private Combo fromVolumeCombo;
    private boolean isCopySeqWizard;
    private String volumeSerial;
    private Button dirListInsert;
    protected FileMasterDataset dataSet;
    protected FileMasterServer server;

    public CopySeqFromWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, String volumeSerial, boolean isCopySeqWizard) {
        this(pageName, server, dataSet, isCopySeqWizard);
        this.volumeSerial = volumeSerial;
    }

    public CopySeqFromWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, boolean isCopySeqWizard) {
        super(pageName, "", server);
        this.setTitle("Copy Sequential From");
        this.fromDataSetName = dataSet.getName();
        this.server = server;
        this.dataSet = dataSet;
        this.isCopySeqWizard = isCopySeqWizard;
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copySEQWizardPage");
        super.createControl(parent);
        this.data = new GridData();
        this.data.horizontalAlignment = 4;
        this.data.verticalAlignment = 0;
        this.data.grabExcessHorizontalSpace = true;
        this.data.grabExcessVerticalSpace = true;
        this.data.horizontalSpan = 1;
        this.data.verticalSpan = 1;
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Text(this.dataSetComposite, 2056);
        this.serverNameCombo.setLayoutData((Object)this.data);
        this.serverNameCombo.setText(this.server.getText());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.fromdataSetCombo = new Text(this.dataSetComposite, 2056);
        this.fromdataSetCombo.setTextLimit(44);
        this.fromdataSetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.fromdataSetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.fromdataSetCombo, (int)37);
        this.fromdataSetCombo.setText(this.fromDataSetName);
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.volSerialLabel = new Label(this.dataSetComposite, 0);
        this.volSerialLabel.setText("&Volume serial:");
        this.fromVolumeCombo = new Combo(this.dataSetComposite, 2048);
        this.fromVolumeCombo.setTextLimit(6);
        GridData gd_fromVolumeCombo = new GridData(4, 4, false, false, 1, 1);
        gd_fromVolumeCombo.widthHint = 107;
        this.fromVolumeCombo.setLayoutData((Object)gd_fromVolumeCombo);
        this.fromVolumeCombo.addModifyListener((ModifyListener)this);
        this.fromVolumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.fromVolumeCombo, "FromVolumeListCopySeq");
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        if (!this.isCopySeqWizard) {
            this.dirListInsert = new Button(this.container, 32);
            this.dirListInsert.setText("Add to Director&y List view");
        }
        if (!FMPreferences.disabledPreview()) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
        }
        this.setControl((Control)this.container);
    }

    public void widgetSelected(SelectionEvent e) {
        super.FMWWidgetSelected(e);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        if (this.fromVolumeCombo != null) {
            switch (Validator.volume(this.fromVolumeCombo.getText(), false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.fromVolumeCombo.getText(), false)] + "\n ";
                }
            }
        }
        return super.isPageComplete();
    }

    public IWizardPage getNextPage() {
        CopySeqToWizardPage page1 = new CopySeqToWizardPage("Copy Sequential To", this.server, this.dataSet, this.isCopySeqWizard);
        if (this.isCopySeqWizard) {
            ((CopySequentialWizard)this.getWizard()).addPage((IWizardPage)page1);
            return ((CopySequentialWizard)this.getWizard()).getPage("Copy Sequential To");
        }
        ((CopyGenericWizard)this.getWizard()).addPage((IWizardPage)page1);
        return ((CopyGenericWizard)this.getWizard()).getPage("Copy Sequential To");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fromdataSetCombo.setFocus();
        if (this.volumeSerial != null) {
            this.fromVolumeCombo.setText(this.volumeSerial);
        }
    }

    public String getFromDataSetName() {
        return this.fromdataSetCombo.getText().trim();
    }

    public Combo getFromVolumeCombo() {
        return this.fromVolumeCombo;
    }

    public void insertDSNToField(String value) {
        this.fromdataSetCombo.setText(value);
    }

    public boolean dirListInsertFrom() {
        if (this.dirListInsert == null) {
            return false;
        }
        return this.dirListInsert.getSelection();
    }

    public void setFromDataSetCombo(FileMasterDataset fromDataset) {
        this.dataSet = fromDataset;
        if (this.fromdataSetCombo != null) {
            this.fromdataSetCombo.setText(fromDataset.getName());
        }
    }

    public FileMasterDataset getFromDataSet() {
        return this.dataSet;
    }
}

