/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.copy;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetCopyDS;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.utilities.AllocateNewDataSetWizard;
import com.ca.filemaster.utilities.AllocateNewVSAMDataSetWizard;
import com.ca.filemaster.utilities.CopyGenericWizard;
import com.ca.filemaster.utility.copy.CopyPDSFromWizardPage;
import com.ca.filemaster.utility.copy.CopyPDSSummaryPage;
import com.ca.filemaster.utility.copy.CopyPDSWizard;
import com.ca.filemaster.utility.copy.PDSSelectionCrtLayoutWizardPage;
import com.ca.filemaster.utility.copy.SelectionCrtLayoutWizardPage;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopyPDSToWizardPage
extends FileMasterWizard
implements SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(CopyPDSToWizardPage.class.getName());
    Level baseLevel = this.log.getLevel();
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.copyPDSToUtilityWizardPage";
    private Label VolumeLabel;
    private Combo toDataSetCombo;
    private Combo toVolumeCombo;
    private Button btnshr;
    private Button btnold;
    private Button btnnew;
    private Button btnpds;
    private Button btnseq;
    private Button btnvsam;
    private Button btnAllocate;
    private Button btnlikenamedMembers;
    private Button dirListInsert;
    private Group disp_grp;
    private boolean setFocus = false;
    private boolean isCopyPDSWizard;
    private boolean performCopy = true;
    private String disposition;
    private String ReplaceMem;
    private Map<String, String> map;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private FileMasterDataset fmDataset = new FileMasterDataset(null);
    private String[] memberList;
    ArrayList<FileMasterDataset> datasetsList = new ArrayList();
    ArrayList<FileMasterMember> membersList = new ArrayList();
    FileMasterMember layoutMembers = new FileMasterMember(null);
    FileMasterDataset layoutDataset = new FileMasterDataset(null);
    ArrayList<String> selCrit = new ArrayList();
    private FileMasterMember member;
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    FileMasterDataset datasetfrom = new FileMasterDataset(null);
    FileMasterDataset datasetto = new FileMasterDataset(null);

    protected CopyPDSToWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataSet, String memberName, boolean isCopyPDSWizard) {
        super(pageName, "", server);
        this.setTitle("Copy PDS To");
        this.server = server;
        this.dataSet = dataSet;
        this.isCopyPDSWizard = isCopyPDSWizard;
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.copyPDSToUtilityWizardPage");
        super.createControl(parent);
        super.createDataSet();
        this.toDataSetCombo = this.dataSetCombo;
        this.map = new HashMap<String, String>();
        FMHistory.intializeComboBoxes(this.toDataSetCombo, "ToDatasetListCopyPDS");
        this.VolumeLabel = new Label(this.dataSetComposite, 0);
        this.VolumeLabel.setText("&Volume serial:");
        this.toVolumeCombo = new Combo(this.dataSetComposite, 2048);
        TextUtil.setWidth((Combo)this.toVolumeCombo, (int)37);
        this.toVolumeCombo.setTextLimit(6);
        this.toVolumeCombo.addModifyListener((ModifyListener)this);
        this.toVolumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.toVolumeCombo.setLayoutData((Object)this.data);
        FMHistory.intializeComboBoxes(this.toVolumeCombo, "ToVolumeListCopyPDS");
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.createDispGroup();
        this.createAllocationGroup();
        this.createOptionsGroup();
        this.isPageComplete();
        if (!this.isCopyPDSWizard) {
            this.dirListInsert = new Button(this.container, 32);
            this.dirListInsert.setText("Add to Director&y List view");
        }
        this.setControl((Control)this.container);
        this.toggleAllocationGroup(false);
        this.ReplaceMem = "N";
    }

    public void createDispGroup() {
        this.disp_grp = new Group(this.container, 0);
        this.disp_grp.setText("Disposition");
        this.disp_grp.setLayout((Layout)new GridLayout(3, false));
        GridData gd_disp = new GridData(4, 128, true, false);
        this.disp_grp.setLayoutData((Object)gd_disp);
        this.btnshr = new Button((Composite)this.disp_grp, 16);
        this.btnshr.setText("S&HR");
        this.btnshr.setSelection(true);
        this.disposition = "SHR";
        this.btnold = new Button((Composite)this.disp_grp, 16);
        this.btnold.setText("&OLD");
        this.btnnew = new Button((Composite)this.disp_grp, 16);
        this.btnnew.setText("N&EW");
        this.btnnew.addSelectionListener((SelectionListener)this);
        this.btnshr.addSelectionListener((SelectionListener)this);
        this.btnold.addSelectionListener((SelectionListener)this);
    }

    public void createAllocationGroup() {
        Group new_alloc_grp = new Group(this.container, 0);
        new_alloc_grp.setText("New allocation");
        new_alloc_grp.setLayout((Layout)new GridLayout(4, false));
        GridData gd_new_alloc = new GridData(4, 128, true, false);
        new_alloc_grp.setLayoutData((Object)gd_new_alloc);
        this.btnpds = new Button((Composite)new_alloc_grp, 16);
        this.btnpds.setText("&PDS");
        this.btnpds.setSelection(true);
        this.btnpds.setEnabled(false);
        this.btnseq = new Button((Composite)new_alloc_grp, 16);
        this.btnseq.setText("SE&Q");
        this.btnseq.setSelection(false);
        this.btnseq.setEnabled(false);
        this.btnvsam = new Button((Composite)new_alloc_grp, 16);
        this.btnvsam.setText("VS&AM");
        this.btnvsam.setSelection(false);
        this.btnvsam.setEnabled(false);
        this.btnAllocate = new Button((Composite)new_alloc_grp, 8);
        this.btnAllocate.addSelectionListener((SelectionListener)this);
        this.btnAllocate.setEnabled(false);
        this.btnAllocate.setText("Allo&cate...");
    }

    public void createOptionsGroup() {
        Group optionsGroup = new Group(this.container, 0);
        optionsGroup.setText("Options");
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd_options = new GridData(4, 128, true, false);
        optionsGroup.setLayoutData((Object)gd_options);
        this.btnlikenamedMembers = new Button((Composite)optionsGroup, 32);
        this.btnlikenamedMembers.setText("&Replace like-named members");
        this.btnlikenamedMembers.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("Allo&cate...")) {
            if (this.btnvsam.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewVSAMDataSetWizard(this.toDataSetCombo.getText(), this.server, ""));
                this.dialog.create();
                this.dialog.open();
            } else if (this.btnpds.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(true, this.toDataSetCombo.getText().trim(), false, this.server, ((CopyPDSFromWizardPage)this.getPreviousPage()).getFromDataSetName()));
                this.dialog.create();
                this.dialog.open();
            } else if (this.btnseq.getSelection()) {
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)new AllocateNewDataSetWizard(false, this.toDataSetCombo.getText().trim(), false, this.server, ""));
                this.dialog.create();
                this.dialog.open();
            }
        } else if (((Button)source).getText().equals("S&HR") || ((Button)source).getText().equals("&OLD")) {
            this.toggleAllocationGroup(false);
            this.disposition = ((CopyPDSToWizardPage)this.getWizard().getPage("Copy PDS To")).getDisposition();
        } else if (((Button)source).getText().equals("N&EW")) {
            this.toggleAllocationGroup(true);
            this.disposition = ((Button)source).getText();
            this.setPageComplete(this.isPageComplete());
        } else if (((Button)source).getText().equals("&Replace like-named members")) {
            this.ReplaceMem = this.btnlikenamedMembers.getSelection() ? "Y" : "N";
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    @Override
    public boolean isPageComplete() {
        int numCheckedMembers;
        this.error = "";
        if (((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromDataSetName().equalsIgnoreCase(this.toDataSetCombo.getText().trim()) && (numCheckedMembers = ((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getCheckedElements().length) > 0) {
            String[] tempMemberList = new String[numCheckedMembers];
            String[] NewNameMemberList = new String[numCheckedMembers];
            int i = 0;
            while (i < numCheckedMembers) {
                tempMemberList[i] = ((FileMasterMember)((Object)((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getElementAt(i))).getName();
                NewNameMemberList[i] = ((FileMasterMember)((Object)((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getElementAt(i))).getNewName();
                if (NewNameMemberList[i].isEmpty()) {
                    this.setErrorMessage("Specify rename value for member  " + tempMemberList[i] + ". Click back.");
                    return false;
                }
                ++i;
            }
        }
        if (this.setFocus) {
            this.dataSetCombo.setFocus();
            this.datasetto.setName(this.dataSetCombo.getText());
        }
        if (this.toVolumeCombo != null && this.btnnew != null) {
            if (!this.btnnew.getSelection()) {
                this.btnnew.setEnabled(false);
                this.toggleAllocationGroup(false);
            }
            if (this.btnnew.isEnabled() && this.btnnew.getSelection()) {
                this.error = String.valueOf(this.error) + Validator.errorMsg[11] + "\n";
            }
            switch (Validator.volume(this.toVolumeCombo.getText(), false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.toVolumeCombo.getText(), false)] + "\n ";
                }
            }
            if (super.isPageComplete()) {
                this.btnnew.setEnabled(true);
                if (this.btnnew.getSelection()) {
                    this.toggleAllocationGroup(true);
                }
                if (this.getErrorMessage() == null && this.dataSetCombo.getText() != "") {
                    if (FMPreferences.disabledPreview()) {
                        return true;
                    }
                    ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (CopyPDSToWizardPage.this.map.get("Action") == null) {
                                CopyPDSToWizardPage.this.map.put("Action", "Preview");
                            }
                            this.displaySummaryPage();
                        }

                        private void displaySummaryPage() {
                            ((CopyPDSSummaryPage)CopyPDSToWizardPage.this.getWizard().getPage("Copy PDS Summary")).presetText();
                            CopyPDSToWizardPage.this.getWizard().getContainer().showPage((IWizardPage)((CopyPDSSummaryPage)CopyPDSToWizardPage.this.getWizard().getPage("Copy PDS Summary")));
                        }
                    });
                    ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(15).addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (CopyPDSToWizardPage.this.getWizard().getContainer().getCurrentPage().getNextPage() instanceof CopyPDSSummaryPage) {
                                CopyPDSToWizardPage.this.setAction("Finish");
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
            if (this.error.contains("Missing")) {
                this.btnnew.setEnabled(false);
                this.toggleAllocationGroup(false);
            }
            return false;
        }
        return false;
    }

    public String getAction() {
        return this.map.get("Action");
    }

    public void setAction(String action) {
        this.map.put("Action", action);
    }

    private void toggleAllocationGroup(boolean enabled) {
        if (this.btnpds != null && this.btnseq != null && this.btnvsam != null && this.btnAllocate != null) {
            this.btnpds.setEnabled(enabled);
            this.btnseq.setEnabled(enabled);
            this.btnvsam.setEnabled(enabled);
            this.btnAllocate.setEnabled(enabled);
        }
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() instanceof CopyGenericWizard) {
            return (SelectionCrtLayoutWizardPage)((CopyGenericWizard)this.getWizard()).getPage("Options");
        }
        return (SelectionCrtLayoutWizardPage)((CopyPDSWizard)this.getWizard()).getPage("Options");
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("Copy PDS From");
    }

    public boolean canFlipToNextPage() {
        if (!this.isPageComplete()) {
            return false;
        }
        if (FMPreferences.disabledPreview()) {
            return true;
        }
        return true;
    }

    public void setDisp(String disp) {
        if (disp.equalsIgnoreCase("SHR")) {
            this.btnshr.setSelection(true);
            this.btnold.setSelection(false);
            this.btnnew.setSelection(false);
        }
        this.toggleAllocationGroup(false);
        this.setPageComplete(this.isPageComplete());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.dataSetCombo.setFocus();
    }

    public boolean doFinish() {
        ImportSelCritWizardPage.conditions = "";
        if (this.getAction() == "Preview") {
            this.setAction("Finish");
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Finish");
            return false;
        }
        XMLRequest xml = this.doConnection();
        this.handleResponse(xml);
        if (this.dirListInsert != null && this.dirListInsert.getSelection() && this.performCopy) {
            String typeOfDSN = "";
            if (this.fmdataset != null && this.fmdataset.getName().equalsIgnoreCase(this.dataSetCombo.getText().trim())) {
                typeOfDSN = this.fmdataset.getDsOrg();
                if (typeOfDSN.trim().isEmpty()) {
                    typeOfDSN = this.fmdataset.getFileType();
                }
            } else {
                FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(this.dataSetCombo.getText(), this.toVolumeCombo.getText(), this.server);
                if (CommonMFCalls.RETURN_CODE.equals("0")) {
                    typeOfDSN = FMDataSet.getDsOrg();
                    if (typeOfDSN.trim().isEmpty()) {
                        typeOfDSN = this.fmdataset.getFileType();
                    }
                } else {
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + CommonMFCalls.RETURN_CODE), (Throwable)new Throwable(CommonMFCalls.MESSAGE));
                }
            }
            if (typeOfDSN.isEmpty()) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set");
            }
            this.datasetto.setDsOrg(typeOfDSN);
            this.memberList = ((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getToMemberList();
            this.insertIntoDirecotryList(this.datasetto);
        }
        if (((CopyPDSFromWizardPage)this.getPreviousPage()).dirListInsertFrom() && this.performCopy) {
            this.memberList = ((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromMemberList();
            this.fmDataset.setName(((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromDataSetName());
            this.insertIntoDirecotryList(this.datasetfrom);
        }
        FMHistory.insertHistory(((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromMemberNameCombo(), "FromMemberListCopyPDS");
        FMHistory.insertHistory(((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromVolumeCombo(), "FromVolumeListCopyPDS");
        FMHistory.insertHistory(this.toDataSetCombo, "ToDatasetListCopyPDS");
        FMHistory.insertHistory(this.toVolumeCombo, "ToVolumeListCopyPDS");
        if (((PDSSelectionCrtLayoutWizardPage)this.getNextPage()).getDataSetCombo() != null && ((PDSSelectionCrtLayoutWizardPage)this.getNextPage()).getMemberCombo() != null) {
            FMHistory.insertHistory(((PDSSelectionCrtLayoutWizardPage)this.getNextPage()).getDataSetCombo(), "PDSCopyLayoutPageDatasetList");
            FMHistory.insertHistory(((PDSSelectionCrtLayoutWizardPage)this.getNextPage()).getMemberCombo(), "PDSCopyLayoutPageMemberList");
        }
        return true;
    }

    private void handleResponse(XMLRequest xml) {
        ArrayList<String> contentAL = new ArrayList<String>();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Line");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + CopyPDSToWizardPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = CopyPDSToWizardPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    int returnCodeInt = Integer.parseInt(returnCode);
                    if (returnCodeInt > 4) {
                        this.performCopy = false;
                    }
                } else {
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element lineElement = (Element)nodes.item(i);
                        String line = new String();
                        line = CopyPDSToWizardPage.getTagValue("Line", lineElement);
                        contentAL.add(line);
                        ++i;
                    }
                    super.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                }
            }
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    private XMLRequest doConnection() {
        this.datasetsList = new ArrayList();
        this.datasetfrom = new FileMasterDataset(null);
        this.datasetfrom.setName(((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromDataSetName());
        this.datasetfrom.setVolume(((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromVolumeCombo().getText());
        this.datasetfrom.setDsOrg(this.dataSet.getDsOrg());
        this.datasetsList.add(0, this.datasetfrom);
        this.datasetto = new FileMasterDataset(null);
        this.datasetto.setName(((CopyPDSToWizardPage)this.getWizard().getPage("Copy PDS To")).getToDataSetCombo().getText());
        this.datasetto.setVolume(((CopyPDSToWizardPage)this.getWizard().getPage("Copy PDS To")).getToVolumeCombo().getText());
        this.datasetsList.add(1, this.datasetto);
        this.membersList = new ArrayList();
        int numCheckedMembers = ((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getCheckedElements().length;
        if (numCheckedMembers > 0) {
            int i = 0;
            while (i < numCheckedMembers) {
                this.member = new FileMasterMember(null);
                if (((FileMasterMember)((Object)((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getCheckedElements()[i])).getNewName().isEmpty()) {
                    this.member.setName(((FileMasterMember)((Object)((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getCheckedElements()[i])).getName());
                    this.member.setNewName("");
                } else {
                    this.member.setNewName(((FileMasterMember)((Object)((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getCheckedElements()[i])).getNewName());
                    this.member.setName(((FileMasterMember)((Object)((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getViewer().getCheckedElements()[i])).getName());
                }
                this.membersList.add(this.member);
                ++i;
            }
        } else {
            this.member = new FileMasterMember(null);
            this.member.setName(((CopyPDSFromWizardPage)this.getWizard().getPage("Copy PDS From")).getFromMemberName());
            this.member.setNewName("");
            this.membersList.add(this.member);
        }
        this.disposition = ((CopyPDSToWizardPage)this.getWizard().getPage("Copy PDS To")).getDisposition();
        switch (DispositionEnum.valueOf(this.disposition)) {
            case MOD: {
                this.disposition = "M";
                break;
            }
            case NEW: {
                this.disposition = "N";
                break;
            }
            case SHR: {
                this.disposition = "S";
                break;
            }
            case OLD: {
                this.disposition = "O";
            }
        }
        this.layoutDataset = new FileMasterDataset(null);
        this.layoutMembers = new FileMasterMember(null);
        this.selCrit = new ArrayList();
        if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).isLayoutView()) {
            String layout = ((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutViewCombo();
            String string = layout = layout.equals("(none)") ? "" : layout;
            if (layout.length() > 0) {
                int left = layout.indexOf("(");
                int right = layout.indexOf(")");
                this.layoutDataset.setName(layout.substring(0, left));
                this.datasetsList.add(2, this.layoutDataset);
                this.layoutMembers.setName(layout.substring(left + 1, right));
            } else {
                this.layoutDataset.setName("");
                this.datasetsList.add(2, this.layoutDataset);
                this.layoutMembers.setName("");
            }
        } else if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).isDSN()) {
            this.layoutDataset.setName(((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutDataset());
            this.datasetsList.add(2, this.layoutDataset);
            this.layoutMembers.setName(((SelectionCrtLayoutWizardPage)this.getWizard().getPage("Options")).getLayoutMember());
        }
        if (((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton != null && ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton.isEnabled()) {
            ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.displayMessage = false;
            ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.validateButton.notifyListeners(13, new Event());
        }
        String selCritContent = "";
        int i = 0;
        while (i < ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.getContent().size()) {
            selCritContent = String.valueOf(selCritContent) + ((SelectionCrtLayoutWizardPage)this.getWizard().getPage((String)"Options")).genSelCriteriaBox.getContent().get(i).toString() + "\r\n";
            ++i;
        }
        this.selCrit.add(0, selCritContent);
        RunGetCopyDS runner = new RunGetCopyDS(this.server, this.datasetsList, this.membersList, this.ReplaceMem, "false", this.disposition, this.layoutMembers, this.selCrit, "PDS");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        return runner.getXml();
    }

    public Combo getToDataSetCombo() {
        return this.toDataSetCombo;
    }

    public Combo getToVolumeCombo() {
        return this.toVolumeCombo;
    }

    public String getDisposition() {
        if (this.btnold.getSelection()) {
            return "OLD";
        }
        return "SHR";
    }

    public String getOptions() {
        if (this.btnlikenamedMembers.getSelection()) {
            this.ReplaceMem = "Y";
            return "Replace liked-named members";
        }
        this.ReplaceMem = "N";
        return "";
    }

    public void insertDSNToField(String value) {
        this.toDataSetCombo.setText(value);
    }

    public void insertIntoDirecotryList(FileMasterDataset dataset) {
        TT_TreeItem dsItem = null;
        int index = 0;
        int i = 0;
        while (i < this.model.getServers().length) {
            if (this.model.getServers()[i].getName().equals(this.server.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        dsItem = this.model.findObjectInTree((Object)dataset, this.model.getServers()[index]);
        if (dsItem == null) {
            Element dsElement = this.model.addDataset(this.server.getElement(), dataset);
            dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
        }
        if (this.memberList.length > 0 && !this.memberList[0].equalsIgnoreCase("*") && dataset.getDsOrg().equalsIgnoreCase("PDS")) {
            i = 0;
            while (i < this.memberList.length) {
                this.insertMemberToTree(dsItem, this.memberList[i]);
                ++i;
            }
        } else if (!this.memberList[0].equalsIgnoreCase("*") && dataset.getDsOrg().equalsIgnoreCase("PDS")) {
            this.insertMemberToTree(dsItem, this.memberList[0]);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TreeViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
            if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                viewer.refresh(true);
                view = page.showView("com.ca.filemaster.views.directorylist");
                page.activate((IWorkbenchPart)view);
                page.bringToTop((IWorkbenchPart)view);
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {}
        this.model.save();
    }

    private void insertMemberToTree(TT_TreeItem dsItem, String name) {
        boolean isDuplicatedMember = false;
        FileMasterMember fmmember = new FileMasterMember(null);
        if (name.length() != 0) {
            fmmember.setName(name.trim());
            fmmember.setType("MEMBER");
            if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                isDuplicatedMember = true;
            }
            if (!isDuplicatedMember) {
                Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.model.insertMember(dsItem, memItem);
            }
        }
    }

    public static enum DispositionEnum {
        MOD,
        NEW,
        OLD,
        SHR;

    }
}

