/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utilities;

import com.ca.filemaster.AllocateNewParmPDSWizard;
import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.AllocateDatasetWizard;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.utilities.AllocateNewDataSetWizard;
import com.ca.filemaster.utilities.AllocateNewDataSetWizardPage2;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class AllocateNewDataSetWizardPage1
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.allocateNewDataSetWizardPageOne";
    private final String CONTEXT_HELP_IDSEQ = "com.ca.filemaster.help.allocateNewDataSetSEQPageOne";
    private Composite container;
    private Text dataSetNameText;
    private Combo modelDataSetNameText;
    private Text volumeSerialNonSmsText;
    private Text managementClassText;
    private Text storageClassText;
    private Text dataClassText;
    private Text genericUnitNameText;
    private Button useSmsCheck;
    private Button volumeSerialRadioButton;
    private Button genericUnitNameRadioButton;
    private Button selectButton;
    private Button confirmButton;
    private Button dirListInsert;
    private boolean isPDS;
    private boolean isAllocateNewParmPDSWizard;
    private String newDataSetName = new String();
    private String modelDataSetName = new String();
    private String error;
    private FileMasterServer server;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    FileMasterDataset modelDataset;
    private Label managementClassLabel;
    private Label storageClassLabel;
    private Label dataClassLabel;
    private AllocateNewDataSetWizardPage2 nextPage;

    public AllocateNewDataSetWizardPage1() {
        super("allocateNewSeqDataSetWizardPage1");
        this.setTitle("Allocate New Sequential Or Partitioned Data Set (Page 1 of 2)");
        this.setDescription("New data set allocation parameters");
    }

    public AllocateNewDataSetWizardPage1(boolean isPDS) {
        super("allocateNewPDSDataSetWizardPage1");
        this.isPDS = isPDS;
        if (isPDS) {
            this.setTitle("Allocate New Partitioned Data Set (Page 1 of 2)");
        } else {
            this.setTitle("Allocate New Sequential Data Set (Page 1 of 2)");
        }
        this.setDescription("New data set allocation parameters");
    }

    public AllocateNewDataSetWizardPage1(boolean isPDS, String newDataSetName, boolean isAllocateNewParmPDSWizard, FileMasterServer server) {
        super(isPDS ? "allocateNewPDSDataSetWizardPage1" : "allocateNewSeqDataSetWizardPage1");
        this.newDataSetName = newDataSetName;
        this.isPDS = isPDS;
        this.isAllocateNewParmPDSWizard = isAllocateNewParmPDSWizard;
        if (isPDS) {
            this.setTitle("Allocate New Partitioned Data Set (Page 1 of 2)");
        } else {
            this.setTitle("Allocate New Sequential Data Set (Page 1 of 2)");
        }
        this.setDescription("New data set allocation parameters");
        this.server = server;
    }

    public AllocateNewDataSetWizardPage1(boolean isPDS, String newDataSetName, boolean isAllocateNewParmPDSWizard, FileMasterServer server, String modelDataSetName) {
        super(isPDS ? "allocateNewPDSDataSetWizardPage1" : "allocateNewSeqDataSetWizardPage1");
        this.newDataSetName = newDataSetName;
        this.isPDS = isPDS;
        this.isAllocateNewParmPDSWizard = isAllocateNewParmPDSWizard;
        if (isPDS) {
            this.setTitle("Allocate New Partitioned Data Set (Page 1 of 2)");
        } else {
            this.setTitle("Allocate New Sequential Data Set (Page 1 of 2)");
        }
        this.setDescription("New data set allocation parameters");
        this.server = server;
        this.modelDataSetName = modelDataSetName;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setSize(this.container.computeSize(-1, -1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite dataSetComposite = new Composite(this.container, 0);
        GridLayout gl_dataSetComposite = new GridLayout(2, false);
        gl_dataSetComposite.marginWidth = 0;
        gl_dataSetComposite.marginHeight = 0;
        dataSetComposite.setLayout((Layout)gl_dataSetComposite);
        dataSetComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label dataSetNameLabel = new Label(dataSetComposite, 0);
        dataSetNameLabel.setText("Ne&w data set name:");
        this.dataSetNameText = new Text(dataSetComposite, 8);
        GridData gd_clusterLabelData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.dataSetNameText.setLayoutData((Object)gd_clusterLabelData);
        this.dataSetNameText.setText(this.newDataSetName);
        Group modelDataSetGroup = new Group(this.container, 0);
        modelDataSetGroup.setLayout((Layout)new GridLayout(4, false));
        modelDataSetGroup.setSize(modelDataSetGroup.computeSize(-1, -1));
        modelDataSetGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        modelDataSetGroup.setText("Options");
        Label modelDataSetNameLabel = new Label((Composite)modelDataSetGroup, 0);
        modelDataSetNameLabel.setText("Model data set nam&e:");
        this.modelDataSetNameText = new Combo((Composite)modelDataSetGroup, 2048);
        this.modelDataSetNameText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.modelDataSetNameText, (int)35);
        this.modelDataSetNameText.addModifyListener((ModifyListener)this);
        this.modelDataSetNameText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.modelDataSetNameText, "modelDataSetNameList");
        this.modelDataSetNameText.setText(this.modelDataSetName);
        this.selectButton = new Button((Composite)modelDataSetGroup, 0);
        this.selectButton.setText("&Select...");
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetWizard wizard = new DatasetWizard(false, AllocateNewDataSetWizardPage1.this.modelDataSetNameText.getText(), "", AllocateNewDataSetWizardPage1.this.server.getName());
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        Button dsnListButton = new Button((Composite)modelDataSetGroup, 0);
        dsnListButton.setText("DSN &List...");
        dsnListButton.setVisible(false);
        dsnListButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AllocateNewDataSetWizardPage1.this.getDSNListPDS().isEmpty()) {
                    MessageDialog.openWarning((Shell)AllocateNewDataSetWizardPage1.this.getShell(), (String)"Warning", (String)"DSN Lists PDS in Prefernces is undefined. No DSNLists found");
                } else if (AllocateNewDataSetWizardPage1.this.modelDataSetNameText.getText().isEmpty() || Validator.dataset(AllocateNewDataSetWizardPage1.this.modelDataSetNameText.getText(), true) == 3) {
                    GenericImportWizard wizard = new GenericImportWizard("Select DSN List", AllocateNewDataSetWizardPage1.this.server, false);
                    TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                    dialog.open();
                } else {
                    DatasetWizard wizard = new DatasetWizard(false);
                    TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(AllocateNewDataSetWizardPage1.this.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        });
        this.confirmButton = new Button((Composite)modelDataSetGroup, 0);
        this.confirmButton.setText("&Confirm");
        this.confirmButton.setEnabled(false);
        new Label((Composite)modelDataSetGroup, 0);
        new Label((Composite)modelDataSetGroup, 0);
        new Label((Composite)modelDataSetGroup, 0);
        this.nextPage = (AllocateNewDataSetWizardPage2)this.getNextPage();
        this.confirmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewDataSetWizardPage1.this.setModelParameters(null);
            }
        });
        Group smsGroup = new Group(this.container, 0);
        smsGroup.setLayout((Layout)new GridLayout(2, false));
        smsGroup.setSize(smsGroup.computeSize(-1, -1));
        smsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        smsGroup.setText("SMS data set");
        this.managementClassLabel = new Label((Composite)smsGroup, 0);
        this.managementClassLabel.setText("&Management class:");
        this.managementClassText = new Text((Composite)smsGroup, 2048);
        this.managementClassText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.managementClassText.addModifyListener((ModifyListener)this);
        this.managementClassText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        TextUtil.setWidth((Text)this.managementClassText, (int)30);
        this.managementClassText.setTextLimit(8);
        this.storageClassLabel = new Label((Composite)smsGroup, 0);
        this.storageClassLabel.setText("St&orage class:");
        this.storageClassText = new Text((Composite)smsGroup, 2048);
        this.storageClassText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.storageClassText.addModifyListener((ModifyListener)this);
        this.storageClassText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        TextUtil.setWidth((Text)this.storageClassText, (int)30);
        this.storageClassText.setTextLimit(8);
        this.dataClassLabel = new Label((Composite)smsGroup, 0);
        this.dataClassLabel.setText("D&ata class:");
        this.dataClassText = new Text((Composite)smsGroup, 2048);
        this.dataClassText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.dataClassText.addModifyListener((ModifyListener)this);
        this.dataClassText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        TextUtil.setWidth((Text)this.dataClassText, (int)30);
        this.dataClassText.setTextLimit(8);
        this.useSmsCheck = new Button(this.container, 32);
        this.useSmsCheck.setText("&Use Non-SMS");
        Group nonSmsGroup = new Group(this.container, 0);
        nonSmsGroup.setLayout((Layout)new GridLayout(2, false));
        nonSmsGroup.setSize(nonSmsGroup.computeSize(-1, -1));
        nonSmsGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        nonSmsGroup.setText("Non-SMS data set");
        this.volumeSerialRadioButton = new Button((Composite)nonSmsGroup, 16);
        this.volumeSerialRadioButton.setEnabled(false);
        this.volumeSerialRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewDataSetWizardPage1.this.volumeSerialNonSmsText.setEnabled(true);
                AllocateNewDataSetWizardPage1.this.volumeSerialNonSmsText.setFocus();
                AllocateNewDataSetWizardPage1.this.genericUnitNameText.setEnabled(false);
                AllocateNewDataSetWizardPage1.this.setPageComplete(AllocateNewDataSetWizardPage1.this.isPageComplete());
            }
        });
        this.volumeSerialRadioButton.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                AllocateNewDataSetWizardPage1.this.volumeSerialNonSmsText.setFocus();
            }
        });
        this.volumeSerialRadioButton.setText("&Volume serial:");
        this.volumeSerialNonSmsText = new Text((Composite)nonSmsGroup, 2048);
        this.volumeSerialNonSmsText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.volumeSerialNonSmsText.setEnabled(false);
        this.volumeSerialNonSmsText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        TextUtil.setWidth((Text)this.volumeSerialNonSmsText, (int)28);
        this.volumeSerialNonSmsText.setTextLimit(6);
        this.volumeSerialNonSmsText.addModifyListener((ModifyListener)this);
        this.genericUnitNameRadioButton = new Button((Composite)nonSmsGroup, 16);
        this.genericUnitNameRadioButton.setEnabled(false);
        this.genericUnitNameRadioButton.setSelection(true);
        this.genericUnitNameRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllocateNewDataSetWizardPage1.this.genericUnitNameText.setEnabled(true);
                AllocateNewDataSetWizardPage1.this.genericUnitNameText.setFocus();
                AllocateNewDataSetWizardPage1.this.volumeSerialNonSmsText.setEnabled(false);
                AllocateNewDataSetWizardPage1.this.setPageComplete(AllocateNewDataSetWizardPage1.this.isPageComplete());
            }
        });
        this.genericUnitNameRadioButton.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                AllocateNewDataSetWizardPage1.this.genericUnitNameText.setFocus();
            }
        });
        this.genericUnitNameRadioButton.setText("&Generic unit name:");
        this.genericUnitNameText = new Text((Composite)nonSmsGroup, 2048);
        this.genericUnitNameText.setEnabled(false);
        this.genericUnitNameText.setText("SYSDA");
        this.genericUnitNameText.setTextLimit(6);
        this.genericUnitNameText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.genericUnitNameText.addModifyListener((ModifyListener)this);
        this.genericUnitNameText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        TextUtil.setWidth((Text)this.genericUnitNameText, (int)28);
        this.useSmsCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.getSource()).getSelection()) {
                    AllocateNewDataSetWizardPage1.this.managementClassText.setEnabled(true);
                    AllocateNewDataSetWizardPage1.this.storageClassText.setEnabled(true);
                    AllocateNewDataSetWizardPage1.this.dataClassText.setEnabled(true);
                    AllocateNewDataSetWizardPage1.this.managementClassLabel.setEnabled(true);
                    AllocateNewDataSetWizardPage1.this.storageClassLabel.setEnabled(true);
                    AllocateNewDataSetWizardPage1.this.dataClassLabel.setEnabled(true);
                    AllocateNewDataSetWizardPage1.this.volumeSerialRadioButton.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.genericUnitNameRadioButton.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.volumeSerialNonSmsText.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.genericUnitNameText.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.setPageComplete(AllocateNewDataSetWizardPage1.this.isPageComplete());
                } else {
                    AllocateNewDataSetWizardPage1.this.managementClassText.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.storageClassText.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.dataClassText.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.managementClassLabel.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.storageClassLabel.setEnabled(false);
                    AllocateNewDataSetWizardPage1.this.dataClassLabel.setEnabled(false);
                    if (AllocateNewDataSetWizardPage1.this.genericUnitNameRadioButton.getSelection()) {
                        AllocateNewDataSetWizardPage1.this.genericUnitNameRadioButton.setEnabled(true);
                        AllocateNewDataSetWizardPage1.this.genericUnitNameText.setEnabled(true);
                        AllocateNewDataSetWizardPage1.this.volumeSerialRadioButton.setEnabled(true);
                    } else {
                        AllocateNewDataSetWizardPage1.this.volumeSerialRadioButton.setEnabled(true);
                        AllocateNewDataSetWizardPage1.this.volumeSerialNonSmsText.setEnabled(true);
                        AllocateNewDataSetWizardPage1.this.genericUnitNameRadioButton.setEnabled(true);
                    }
                    AllocateNewDataSetWizardPage1.this.setPageComplete(AllocateNewDataSetWizardPage1.this.isPageComplete());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dirListInsert = new Button(this.container, 32);
        this.dirListInsert.setText("Add to Director&y List view");
        if (this.isPDS) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.allocateNewDataSetWizardPageOne");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.allocateNewDataSetSEQPageOne");
        }
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public boolean useNumberOfVolumes() {
        return !this.useSmsCheck.getSelection() | (this.useSmsCheck.getSelection() && this.genericUnitNameText.getEnabled());
    }

    private String getDSNListPDS() {
        ScopedPreferenceStore store = null;
        if (store == null) {
            store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
        }
        String DSNListPDS = store.getString("DSNLISTSPDS_VALUE");
        return DSNListPDS;
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.error = new String();
        if (this.dataSetNameText != null && this.volumeSerialNonSmsText != null && this.volumeSerialRadioButton != null && this.modelDataSetNameText != null && this.selectButton != null && this.confirmButton != null) {
            this.confirmButton.setEnabled(false);
            switch (Validator.dataset(this.dataSetNameText.getText(), true)) {
                case 3: {
                    this.error = String.valueOf(this.error) + "Wildcard is not allowed in new data set name\n ";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.dataSetNameText.getText(), true)] + "\n ";
                }
            }
            switch (Validator.volume(this.volumeSerialNonSmsText.getText(), true)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.volumeSerialNonSmsText.getText(), true)] + "\n ";
                    break;
                }
                case 8: {
                    if (!this.useSmsCheck.getSelection() || !this.volumeSerialRadioButton.getSelection()) break;
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume(this.volumeSerialNonSmsText.getText(), true)] + "\n ";
                }
            }
            switch (Validator.dataset(this.modelDataSetNameText.getText(), true)) {
                case 3: {
                    this.selectButton.setEnabled(true);
                    break;
                }
                case 2: {
                    this.error = String.valueOf(this.error) + "Model data set name has invalid format\n ";
                    this.selectButton.setEnabled(false);
                    break;
                }
                case 4: {
                    this.error = String.valueOf(this.error) + "Model data set name is too long\n ";
                    this.selectButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.confirmButton.setEnabled(false);
                    this.selectButton.setEnabled(false);
                    break;
                }
                case 0: {
                    this.selectButton.setEnabled(false);
                    this.confirmButton.setEnabled(true);
                }
            }
            switch (Validator.member(this.managementClassText.getText(), false)) {
                case 7: {
                    this.error = String.valueOf(this.error) + "SMS Management Class has invalid format\n ";
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + "SMS Management Class has invalid format\n ";
                }
            }
            switch (Validator.member(this.storageClassText.getText(), false)) {
                case 7: {
                    this.error = String.valueOf(this.error) + "SMS Storage Class has invalid format\n ";
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + "SMS Storage Class has invalid format\n ";
                }
            }
            switch (Validator.member(this.dataClassText.getText(), false)) {
                case 7: {
                    this.error = String.valueOf(this.error) + "SMS Data Class has invalid format\n ";
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + "SMS Data Class has invalid format\n ";
                }
            }
            if (this.useSmsCheck.getSelection() && this.genericUnitNameRadioButton.getSelection() && this.genericUnitNameText.getText().trim().length() == 0) {
                this.error = String.valueOf(this.error) + "Generic unit name missing\n ";
            }
            if (this.error.length() > 0) {
                this.setErrorMessage(this.error);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        if (this.isAllocateNewParmPDSWizard) {
            ((AllocateNewParmPDSWizard)this.getWizard()).addPage((IWizardPage)new AllocateNewDataSetWizardPage2(this.isPDS, this.modelDataSetNameText, this.newDataSetName));
            this.setModelPage2();
            return ((AllocateNewParmPDSWizard)this.getWizard()).getPage("allocateNewPDSDataSetWizardPage2");
        }
        if (this.getWizard() instanceof AllocateNewDataSetWizard) {
            ((AllocateNewDataSetWizard)this.getWizard()).addPage((IWizardPage)new AllocateNewDataSetWizardPage2(this.isPDS, this.modelDataSetNameText, this.newDataSetName));
            this.setModelPage2();
            return ((AllocateNewDataSetWizard)this.getWizard()).getPage(this.isPDS ? "allocateNewPDSDataSetWizardPage2" : "allocateNewSeqDataSetWizardPage2");
        }
        ((AllocateDatasetWizard)this.getWizard()).addPage((IWizardPage)new AllocateNewDataSetWizardPage2(this.isPDS, this.modelDataSetNameText, this.newDataSetName));
        this.setModelPage2();
        return ((AllocateDatasetWizard)this.getWizard()).getPage(this.isPDS ? "allocateNewPDSDataSetWizardPage2" : "allocateNewSeqDataSetWizardPage2");
    }

    private void setModelPage2() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.container.setFocus();
    }

    public void insertDSNToField(String value) {
        this.modelDataSetNameText.setText(value);
    }

    public Button getDirListInsert() {
        return this.dirListInsert;
    }

    public void insertIntoDirecotryList() {
        FileMasterDataset fmdataset = new FileMasterDataset(null);
        fmdataset.setName(this.newDataSetName);
        fmdataset.setDsOrg(this.isPDS ? "PDS" : "Sequential");
        int index = 0;
        int i = 0;
        while (i < this.model.getServers().length) {
            if (this.model.getServers()[i].getName().equals(this.server.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        if (this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]) == null) {
            Element dsElement = this.model.addDataset(this.server.getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
            this.model.insertDataset(this.model.getServers()[index], dsElement);
            this.model.save();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            DirectoryListView DirectoryView = (DirectoryListView)page.findView("com.ca.filemaster.views.directorylist");
            TreeViewer viewer = DirectoryView.getViewer();
            viewer.refresh();
            viewer.setSelection((ISelection)new StructuredSelection(), true);
        }
        catch (Exception exception) {}
    }

    public FileMasterServer getServer() {
        return this.server;
    }

    public String getNewDataSetName() {
        return this.newDataSetName;
    }

    public String getModelDataSetName() {
        return this.modelDataSetNameText.getText();
    }

    public String getManagementClass() {
        return this.managementClassText.getText();
    }

    public String getStorageClass() {
        return this.storageClassText.getText();
    }

    public String getDataClass() {
        return this.dataClassText.getText();
    }

    public String getGenericUnitName() {
        return this.genericUnitNameText.getText();
    }

    public boolean getUseNonSMS() {
        return this.useSmsCheck.getSelection();
    }

    public boolean getUseVolumeSerial() {
        return this.volumeSerialRadioButton.getSelection();
    }

    public String getVolumeSerial() {
        return this.volumeSerialNonSmsText.getText();
    }

    public void setVolumeSerial(String volume) {
        this.volumeSerialNonSmsText.setText(volume);
    }

    public Combo getModelDataSetNameText() {
        return this.modelDataSetNameText;
    }

    public void updateDataSet(String dataSet) {
        this.newDataSetName = dataSet;
        if (this.dataSetNameText != null) {
            this.dataSetNameText.setText(this.newDataSetName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setModelParameters(FileMasterDataset model) {
        if (model == null) {
            FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(this.modelDataSetNameText.getText(), "", this.server);
            if (!CommonMFCalls.RETURN_CODE.equals("0")) return;
            this.modelDataset = FMDataSet;
        } else {
            this.modelDataset = model;
        }
        if (this.modelDataset.getVolume().equalsIgnoreCase("ARCIVE")) {
            TT_ErrorDialog.openError(null, (String)"Error", (String)"Archived data set");
            return;
        } else if (this.isPDS && (this.modelDataset.getDsType().equalsIgnoreCase("P") || this.modelDataset.getDsType().equalsIgnoreCase("X") || this.modelDataset.getDsType().equalsIgnoreCase("L")) || !this.isPDS && this.modelDataset.getDsType().equalsIgnoreCase("S")) {
            this.managementClassText.setText(this.modelDataset.getSmsManagement());
            this.storageClassText.setText(this.modelDataset.getSmsStorage());
            this.dataClassText.setText(this.modelDataset.getSmsData());
            this.volumeSerialNonSmsText.setText(this.modelDataset.getVolume());
            this.genericUnitNameText.setText(this.modelDataset.getUnitType());
            if (this.modelDataset.isSMSdataset()) {
                this.useSmsCheck.setSelection(false);
                this.managementClassLabel.setEnabled(true);
                this.storageClassLabel.setEnabled(true);
                this.dataClassLabel.setEnabled(true);
                this.managementClassText.setEnabled(true);
                this.storageClassText.setEnabled(true);
                this.dataClassText.setEnabled(true);
                this.volumeSerialRadioButton.setEnabled(false);
                this.genericUnitNameRadioButton.setEnabled(false);
                this.volumeSerialNonSmsText.setEnabled(false);
                this.genericUnitNameText.setEnabled(false);
            } else {
                this.useSmsCheck.setSelection(true);
                this.volumeSerialRadioButton.setSelection(true);
                this.genericUnitNameRadioButton.setSelection(false);
                this.managementClassLabel.setEnabled(false);
                this.storageClassLabel.setEnabled(false);
                this.dataClassLabel.setEnabled(false);
                this.managementClassText.setEnabled(false);
                this.storageClassText.setEnabled(false);
                this.dataClassText.setEnabled(false);
                this.volumeSerialRadioButton.setEnabled(true);
                this.genericUnitNameRadioButton.setEnabled(true);
                this.volumeSerialNonSmsText.setEnabled(true);
                this.genericUnitNameText.setEnabled(false);
            }
            this.nextPage.setModelParameters(this.modelDataset);
            return;
        } else {
            TT_ErrorDialog.openError(null, (String)"Error", (String)"Invalid model data set", (Throwable)new Throwable("Model data set and new data set must have the same file type."));
        }
    }
}

