/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.GenericSelectionCriteriaBox;
import com.ca.filemaster.common.GenericUpdate2Page;
import com.ca.filemaster.ui.wizards.SelFieldNameWizard;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SelWithLayoutPage
extends GenericUpdate2Page
implements SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.selCritRules";
    private String layoutInfo = "";
    private String[] SelConds;
    private static String newCondition = "";
    public static Button saveSelCrit;
    private GenericSelectionCriteriaBox genericSelCrit;
    private int[] map;
    private FileMasterServer server;

    public SelWithLayoutPage(String pageName, String title, CRLClass crl, int selectedIndex, FileMasterServer server, String layoutInfo, String[] SelConds, GenericSelectionCriteriaBox genericSelCrit) {
        super(pageName, title, crl, selectedIndex, server, false);
        this.layoutInfo = layoutInfo;
        this.SelConds = SelConds;
        this.genericSelCrit = genericSelCrit;
        this.map = new int[SelConds.length];
        int i = 0;
        while (i < this.map.length) {
            this.map[i] = -1;
            ++i;
        }
        this.server = server;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.selCritRules");
        this.txtRecLayout.setText(this.layoutInfo);
        this.tableUpdateFromSel();
        saveSelCrit = new Button(parent, 0);
        saveSelCrit.setEnabled(false);
    }

    private void tableUpdateFromSel() {
        CRLClass crl = new CRLClass();
        crl.addLayout("toBeDel", "toBeDel");
        int indexOfField = -1;
        Object[] treeItems = this.getTreeItems(this.treeViewer.getTree().getItems());
        int count = 0;
        while (count < treeItems.length) {
            String fieldName = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getField();
            int level = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getLevel();
            boolean isTop = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).isTop();
            boolean selected = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).isSelected();
            int position = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getPosition();
            String formatType = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getFormatType();
            int formatNum = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getFormatNum();
            int formatDec = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getFormatDec();
            int length = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getLength();
            int logOperator = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getLogOperator();
            int operator = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getOperator();
            String value = ((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getValue();
            crl.getLayout(0).addField(fieldName, level, isTop, selected, position, formatType, formatNum, formatDec, length, logOperator, operator, value);
            ++count;
        }
        count = 0;
        while (count < this.SelConds.length) {
            String selCondLine = this.SelConds[count];
            String[] splitByOperator = selCondLine.split(" GT | gt | Gt | gT | > | GE | ge | Ge | gE | >= | EQ | eq | Eq | eQ | = | NE | ne | Ne | nE | <> | LT | lt | Lt | lT | < | LE | le | Le | lE | <= | CO | co | Co | cO ", 2);
            if (splitByOperator.length > 1) {
                String namePart = splitByOperator[0].trim();
                String valuePart = splitByOperator[1].trim();
                String parsedLogOperator = "";
                String[] namePartSplitBySpace = namePart.split("\\s+");
                if (this.isLogicalOperator(namePartSplitBySpace[0])) {
                    parsedLogOperator = namePartSplitBySpace[0];
                    namePart = namePart.substring(namePartSplitBySpace[0].length()).trim();
                } else if (count > 0) {
                    String[] previousLine = this.SelConds[count - 1].split("\\s+");
                    parsedLogOperator = previousLine[previousLine.length - 1];
                }
                indexOfField = this.isLayoutField(namePart);
                if (indexOfField > -1) {
                    selCondLine = selCondLine.substring(0, selCondLine.length() - valuePart.length() - 1);
                    String[] splitBySpace = selCondLine.split("\\s+");
                    int operator = this.getOperator(splitBySpace[splitBySpace.length - 1]);
                    int logOperator = parsedLogOperator.equalsIgnoreCase("AND") || parsedLogOperator.equalsIgnoreCase("&") ? 2 : (parsedLogOperator.equalsIgnoreCase("OR") || parsedLogOperator.equalsIgnoreCase("|") ? 1 : 2);
                    String[] valuePartSplitBySpace = valuePart.split("\\s+");
                    String lastPart = valuePartSplitBySpace[valuePartSplitBySpace.length - 1];
                    if (this.isLogicalOperator(lastPart)) {
                        valuePart = valuePart.substring(0, valuePart.length() - lastPart.length() - 1).trim();
                    }
                    if (operator != 0 && valuePart.length() > 0) {
                        this.mapCondition(count, indexOfField);
                        crl.getLayout(0).getLayoutField(indexOfField).setOperator(operator);
                        crl.getLayout(0).getLayoutField(indexOfField).setValue(valuePart);
                        if (count > 0) {
                            crl.getLayout(0).getLayoutField(indexOfField).setLogOperator(logOperator);
                        }
                    }
                }
            }
            ++count;
        }
        this.fields = crl.getLayout(0).getLayoutFields();
        this.treeViewer.setInput((Object)this.fields.toArray(new Object[this.fields.size()]));
        this.treeViewer.refresh();
        this.treeViewer.expandToLevel(-1);
    }

    private int isLayoutField(String layoutField) {
        Object[] treeItems = this.getTreeItems(this.treeViewer.getTree().getItems());
        int count = 0;
        while (count < treeItems.length) {
            if (((CRLClass.LayoutField)((TreeItem)treeItems[count]).getData()).getField().equalsIgnoreCase(layoutField)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    @Override
    public void createMenuItem(Menu menu, String text) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(text);
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String value = ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).getValue();
                if (((MenuItem)event.widget).getText().equals("Field Name...")) {
                    CRLClass.LayoutField selectedLayoutField = (CRLClass.LayoutField)SelWithLayoutPage.this.treeViewer.getTree().getSelection()[0].getData();
                    SelWithLayoutPage.this.dialog = new TestingToolsWizardDialog(SelWithLayoutPage.this.getShell(), (IWizard)new SelFieldNameWizard(SelWithLayoutPage.this.crl.getLayout(SelWithLayoutPage.this.selectedIndex).getLayoutDataset(), SelWithLayoutPage.this.crl.getLayout(SelWithLayoutPage.this.selectedIndex).getLayoutMember(), true, SelWithLayoutPage.this.server, selectedLayoutField));
                    SelWithLayoutPage.this.dialog.create();
                    SelWithLayoutPage.this.dialog.open();
                } else if (!value.matches("([CTXPBN]*\\d*['\"]?[0-9A-Za-z]*['\"]?\\s*)*")) {
                    value = "";
                }
                if (((MenuItem)event.widget).getText().equals("C - Character")) {
                    ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).setValue(String.valueOf(value) + " C'' ");
                } else if (((MenuItem)event.widget).getText().equals("T - Text")) {
                    ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).setValue(String.valueOf(value) + " T'' ");
                } else if (((MenuItem)event.widget).getText().equals("X - Hex")) {
                    ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).setValue(String.valueOf(value) + " X'' ");
                } else if (((MenuItem)event.widget).getText().equals("P - Packed")) {
                    ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).setValue(String.valueOf(value) + " P'' ");
                } else if (((MenuItem)event.widget).getText().equals("B - Binary")) {
                    ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).setValue(String.valueOf(value) + " B'' ");
                } else if (((MenuItem)event.widget).getText().equals("N - Numeric")) {
                    ((CRLClass.LayoutField)SelWithLayoutPage.this.fields.get(SelWithLayoutPage.this.lineNumber)).setValue(String.valueOf(value) + " N'' ");
                }
                SelWithLayoutPage.this.treeViewer.refresh();
            }
        });
    }

    @Override
    public boolean doFinish() {
        newCondition = "";
        String logicalOperator = "";
        Object[] treeItems = this.getTreeItems(this.treeViewer.getTree().getItems());
        int i = 0;
        while (i < treeItems.length) {
            if (((TreeItem)treeItems[i]).getData() != null && !((CRLClass.LayoutField)((TreeItem)treeItems[i]).getData()).getValue().trim().isEmpty() && !this.isMappedCondition(i)) {
                if (!newCondition.isEmpty()) {
                    newCondition = String.valueOf(newCondition) + " " + this.getLogOperator(((CRLClass.LayoutField)((TreeItem)treeItems[i]).getData()).getLogOperator()) + "\r\n";
                }
                String value = ((CRLClass.LayoutField)((TreeItem)treeItems[i]).getData()).getValue();
                String type = ((CRLClass.LayoutField)((TreeItem)treeItems[i]).getData()).getFormatType();
                newCondition = String.valueOf(newCondition) + ((CRLClass.LayoutField)((TreeItem)treeItems[i]).getData()).getField() + " " + this.getOperator(((CRLClass.LayoutField)((TreeItem)treeItems[i]).getData()).getOperator()) + " " + this.checkQualifier(value, type);
            }
            ++i;
        }
        i = 0;
        while (i < this.map.length) {
            if (this.map[i] > -1 && ((TreeItem)treeItems[this.map[i]]).getData() != null) {
                if (!((CRLClass.LayoutField)((TreeItem)treeItems[this.map[i]]).getData()).getValue().trim().isEmpty()) {
                    if (i > 0) {
                        newCondition = String.valueOf(newCondition) + " " + this.getLogOperator(((CRLClass.LayoutField)((TreeItem)treeItems[this.map[i]]).getData()).getLogOperator()) + "\r\n";
                    }
                    if (!this.isLogicalOperator(logicalOperator = this.SelConds[i].split("\\s+")[this.SelConds[i].split("\\s+").length - 1].toUpperCase())) {
                        logicalOperator = "";
                    }
                    String type = ((CRLClass.LayoutField)((TreeItem)treeItems[this.map[i]]).getData()).getFormatType();
                    String value = ((CRLClass.LayoutField)((TreeItem)treeItems[this.map[i]]).getData()).getValue();
                    newCondition = String.valueOf(newCondition) + ((CRLClass.LayoutField)((TreeItem)treeItems[this.map[i]]).getData()).getField() + " " + this.getUpdatedOperator(this.SelConds[i], this.getOperator(((CRLClass.LayoutField)((TreeItem)treeItems[this.map[i]]).getData()).getOperator())) + " " + this.checkQualifier(value, type);
                }
            } else {
                if (i > 0) {
                    newCondition = String.valueOf(newCondition) + " " + logicalOperator + "\r\n";
                }
                newCondition = this.isLogicalOperator(logicalOperator = this.SelConds[i].split("\\s+")[this.SelConds[i].split("\\s+").length - 1].toUpperCase()) ? String.valueOf(newCondition) + this.SelConds[i].substring(0, this.SelConds[i].length() - logicalOperator.length()).trim() : String.valueOf(newCondition) + this.SelConds[i].trim();
            }
            ++i;
        }
        this.genericSelCrit.setText(newCondition);
        saveSelCrit.notifyListeners(13, new Event());
        return true;
    }

    private String checkQualifier(String value, String type) {
        if ((value = value.trim()).matches("['\"][+-]?[0-9]*\\.?[0-9]*['\"]")) {
            if (type.matches("PS?")) {
                return "P" + value;
            }
            if (type.matches("[BN]S?")) {
                return "N" + value;
            }
        } else if (value.matches("[+-]?[0-9]*\\.?[0-9]*")) {
            if (type.matches("PS?")) {
                return "P'" + value + "'";
            }
            if (type.matches("[BN]S?")) {
                return "N'" + value + "'";
            }
        } else if (value.matches("['\"][\\x20-\\x7E]*['\"]")) {
            return "T" + value;
        }
        return value;
    }

    private boolean isMappedCondition(int index) {
        int i = 0;
        while (i < this.map.length) {
            if (this.map[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void mapCondition(int indexInConditions, int indexInTree) {
        int i = 0;
        while (i < indexInConditions) {
            if (this.map[i] == indexInTree) {
                this.map[i] = -1;
            }
            ++i;
        }
        this.map[indexInConditions] = indexInTree;
    }

    private boolean isLogicalOperator(String string) {
        return string.equalsIgnoreCase("AND") || string.equalsIgnoreCase("OR") || string.equalsIgnoreCase("&") || string.equalsIgnoreCase("|");
    }

    private String getUpdatedOperator(String string, String operator) {
        String oldOperator = string.split("\\s+")[1].trim();
        if (oldOperator.equals("=") || oldOperator.equals("<>") || oldOperator.equals("<") || oldOperator.equals(">") || oldOperator.equals("<=") || oldOperator.equals(">=")) {
            return this.getUpdatedOperator(operator);
        }
        return operator;
    }

    private String getUpdatedOperator(String operator) {
        if (operator.equals("GT")) {
            return ">";
        }
        if (operator.equals("GE")) {
            return ">=";
        }
        if (operator.equals("EQ")) {
            return "=";
        }
        if (operator.equals("NE")) {
            return "<>";
        }
        if (operator.equals("LT")) {
            return "<";
        }
        if (operator.equals("LE")) {
            return "<=";
        }
        if (operator.equals("CO")) {
            return "CO";
        }
        return null;
    }

    private String getOperator(int operator) {
        switch (operator) {
            case 3: {
                return "GT";
            }
            case 5: {
                return "GE";
            }
            case 1: {
                return "EQ";
            }
            case 2: {
                return "NE";
            }
            case 4: {
                return "LT";
            }
            case 6: {
                return "LE";
            }
            case 7: {
                return "CO";
            }
        }
        return "";
    }

    private int getOperator(String operator) {
        if ((operator = operator.trim().toUpperCase()).equalsIgnoreCase("EQ") || operator.equalsIgnoreCase("=")) {
            return 1;
        }
        if (operator.equalsIgnoreCase("NE") || operator.equalsIgnoreCase("<>")) {
            return 2;
        }
        if (operator.equalsIgnoreCase("LE") || operator.equalsIgnoreCase("<=")) {
            return 6;
        }
        if (operator.equalsIgnoreCase("GE") || operator.equalsIgnoreCase(">=")) {
            return 5;
        }
        if (operator.equalsIgnoreCase("LT") || operator.equalsIgnoreCase("<")) {
            return 4;
        }
        if (operator.equalsIgnoreCase("GT") || operator.equalsIgnoreCase(">")) {
            return 3;
        }
        if (operator.equalsIgnoreCase("CO")) {
            return 7;
        }
        return 0;
    }

    private String getLogOperator(int logOperator) {
        switch (logOperator) {
            case 2: {
                return "AND";
            }
            case 1: {
                return "OR";
            }
        }
        return "AND";
    }

    public static String getNewCondition() {
        return newCondition;
    }
}

