/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.Activator;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.GenericLayoutBox;
import com.ca.filemaster.common.GenericSelectionCriteriaBox;
import com.ca.filemaster.runners.RunGetWCMEM;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.LayoutMemberWizardPage;
import com.ca.filemaster.ui.wizards.MemberWizardPage;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MemberWizardOptionsPage
extends WizardPage {
    public static final int LAYOUT_VIEW = 1;
    public static final int DATA_SET_NAME = 2;
    private GenericLayoutBox genLayout;
    private GenericSelectionCriteriaBox genCriteria;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.memberWizard";
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private FileMasterMember member;
    private static XMLRequest xml;
    public static ScopedPreferenceStore store;

    static {
        store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
    }

    public MemberWizardOptionsPage(FileMasterServer server, FileMasterDataset dataSet, FileMasterMember member) {
        super("wizardOptionsPage");
        this.setTitle("Select Member Options");
        this.genLayout = new GenericLayoutBox(server.getName(), (Object)this, store.getString("LAYDSN"), store.getString("LAYMEM"), "");
        this.genCriteria = new GenericSelectionCriteriaBox(server.getName(), (Object)this, this.genLayout, true, "", "");
        this.server = server;
        this.dataSet = dataSet;
        this.member = member;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.memberWizard");
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(16384, 128, true, true, 1, 1));
        this.genLayout.createLayoutBox(container, "");
        this.genCriteria.createConditionBox(container);
        this.genCriteria.selConditionGroup.setText("Member selection criteria");
        this.genCriteria.setText(store.getString("SELMEMCRIT"));
        this.getShell().getDefaultButton().setText("OK");
        this.setControl((Control)container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    public boolean isPageComplete() {
        String error = "";
        error = this.genLayout.validateLayoutBox();
        error = String.valueOf(error) + this.genCriteria.validateCriteriaBox();
        if (this.genLayout.isLayoutSet()) {
            this.genCriteria.setLayoutButtonEnabled(true);
        } else {
            this.genCriteria.setLayoutButtonEnabled(false);
        }
        if (error.length() > 0) {
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean doFinish() {
        ArrayList<String> selCrit = new ArrayList<String>();
        if (!this.getSelectionCriteria().trim().isEmpty()) {
            selCrit.add(0, this.getSelectionCriteria());
        }
        String layoutdsn = "";
        String layoutmem = "";
        String layout = this.genLayout.getLayoutViewComboString();
        String string = layout = layout.equals("(none)") ? "" : layout;
        if (this.getLayoutToUse() == 1 && !layout.isEmpty()) {
            int left = layout.indexOf("(");
            int right = layout.indexOf(")");
            layoutdsn = layout.substring(0, left);
            layoutmem = layout.substring(left + 1, right);
        } else {
            layoutdsn = this.getLayoutDataSet();
            layoutmem = this.getLayoutMember();
        }
        RunGetWCMEM runner = new RunGetWCMEM(this.dataSet, this.server, this.member, true, "S", selCrit, layoutdsn, layoutmem);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        xml = runner.getXml();
        IWizardPage parent = ((WizardDialog)this.getShell().getParent().getData()).getCurrentPage();
        if (parent instanceof MemberWizardPage) {
            ((MemberWizardPage)parent).xmlRun(xml);
        } else if (parent instanceof LayoutMemberWizardPage) {
            ((LayoutMemberWizardPage)parent).xmlRun(xml);
        }
        this.genLayout.updateHistory();
        store.setValue("SELMEMCRIT", this.genCriteria.getText());
        store.setValue("LAYDSN", layoutdsn);
        store.setValue("LAYMEM", layoutmem);
        ImportSelCritWizardPage.conditions = "";
        return true;
    }

    public static XMLRequest getXML() {
        return xml;
    }

    public String getLayoutView() {
        if (this.genLayout == null) {
            return "none";
        }
        return this.genLayout.getLayoutViewComboString();
    }

    public String getLayoutDataSet() {
        if (this.genLayout == null) {
            return "";
        }
        return this.genLayout.getLayoutDataSetName();
    }

    public String getLayoutMember() {
        if (this.genLayout == null) {
            return "";
        }
        return this.genLayout.getLayoutMemberName();
    }

    public String getSelectionCriteria() {
        if (this.genCriteria == null) {
            return "";
        }
        return this.genCriteria.getSelCriteriaBoxText();
    }

    public int getLayoutToUse() {
        if (this.genLayout == null) {
            return 1;
        }
        if (this.genLayout.isLayoutViewSelected()) {
            return 1;
        }
        return 2;
    }

    public void insertDSNToField(String value) {
        this.genLayout.layoutDataSetCombo.setText(value);
    }
}

