/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.ui.wizards.FilesDatasetWizardPage;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class FilesDatasetWizard
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private FileMasterServer server = null;
    private FileMasterDataset dataset = null;
    private FilesDatasetWizardPage page;
    private boolean newItem = true;
    private static final FMServerTreeModel model = FMServerTreeModel.getInstance();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TT_TreeItem datasetItem;
        Object object = selection.getFirstElement();
        TT_TreeItem treeItem = model.findObject(object);
        if (treeItem != null && (datasetItem = treeItem.getParent(Profile.class)) != null) {
            treeItem = datasetItem;
        }
        if (treeItem != null) {
            FileMasterDataset value = (FileMasterDataset)((Object)treeItem.getAdapter(Dataset.class));
            if (value != null) {
                this.dataset = value;
                this.server = (FileMasterServer)treeItem.getServer();
            } else if (treeItem.getAdapter(FileMasterServer.class) != null) {
                this.server = (FileMasterServer)treeItem.getValue();
            }
        }
        if (treeItem == null) {
            TT_TreeItem[] AllServerItem;
            TT_TreeItem[] tT_TreeItemArray = AllServerItem = model.getServers();
            int n = AllServerItem.length;
            int n2 = 0;
            while (n2 < n) {
                TT_TreeItem item = tT_TreeItemArray[n2];
                String serverStatus = item.getServer().getStatusText();
                if (serverStatus == "Active") {
                    this.server = (FileMasterServer)item.getServer();
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean performFinish() {
        return this.page.doFinish();
    }

    public void addPages() {
        String title = this.newItem ? "Select Data Set" : String.format("Update %s", this.dataset.toString());
        this.page = new FilesDatasetWizardPage(this.dataset, this.server, this.newItem, title);
        this.addPage((IWizardPage)this.page);
    }

    public void setNewItem(boolean newItem) {
        this.newItem = newItem;
        if (newItem) {
            this.dataset = null;
            this.setWindowTitle("Select Data Set");
        } else {
            this.setWindowTitle("Update Data Set Definition");
        }
    }

    public boolean isNewItem() {
        return this.newItem;
    }
}

