/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunValidateSelCriteria
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private boolean canRetry = true;
    private String command;
    private String uuid;
    private static final String SERVICE = "filemaster/fmp";
    private String layoutDataSet;
    private String layoutMember;
    private String selectionCriteria;

    public RunValidateSelCriteria(FileMasterServer server, FileMasterDataset layoutDataset, FileMasterMember layoutMember, String selectionCriteria) {
        this.server = server;
        this.layoutDataSet = layoutDataset.getName();
        this.layoutMember = layoutMember.getName();
        this.selectionCriteria = selectionCriteria;
    }

    public RunValidateSelCriteria(FileMasterServer server, String layoutDataset, String layoutMember, String selectionCriteria) {
        this.server = server;
        this.layoutDataSet = layoutDataset;
        this.layoutMember = layoutMember;
        this.selectionCriteria = selectionCriteria;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            this.uuid = FileMasterSession.getUUID(this.server, true);
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            if (this.selectionCriteria.split("\n").length > 250) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Selection Criteria Validation Error", (Throwable)new Throwable("Total number of selection criteria should be less than 251."));
            } else {
                this.xml = connection.connect("selcrit", map, false, this.createSelCriteriaXML());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createSelCriteriaXML() {
        String[] selCriteriaLines;
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<ValidateSelection>";
        if (!this.layoutDataSet.isEmpty()) {
            this.command = String.valueOf(this.command) + "<Layout><DataSetName>" + this.layoutDataSet + "</DataSetName>" + "<MemberName>" + this.layoutMember + "</MemberName>" + "</Layout>";
        }
        if ((selCriteriaLines = this.selectionCriteria.split("\r\n")).length > 0) {
            this.command = String.valueOf(this.command) + "<SelectionInput>";
            int count = 0;
            while (count < selCriteriaLines.length) {
                selCriteriaLines[count] = selCriteriaLines[count].trim();
                if (selCriteriaLines[count].isEmpty()) {
                    this.command = String.valueOf(this.command) + "<DynamicSelCritLine> </DynamicSelCritLine>";
                } else {
                    selCriteriaLines[count] = selCriteriaLines[count].replace("&", "&amp;");
                    selCriteriaLines[count] = selCriteriaLines[count].replace(">", "&gt;");
                    selCriteriaLines[count] = selCriteriaLines[count].replace("<", "&lt;");
                    selCriteriaLines[count] = selCriteriaLines[count].replace("\"", "&quot;");
                    selCriteriaLines[count] = selCriteriaLines[count].replace("'", "&apos;");
                    this.command = String.valueOf(this.command) + "<DynamicSelCritLine>" + selCriteriaLines[count] + "</DynamicSelCritLine>";
                }
                ++count;
            }
            this.command = String.valueOf(this.command) + "</SelectionInput>";
        } else {
            this.command = String.valueOf(this.command) + "<SelectionInput>";
            this.command = String.valueOf(this.command) + "<DynamicSelCritLine> </DynamicSelCritLine>";
            this.command = String.valueOf(this.command) + "</SelectionInput>";
        }
        this.command = String.valueOf(this.command) + "</ValidateSelection></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

