/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunSave
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String SERVICE = "filemaster/fmp";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String displayMode;
    private String uuid;
    private String hexMode = "N";
    private boolean canRetry = true;
    private String YorNType = "Y";

    public RunSave(FileMasterServer server, String uuid, String SaveorNo, String mode, String hexOn) {
        this.YorNType = SaveorNo;
        this.displayMode = mode;
        this.server = server;
        this.hexMode = hexOn;
        this.uuid = uuid;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = connection.connect("reset", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                Element reqElement = this.xml.getRoot();
                if (reqElement != null && (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16"))) {
                    if (this.canRetry) {
                        this.canRetry = false;
                        FileMasterSession.removeSession(this.server, this.uuid);
                        this.run();
                    }
                    FileMasterSession.removeSession(this.server, this.uuid);
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    private XMLDocument createXml() {
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = String.valueOf(command) + "<Save endEdit=\"" + this.YorNType + "\">";
        command = String.valueOf(command) + "</Save></Edit></GUIRequest>";
        return CommonMFCalls.createXMLDoc(command);
    }

    public XMLRequest getXml() {
        return this.xml;
    }
}

