/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.ui.wizards.RenameFileVariable;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunRenameFile
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private static final String SERVICE = "filemaster/fmp";
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String command;
    private String uuid;
    File file;
    private boolean canRetry = true;
    private RenameFileVariable rename = new RenameFileVariable();

    public RunRenameFile(FileMasterServer serverName, RenameFileVariable renameFileVariable) {
        this.server = serverName;
        this.rename = renameFileVariable;
    }

    @Override
    public void run() {
        block9: {
            ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                long t1;
                this.uuid = FileMasterSession.getUUID(this.server, true);
                if (this.uuid == null) break block9;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                if (this.uuid != null && !this.uuid.isEmpty()) {
                    this.xml = connection.connect("Find", map, false, this.createXml());
                    if (this.xml.getAttachedFile() != null) {
                        File file = this.xml.getAttachedFile();
                        FileInputStream is = new FileInputStream(file);
                        this.xml = new XMLRequest((InputStream)is);
                    } else {
                        Element reqElement = this.xml.getRoot();
                        if (reqElement != null && (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16"))) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                    }
                    break block9;
                }
                return;
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
            catch (FileNotFoundException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">";
        if (this.rename.getNewDataset() != null && !this.rename.getNewDataset().isEmpty()) {
            this.command = String.valueOf(this.command) + "<DSNUtility>";
            this.command = String.valueOf(this.command) + "<RenameDSN>";
            if (this.rename.getTypeOfDataset().equalsIgnoreCase("Vsam") && !this.rename.getVsamtypeOfDataset().equalsIgnoreCase("T")) {
                String RenameVameComponents = "Y";
                if (!this.rename.isRenameVameComponents()) {
                    RenameVameComponents = "N";
                }
                this.command = String.valueOf(this.command) + "<RenameVSAM ";
                this.command = String.valueOf(this.command) + " RenameVSAMComponents=\"" + RenameVameComponents + "\" ";
                this.command = String.valueOf(this.command) + " >";
                this.command = String.valueOf(this.command) + "<OldVSAMDataSet ClusterName=\"" + this.rename.getOldDataset() + "\" />";
                this.command = String.valueOf(this.command) + "<NewVSAMDataSet ";
                this.command = String.valueOf(this.command) + " ClusterName=\"" + this.rename.getNewDataset() + "\" ";
                if (!this.rename.isRenameVameComponents()) {
                    this.command = String.valueOf(this.command) + " DataName=\"" + this.rename.getDataName() + "\" ";
                    this.command = String.valueOf(this.command) + " IndexName=\"" + this.rename.getIndexName() + "\" ";
                }
                this.command = String.valueOf(this.command) + " />";
                this.command = String.valueOf(this.command) + "</RenameVSAM>";
            } else if (this.rename.getTypeOfDataset().equalsIgnoreCase("Vsam") && this.rename.getVsamtypeOfDataset().equalsIgnoreCase("T")) {
                this.command = String.valueOf(this.command) + "<RenameVSAM ";
                this.command = String.valueOf(this.command) + " RenameVSAMComponents=\"Y\" ";
                this.command = String.valueOf(this.command) + " >";
                this.command = String.valueOf(this.command) + "<OldVSAMDataSet ClusterName=\"" + this.rename.getOldDataset() + "\" />";
                this.command = String.valueOf(this.command) + "<NewVSAMDataSet ";
                this.command = String.valueOf(this.command) + " ClusterName=\"" + this.rename.getNewDataset() + "\" ";
                this.command = String.valueOf(this.command) + " />";
                this.command = String.valueOf(this.command) + "</RenameVSAM>";
            } else {
                this.command = String.valueOf(this.command) + "<RenameMVS>";
                this.command = String.valueOf(this.command) + "<OldDataSet dsname=\"" + this.rename.getOldDataset() + "\" />";
                this.command = String.valueOf(this.command) + "<NewDataSet>" + this.rename.getNewDataset() + "</NewDataSet>";
                this.command = String.valueOf(this.command) + "</RenameMVS>";
            }
            this.command = String.valueOf(this.command) + "</RenameDSN></DSNUtility>";
        } else if (this.rename.getNewMember() != null && !this.rename.getNewMember().isEmpty()) {
            this.command = String.valueOf(this.command) + "<MemberUtility>";
            this.command = String.valueOf(this.command) + "<RenameMember>";
            this.command = String.valueOf(this.command) + "<RenameMVS>";
            this.command = String.valueOf(this.command) + "<OldDataSet dsname=\"" + this.rename.getOldDataset() + "\"/>";
            this.command = String.valueOf(this.command) + "<NewMember name=\"" + this.rename.getOldMember() + "\"  newname=\"" + this.rename.getNewMember() + "\"/>";
            this.command = String.valueOf(this.command) + "</RenameMVS>";
            this.command = String.valueOf(this.command) + "</RenameMember>";
            this.command = String.valueOf(this.command) + "</MemberUtility>";
        }
        this.command = String.valueOf(this.command) + "</GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

