/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetWCMEM
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private static final String SERVICE = "filemaster/fmp";
    private boolean canRetry = true;
    private String command;
    private String type;
    private String uuid;
    private boolean isWCMem;
    private String layoutDsn;
    private String layoutMem;
    private String selCritDynamic;
    private String[] selectionCriteria;

    public RunGetWCMEM(FileMasterDataset dataset, FileMasterServer server, FileMasterMember member, boolean isWCMem, String type) {
        this.dataset = dataset;
        this.server = server;
        this.member = member;
        this.isWCMem = isWCMem;
        this.type = type;
    }

    public RunGetWCMEM(FileMasterDataset dataset, FileMasterServer server, FileMasterMember member, boolean isWCMem, String type, ArrayList<String> selCrit, String layoutDsn, String layoutMem) {
        this.dataset = dataset;
        this.server = server;
        this.member = member;
        this.isWCMem = isWCMem;
        this.type = type;
        this.layoutDsn = layoutDsn;
        this.layoutMem = layoutMem;
        if (selCrit.size() > 0) {
            this.selCritDynamic = selCrit.get(0);
            this.selectionCriteria = this.selCritDynamic.split("\r\n");
        }
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.uuid = FileMasterSession.getUUID(this.server, true);
            if (this.uuid != null) {
                long t1;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("wcmem", map, false, this.createXMLCopy());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    public XMLDocument createXMLCopy() {
        if (this.isWCMem) {
            if (this.member.getName().isEmpty()) {
                this.member.setName("*");
            }
            this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<WildCardMember>" + "<DataSet dsname=\"" + (Object)((Object)this.dataset) + "\" volumeSerial=\"" + this.dataset.getVolume() + "\"/><WCMemberName>" + (Object)((Object)this.member) + "</WCMemberName>" + "<WCMemberType>" + this.type + "</WCMemberType>";
            if (this.layoutDsn != null && this.layoutMem != null && !this.layoutDsn.isEmpty() && !this.layoutMem.isEmpty()) {
                this.command = String.valueOf(this.command) + "<Layout><DataSetName>" + this.layoutDsn + "</DataSetName>" + "<MemberName>" + this.layoutMem + "</MemberName>" + "</Layout>";
            }
            if (this.selectionCriteria != null && this.selectionCriteria.length > 0) {
                this.command = String.valueOf(this.command) + "<SelectionCriteria><DynamicSelCrit>";
                this.command = String.valueOf(this.command) + "<DynamicSelCritLine>*** CA File Master Plus              9.0.0   Selection Criteria</DynamicSelCritLine>";
                this.command = String.valueOf(this.command) + "<DynamicSelCritLine>\"SELECTION CRITERIA MEMBER\"</DynamicSelCritLine>";
                int count = 0;
                while (count < this.selectionCriteria.length) {
                    if (!this.selectionCriteria[count].trim().isEmpty()) {
                        this.command = String.valueOf(this.command) + "<DynamicSelCritLine>" + this.selectionCriteria[count] + "</DynamicSelCritLine>";
                    }
                    ++count;
                }
                this.command = String.valueOf(this.command) + "</DynamicSelCrit>";
                this.command = String.valueOf(this.command) + "</SelectionCriteria>";
            }
            this.command = String.valueOf(this.command) + "</WildCardMember></GUIRequest>";
        } else {
            this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<GetMemberInfo>" + "<DataSet dsname=\"" + (Object)((Object)this.dataset) + "\"/><MemberName>" + (Object)((Object)this.member) + "</MemberName>" + "<MemberType>" + this.type + "</MemberType>" + "</GetMemberInfo>" + "</GUIRequest>";
        }
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

