/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetViewLayout
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private String TopLevel = "";
    private boolean occursField = false;
    private boolean Only01Levels = false;
    private static final String service = "filemaster/fmp";
    private boolean canRetry;
    private String command;
    private String uuid;

    public RunGetViewLayout(String dataset, String member, FileMasterServer server, boolean occursField) {
        FileMasterDataset ds = new FileMasterDataset(null);
        ds.setName(dataset);
        FileMasterMember mem = new FileMasterMember(null);
        mem.setName(member);
        this.dataset = ds;
        this.member = mem;
        this.server = server;
        this.occursField = occursField;
    }

    public RunGetViewLayout(String dataset, String member, FileMasterServer server, boolean occursField, String TopLevel) {
        FileMasterDataset ds = new FileMasterDataset(null);
        ds.setName(dataset);
        FileMasterMember mem = new FileMasterMember(null);
        mem.setName(member);
        this.dataset = ds;
        this.member = mem;
        this.server = server;
        this.occursField = occursField;
        this.TopLevel = TopLevel;
    }

    public RunGetViewLayout(boolean Only01Levels, boolean occursField, String dataset, String member, FileMasterServer server) {
        FileMasterDataset ds = new FileMasterDataset(null);
        ds.setName(dataset);
        FileMasterMember mem = new FileMasterMember(null);
        mem.setName(member);
        this.dataset = ds;
        this.member = mem;
        this.server = server;
        this.Only01Levels = Only01Levels;
        this.occursField = occursField;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, service);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.uuid = FileMasterSession.getUUID(this.server, true);
            if (this.uuid != null) {
                long t1;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("vlay", map, false, this.ViewLayMem());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    public XMLDocument ViewLayMem() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\"><ViewLayout";
        if (this.occursField) {
            this.command = String.valueOf(this.command) + " occursField=\"Y\"";
        }
        if (!this.TopLevel.isEmpty()) {
            this.command = String.valueOf(this.command) + " topName=\"" + this.TopLevel + "\"";
        }
        if (this.Only01Levels) {
            this.command = String.valueOf(this.command) + " only01Levels=\"Y\"";
        }
        this.command = String.valueOf(this.command) + "><Layout><DataSetName>" + (Object)((Object)this.dataset) + "</DataSetName><MemberName>" + (Object)((Object)this.member) + "</MemberName>";
        this.command = String.valueOf(this.command) + "</Layout></ViewLayout></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

