/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunGetReset
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String SERVICE = "filemaster/fmp";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String displayMode;
    private String uuid;
    private String hexMode = "N";
    private FMPRange labelPair;
    private ArrayList<String> restOption = new ArrayList();
    private boolean canRetry = true;

    public RunGetReset(FileMasterServer server, String uuid, String displayMode, String hexMode, FMPRange labelPair, ArrayList<String> restOptions) {
        this.server = server;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
        this.labelPair = labelPair;
        this.restOption = restOptions;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = connection.connect("reset", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                this.xml.getRoot();
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    private XMLDocument createXml() {
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = String.valueOf(command) + "<Reset>";
        int i = 0;
        while (i < this.restOption.size()) {
            command = String.valueOf(command) + "<Option>" + this.restOption.get(i).toUpperCase() + "</Option>";
            ++i;
        }
        if (this.labelPair.getStart().length() > 0) {
            command = String.valueOf(command) + this.getLabelPair();
        }
        command = String.valueOf(command) + "</Reset></Edit></GUIRequest>";
        return CommonMFCalls.createXMLDoc(command);
    }

    private String getLabelPair() {
        if (this.labelPair != null) {
            return "<LabelPair start=\"" + this.labelPair.getStart() + "\" end=\"" + this.labelPair.getEnd() + "\"/>";
        }
        return "";
    }

    public XMLRequest getXml() {
        return this.xml;
    }
}

