/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RunGetDSlists
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private FileMasterMember member;
    private static final String SERVICE = "filemaster/server";

    public RunGetDSlists(FileMasterMember member, FileMasterServer server) {
        this.member = member;
        this.server = server;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String DSNLIST = this.getDSNListPDS();
        if (!DSNLIST.isEmpty()) {
            map.put("dsn", DSNLIST);
            map.put("membername", (Object)this.member);
            map.put("symd", "FM");
            try {
                this.xml = connection.connect("dslst", map, true);
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        } else {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            MessageDialog.openWarning((Shell)window.getShell(), (String)"Warning", (String)"DSN Lists PDS in Preferences is undefined. No DSNLists found");
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private String getDSNListPDS() {
        return this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists();
    }
}

