/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetCreateFile
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    boolean isVSAMAllocation;
    private FileMasterDataset seqOrPdsDSN = new FileMasterDataset(null);
    File file;
    private boolean isSMSClass;
    private static final String SERVICE = "filemaster/fmp";
    private FMPVSAMDataset vsamDSN = new FMPVSAMDataset(null);
    private String uuid;
    private String command;
    private XMLDocument xmlDoc;
    private boolean canRetry = true;

    public RunGetCreateFile(FileMasterServer server, FileMasterDataset fmDSN) {
        this.isVSAMAllocation = false;
        this.server = server;
        this.seqOrPdsDSN = fmDSN;
    }

    public RunGetCreateFile(FileMasterServer server, FMPVSAMDataset vsamDSN, Boolean isSMSClass) {
        this.server = server;
        this.isVSAMAllocation = true;
        this.vsamDSN = vsamDSN;
        this.isSMSClass = isSMSClass;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.uuid = FileMasterSession.getUUID(this.server, true);
        try {
            if (this.uuid != null) {
                long t1;
                map.put("xml", this.xmlDoc);
                map.put("uuid", this.uuid);
                this.xml = this.isVSAMAllocation ? connection.connect("allocvsam", map, false, this.createVSAMXML()) : connection.connect("allocpds", map, false, this.createSEQPDSXML());
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private XMLDocument createSEQPDSXML() {
        String dsname = this.seqOrPdsDSN.getName();
        Boolean isSMSdataset = this.seqOrPdsDSN.isSMSdataset();
        Boolean usesVolumeSerial = this.seqOrPdsDSN.usesVolumeSerial();
        String mgmtclas = this.seqOrPdsDSN.getSmsManagement();
        String storclas = this.seqOrPdsDSN.getSmsStorage();
        String dataclas = this.seqOrPdsDSN.getSmsData();
        String number = this.seqOrPdsDSN.getGenericUnitName();
        String dsntype = this.seqOrPdsDSN.getFileType();
        String units = this.seqOrPdsDSN.getUnits();
        String primary = this.seqOrPdsDSN.getPrimaryAlloc();
        String secondary = this.seqOrPdsDSN.getSecondaryAlloc();
        String directory = this.seqOrPdsDSN.getDirBlocks();
        String recfm = this.seqOrPdsDSN.getRecfm();
        String lrecl = this.seqOrPdsDSN.getLrecl();
        String blksize = this.seqOrPdsDSN.getBlksize();
        Boolean hasMultipleVolumes = this.seqOrPdsDSN.hasMultipleVolumes();
        ArrayList<String> ser = this.seqOrPdsDSN.getVolSerials();
        String count = this.seqOrPdsDSN.getNumVolumes();
        if (usesVolumeSerial.booleanValue()) {
            count = String.valueOf(ser.size());
        }
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<CreateFile>" + "<MvsDataSet dsname=\"" + dsname + "\" dsntype=\"" + dsntype + "\">";
        this.command = String.valueOf(this.command) + "<Dcb recfm=\"" + recfm + "\" lrecl=\"" + lrecl + "\" blksize=\"" + (blksize.length() == 0 ? "0" : blksize) + "\" />";
        this.command = String.valueOf(this.command) + "<Space units=\"" + units + "\" primary=\"" + primary + "\" secondary=\"" + secondary + "\"";
        if (dsntype == "PDS" || dsntype == "PDSE") {
            this.command = String.valueOf(this.command) + " directory=\"" + directory + "\"";
        }
        this.command = String.valueOf(this.command) + " />";
        if (isSMSdataset.booleanValue()) {
            if (hasMultipleVolumes.booleanValue()) {
                this.command = String.valueOf(this.command) + "<Volume count=\"" + count + "\" />";
            }
            if (!(mgmtclas.trim().isEmpty() && storclas.trim().isEmpty() && dataclas.trim().isEmpty())) {
                this.command = String.valueOf(this.command) + "<Sms";
                if (!mgmtclas.trim().isEmpty()) {
                    this.command = String.valueOf(this.command) + " mgmtclas=\"" + mgmtclas + "\"";
                }
                if (!storclas.trim().isEmpty()) {
                    this.command = String.valueOf(this.command) + " storclas= \"" + storclas + "\"";
                }
                if (!dataclas.trim().isEmpty()) {
                    this.command = String.valueOf(this.command) + " dataclas=\"" + dataclas + "\"";
                }
                this.command = String.valueOf(this.command) + "/>";
            }
        } else if (usesVolumeSerial.booleanValue()) {
            if (dsntype == "PDS" || dsntype == "PDSE") {
                count = "1";
            }
            this.command = String.valueOf(this.command) + "<Volume count=\"" + count + "\">";
            int i = 0;
            while (i < ser.size()) {
                this.command = String.valueOf(this.command) + "<Ser>" + ser.get(i) + "</Ser>";
                ++i;
            }
            this.command = String.valueOf(this.command) + "</Volume>";
        } else {
            this.command = String.valueOf(this.command) + "<Unit type=\"" + number + "\"";
            if (hasMultipleVolumes.booleanValue()) {
                this.command = String.valueOf(this.command) + " count=\"" + count + "\"";
            }
            this.command = String.valueOf(this.command) + " />";
        }
        this.command = String.valueOf(this.command) + "</MvsDataSet></CreateFile></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }

    private XMLDocument createVSAMXML() {
        int i;
        String clusterDSN = this.vsamDSN.getCluster();
        String vsamOrgType = this.vsamDSN.getVSAMFileType();
        if (vsamOrgType.equals("Linear")) {
            vsamOrgType = "LDS";
        }
        String bufferSpaceData = this.vsamDSN.getAllocParms().get("BufferSpaceData").toString();
        String erase = this.vsamDSN.getVsamOptions().get("eraseOnDelete").toString();
        String loadRestartable = this.vsamDSN.getVsamOptions().get("loadRestartable").toString();
        String ownerData = this.vsamDSN.getAllocParms().get("OwnerIDData").toString();
        String spanned = this.vsamDSN.getVsamOptions().get("spannedRecords").toString();
        String reuse = this.vsamDSN.getVsamOptions().get("reuseOption").toString();
        String writeCheck = this.vsamDSN.getVsamOptions().get("writeCheck").toString();
        String smsStorage = this.vsamDSN.getSmsStorage();
        String smsData = this.vsamDSN.getSmsData();
        String smsManagement = this.vsamDSN.getSmsManagement();
        String freeSpaceData = this.vsamDSN.getAllocParms().get("PercentFreeData").toString();
        String freeSpaceIndex = this.vsamDSN.getAllocParms().get("PercentFreeIndex").toString();
        String keyPosition = this.vsamDSN.getAllocParms().get("KeyPositionData").toString();
        String keyLength = this.vsamDSN.getAllocParms().get("KeyLengthData").toString();
        String avgRecordSize = this.vsamDSN.getAllocParms().get("AvgRecordSizeData").toString();
        String maxRecordSize = this.vsamDSN.getAllocParms().get("MaxRecordSizeData").toString();
        String shareOptionsData = this.vsamDSN.getAllocParms().get("ShareOptionsData").toString();
        String shareOptionsIndex = this.vsamDSN.getAllocParms().get("ShareOptionsIndex").toString();
        String dataDSN = this.vsamDSN.getData();
        String CISizeData = this.vsamDSN.getAllocParms().get("CISizeData").toString();
        String unitData = this.vsamDSN.getAllocParms().get("UnitData").toString();
        if (unitData.equalsIgnoreCase("Tracks")) {
            unitData = "trk";
        } else if (unitData.equalsIgnoreCase("Cylinders")) {
            unitData = "cyl";
        } else if (unitData.equalsIgnoreCase("Blocks")) {
            unitData = "blk";
        } else if (unitData.equalsIgnoreCase("Records")) {
            unitData = "rec";
        } else if (unitData.equalsIgnoreCase("Kilobytes")) {
            unitData = "k";
        } else if (unitData.equalsIgnoreCase("Megabytes")) {
            unitData = "m";
        }
        String primaryData = this.vsamDSN.getAllocParms().get("PrimaryData").toString();
        String secondaryData = this.vsamDSN.getAllocParms().get("SecondaryData").toString();
        String indexDSN = this.vsamDSN.getIndex();
        String CISizeIndex = this.vsamDSN.getAllocParms().get("CISizeIndex").toString();
        String unitIndex = this.vsamDSN.getAllocParms().get("UnitIndex").toString();
        if (unitIndex.equalsIgnoreCase("Tracks")) {
            unitIndex = "trk";
        } else if (unitIndex.equalsIgnoreCase("Cylinders")) {
            unitIndex = "cyl";
        } else if (unitIndex.equalsIgnoreCase("Blocks")) {
            unitIndex = "blk";
        } else if (unitIndex.equalsIgnoreCase("Records")) {
            unitIndex = "rec";
        } else if (unitIndex.equalsIgnoreCase("Kilobytes")) {
            unitIndex = "k";
        } else if (unitIndex.equalsIgnoreCase("Megabytes")) {
            unitIndex = "m";
        }
        String primaryIndex = this.vsamDSN.getAllocParms().get("PrimaryIndex").toString();
        String secondaryIndex = this.vsamDSN.getAllocParms().get("SecondaryIndex").toString();
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<CreateFile>" + "<VsamDataSet>" + "<Cluster";
        this.command = String.valueOf(this.command) + " dsname=\"" + clusterDSN + "\"";
        this.command = String.valueOf(this.command) + " organization=\"" + vsamOrgType + "\"";
        if (!bufferSpaceData.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " bufferSpace=\"" + bufferSpaceData + "\"";
        }
        if (!erase.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " erase=\"" + erase + "\"";
        }
        if (!loadRestartable.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " loadRestartable=\"" + loadRestartable + "\"";
        }
        if (!ownerData.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " owner=\"" + ownerData + " \"";
        }
        if (!spanned.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " spanned=\"" + spanned + "\"";
        }
        if (!reuse.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " reuse=\"" + reuse + "\"";
        }
        if (!writeCheck.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " writeCheck=\"" + writeCheck + "\"";
        }
        this.command = String.valueOf(this.command) + ">";
        if (this.isSMSClass) {
            this.command = String.valueOf(this.command) + "<Sms";
            if (!smsData.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " storclas=\"" + smsStorage + "\"";
            }
            if (!smsStorage.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " mgmtclas= \"" + smsManagement + "\"";
            }
            if (!smsManagement.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " dataclas=\"" + smsData + "\"";
            }
            this.command = String.valueOf(this.command) + ">";
            this.command = String.valueOf(this.command) + "</Sms>";
        }
        if (!freeSpaceData.trim().isEmpty() || !freeSpaceIndex.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<Freespace";
            if (!freeSpaceData.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " CIpercent=\"" + freeSpaceData + "\"";
            }
            if (!freeSpaceIndex.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " CApercent=\"" + freeSpaceIndex + "\"";
            }
            this.command = String.valueOf(this.command) + "/>";
        }
        if (!keyPosition.trim().isEmpty() || !keyLength.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<Keys";
            if (!keyPosition.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " offset=\"" + keyPosition + "\"";
            }
            if (!keyLength.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " length=\"" + keyLength + "\"";
            }
            this.command = String.valueOf(this.command) + "/>";
        }
        if (!avgRecordSize.trim().isEmpty() || !maxRecordSize.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<Recordsize";
            if (!avgRecordSize.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " average=\"" + avgRecordSize + "\"";
            }
            if (!maxRecordSize.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " maximum= \"" + maxRecordSize + "\"";
            }
            this.command = String.valueOf(this.command) + ">";
            this.command = String.valueOf(this.command) + "</Recordsize>";
        }
        if (!shareOptionsData.trim().isEmpty() || !shareOptionsIndex.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<Shareoptions";
            if (!shareOptionsData.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " crossregion=\"" + shareOptionsData + "\"";
            }
            if (!shareOptionsIndex.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " crosssystem=\"" + shareOptionsIndex + "\"";
            }
            this.command = String.valueOf(this.command) + "/>";
        }
        this.command = String.valueOf(this.command) + "</Cluster>";
        this.command = String.valueOf(this.command) + "<Data";
        this.command = String.valueOf(this.command) + " dsname=\"" + dataDSN + "\"";
        if (!CISizeData.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " controlIntervalSize=\"" + CISizeData + "\"";
        }
        this.command = String.valueOf(this.command) + ">";
        this.command = String.valueOf(this.command) + "<Space";
        if (!unitData.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " units=\"" + unitData + "\"";
        }
        if (!primaryData.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " primary=\"" + primaryData + "\"";
        }
        if (!secondaryData.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " secondary=\"" + secondaryData + "\"";
        }
        this.command = String.valueOf(this.command) + "/>";
        if (this.isSMSClass && Integer.valueOf(this.vsamDSN.getDataVolumesCount()) > 1) {
            this.command = String.valueOf(this.command) + "<Volume count=\"" + this.vsamDSN.getDataVolumesCount() + "\" />";
        } else if (this.vsamDSN.getDataVolumes().size() != 0 && !this.isSMSClass) {
            this.command = String.valueOf(this.command) + "<Volume count=\"" + this.vsamDSN.getDataVolumes().size() + "\" >";
            i = 0;
            while (i < this.vsamDSN.getDataVolumes().size()) {
                this.command = String.valueOf(this.command) + "<Ser>" + this.vsamDSN.getDataVolumes().get(i) + "</Ser>";
                ++i;
            }
            this.command = String.valueOf(this.command) + "</Volume>";
        }
        this.command = String.valueOf(this.command) + "</Data>";
        if (!vsamOrgType.equals("ESDS") && !vsamOrgType.equals("Linear")) {
            this.command = String.valueOf(this.command) + "<Index dsname=\"" + indexDSN + "\"";
            if (!CISizeIndex.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " controlIntervalSize=\"" + CISizeIndex + "\"";
            }
            this.command = String.valueOf(this.command) + ">";
            this.command = String.valueOf(this.command) + "<Space";
            if (!unitIndex.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " units=\"" + unitIndex + "\"";
            }
            if (!primaryIndex.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " primary=\"" + primaryIndex + "\"";
            }
            if (!secondaryIndex.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " secondary=\"" + secondaryIndex + "\"";
            }
            this.command = String.valueOf(this.command) + "/>";
            if (this.isSMSClass && Integer.valueOf(this.vsamDSN.getIndexVolumesCount()) > 1) {
                this.command = String.valueOf(this.command) + "<Volume count=\"" + this.vsamDSN.getIndexVolumesCount() + "\" />";
            }
            if (this.vsamDSN.getIndexVolumes().size() != 0 && !this.isSMSClass) {
                this.command = String.valueOf(this.command) + "<Volume count=\"" + this.vsamDSN.getIndexVolumes().size() + "\" >";
                i = 0;
                while (i < this.vsamDSN.getIndexVolumes().size()) {
                    this.command = String.valueOf(this.command) + "<Ser>" + this.vsamDSN.getIndexVolumes().get(i) + "</Ser>";
                    ++i;
                }
                this.command = String.valueOf(this.command) + "</Volume>";
            }
            this.command = String.valueOf(this.command) + "</Index>";
        }
        this.command = String.valueOf(this.command) + "</VsamDataSet></CreateFile></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }

    public XMLRequest getXml() {
        return this.xml;
    }
}

