/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetCopyDS
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private String command;
    private String uuid;
    private XMLDocument xmlDoc;
    private FileMasterServer server;
    private String fromDataset;
    private String fromVolume;
    private String toDataset;
    private String toVolume;
    private String disp;
    private String replaceMembers;
    private String replaceKeys;
    private String layoutdsn;
    private String layoutmem;
    private String selCritDynamic;
    private ArrayList<String> memberList;
    private String copyType;
    private static final String SERVICE = "filemaster/fmp";
    private boolean canRetry = true;
    private String[] selectionCriteria;

    public RunGetCopyDS(FileMasterServer server, ArrayList<FileMasterDataset> datasetsList, ArrayList<FileMasterMember> membersList, String isReplaceMembers, String isReplaceKeys, String disposition, FileMasterMember layoutMembers, ArrayList<String> selCrit, String copyType) {
        this.fromDataset = datasetsList.get(0).getName();
        this.fromVolume = datasetsList.get(0).getVolume();
        this.server = server;
        this.toDataset = datasetsList.get(1).getName();
        this.toVolume = datasetsList.get(1).getVolume();
        this.layoutdsn = datasetsList.size() > 2 ? datasetsList.get(2).getName() : "";
        this.layoutmem = layoutMembers.getName();
        this.selCritDynamic = selCrit.get(0);
        this.disp = disposition;
        this.replaceMembers = isReplaceMembers;
        this.replaceKeys = isReplaceKeys;
        this.copyType = copyType;
        this.selectionCriteria = this.selCritDynamic.split("\r\n");
        if (copyType.equalsIgnoreCase("PDS")) {
            this.addMembers(membersList);
        } else if (membersList.size() > 0) {
            this.memberList = new ArrayList();
            this.memberList.add(membersList.get(0).getName());
        }
    }

    private void addMembers(ArrayList<FileMasterMember> membersList) {
        this.memberList = new ArrayList();
        int count = 0;
        while (count < membersList.size()) {
            if (!membersList.get(count).getNewName().isEmpty()) {
                this.memberList.add(String.valueOf(membersList.get(count).getName()) + ":" + membersList.get(count).getNewName());
            } else {
                this.memberList.add(membersList.get(count).getName());
            }
            ++count;
        }
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.uuid = FileMasterSession.getUUID(this.server, true);
        try {
            this.uuid = FileMasterSession.getUUID(this.server, true);
            if (this.uuid != null) {
                long t1;
                map.put("xml", this.xmlDoc);
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("copy", map, false, this.createXMLCopy());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLDocument createXMLCopy() {
        int count;
        String memberName = "";
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Copy";
        if (!this.replaceMembers.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + " replaceMembers=\"" + this.replaceMembers + "\"";
        }
        if (this.copyType.equalsIgnoreCase("VSAM") || this.copyType.equalsIgnoreCase("SEQ")) {
            this.command = String.valueOf(this.command) + " replaceKeys=\"" + this.replaceKeys + "\"";
        }
        if (this.memberList.size() == 1 && (this.copyType.equalsIgnoreCase("PDS") || this.copyType.equalsIgnoreCase("PDSE"))) {
            if (this.memberList.get(0).contains(":")) {
                this.command = String.valueOf(this.command) + "><FromDataSet dsname=\"" + this.fromDataset + "\" volumeSerial=\"" + this.fromVolume + "\"/>";
            } else {
                memberName = this.memberList.get(0);
                this.command = String.valueOf(this.command) + "><FromDataSet dsname=\"" + this.fromDataset + "\" member=\"" + memberName + "\" volumeSerial=\"" + this.fromVolume + "\"/>";
            }
        } else {
            this.command = String.valueOf(this.command) + "><FromDataSet dsname=\"" + this.fromDataset + "\" volumeSerial=\"" + this.fromVolume + "\"/>";
        }
        this.command = String.valueOf(this.command) + "<ToDataSet dsname=\"" + this.toDataset;
        if (!(this.memberList.size() != 1 || this.memberList.get(0).isEmpty() || this.memberList.get(0).contains(":") || this.memberList.get(0).contains("*"))) {
            memberName = this.memberList.get(0);
            this.command = String.valueOf(this.command) + "\" member=\"" + memberName;
        }
        this.command = String.valueOf(this.command) + "\" volumeSerial=\"" + this.toVolume + "\"/>";
        this.command = String.valueOf(this.command) + "<ToDisp>" + this.disp + "</ToDisp>";
        if (this.memberList.size() >= 1 && (this.copyType.equalsIgnoreCase("PDS") || this.copyType.equalsIgnoreCase("PDSE")) && !this.memberList.get(0).trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<MemberList>";
            count = 0;
            while (count < this.memberList.size()) {
                this.command = String.valueOf(this.command) + "<Member name=\"" + this.memberList.get(count).split(":")[0] + "\"";
                if (this.memberList.get(count).split(":").length > 1) {
                    this.command = String.valueOf(this.command) + " newname=\"" + this.memberList.get(count).split(":")[1] + "\"";
                }
                this.command = String.valueOf(this.command) + "/>";
                ++count;
            }
            this.command = String.valueOf(this.command) + "</MemberList>";
        }
        if (!this.layoutdsn.isEmpty() && !this.layoutmem.isEmpty()) {
            this.command = String.valueOf(this.command) + "<Layout><DataSetName>" + this.layoutdsn + "</DataSetName>" + "<MemberName>" + this.layoutmem + "</MemberName>" + "</Layout>";
        }
        if (this.selectionCriteria.length > 0 && !this.selectionCriteria[0].trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<SelectionCriteria><DynamicSelCrit>";
            count = 0;
            while (count < this.selectionCriteria.length) {
                this.command = String.valueOf(this.command) + "<DynamicSelCritLine>" + this.selectionCriteria[count] + "</DynamicSelCritLine>";
                ++count;
            }
            this.command = String.valueOf(this.command) + "</DynamicSelCrit>";
            this.command = String.valueOf(this.command) + "</SelectionCriteria>";
        }
        this.command = String.valueOf(this.command) + "</Copy></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }

    public XMLRequest getXml() {
        return this.xml;
    }
}

