/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.utility.compare.Position;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetCompareReport
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String oldDatasetName;
    private String newDatasetName;
    private String oldLayoutdsn;
    private String oldLayoutMember;
    private String newLayoutdsn;
    private String newLayoutMember;
    private String dynamicSelcritLine;
    private boolean isPgmCompare;
    private ArrayList<Position> positionList;
    private ArrayList<String> memberList;
    private ArrayList<String> printOutput;
    private HashMap<String, Object> mapCSECTOptions;
    private String CSECTInclude;
    private String CSECTExclude;
    private boolean canRetry = true;
    private String command;
    private String uuid;
    File file;
    private static final String SERVICE = "filemaster/fmp";
    private String oldDatasetType;
    private boolean cmpDiffName;

    public RunGetCompareReport(FileMasterServer server, ArrayList<FileMasterDataset> datasets, ArrayList<FileMasterMember> members, ArrayList<String> outputOptions, ArrayList<FileMasterMember> layoutMember, ArrayList<String> dynamicSelcritLine, ArrayList<Position> position, boolean isPgmCompare, boolean cmpDiffName) {
        this.server = server;
        this.oldDatasetName = datasets.get(0).getName();
        this.oldDatasetType = datasets.get(0).getDsOrg();
        this.newDatasetName = datasets.get(1).getName();
        this.oldLayoutdsn = datasets.get(2).getName();
        this.oldLayoutMember = layoutMember.get(0).getName();
        this.newLayoutMember = layoutMember.get(1).getName();
        this.newLayoutdsn = datasets.get(3).getName();
        this.newLayoutMember = layoutMember.get(1).getName();
        this.dynamicSelcritLine = dynamicSelcritLine.get(0);
        this.positionList = position;
        this.printOutput = outputOptions;
        this.cmpDiffName = cmpDiffName;
        this.addMembers(members);
    }

    private void addMembers(ArrayList<FileMasterMember> membersList) {
        this.memberList = new ArrayList();
        int count = 0;
        while (count < membersList.size()) {
            this.memberList.add(membersList.get(count).getName());
            ++count;
        }
    }

    public RunGetCompareReport(FileMasterServer server, ArrayList<FileMasterDataset> datasets, ArrayList<FileMasterMember> members, ArrayList<String> outputOptions, HashMap<String, Object> mapCSECTOptions, String CSECTInclude, String CSECTExclude, boolean isPgmCompare, boolean cmpDiffName) {
        this.server = server;
        this.oldDatasetName = datasets.get(0).getName();
        this.newDatasetName = datasets.get(1).getName();
        this.printOutput = outputOptions;
        this.mapCSECTOptions = mapCSECTOptions;
        this.CSECTInclude = CSECTInclude;
        this.CSECTExclude = CSECTExclude;
        this.isPgmCompare = true;
        this.oldDatasetType = datasets.get(0).getDsOrg();
        this.cmpDiffName = cmpDiffName;
        this.addMembers(members);
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.uuid = FileMasterSession.getUUID(this.server, true);
            if (this.uuid != null) {
                long t1;
                map.put("uuid", this.uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("comp", map, false, this.createXMLCopy());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, this.uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, this.uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, this.uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXMLCopy() {
        int count;
        String recordDisplay = this.printOutput.get(1);
        String fieldDisplay = this.printOutput.get(2);
        String oldDataSet = this.oldDatasetName;
        String oldDataSetType = this.oldDatasetType;
        String newDataSet = this.newDatasetName;
        String maxMisMatches = this.printOutput.size() > 3 ? this.printOutput.get(3) : "";
        String outputPageSize = this.printOutput.size() > 4 ? this.printOutput.get(4) : "";
        String printFormat = this.printOutput.get(0);
        String oldLayoutDSN = this.oldLayoutdsn;
        String newLayoutDSN = this.newLayoutdsn;
        String CSECTCompare = this.printOutput.size() > 6 ? this.printOutput.get(6) : "";
        String properties = this.printOutput.size() > 5 ? this.printOutput.get(5) : "";
        String CSECTOptions = this.isPgmCompare ? this.mapCSECTOptions.toString() : "";
        String[] dynamicSelCrit = this.dynamicSelcritLine == null ? new String[]{} : this.dynamicSelcritLine.split("\r\n");
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Compare";
        if (!recordDisplay.isEmpty()) {
            this.command = String.valueOf(this.command) + " compReport=\"" + recordDisplay + "\"";
        }
        if (!fieldDisplay.isEmpty()) {
            this.command = String.valueOf(this.command) + " fieldDisplay=\"" + fieldDisplay + "\"";
        }
        this.command = String.valueOf(this.command) + "><OldDataSet dsname=\"" + oldDataSet.trim() + "\"";
        if (this.memberList.size() == 1 && (oldDataSetType.equalsIgnoreCase("PDS") || oldDataSetType.equalsIgnoreCase("PDSE")) || this.memberList.size() == 2 && this.cmpDiffName) {
            this.command = String.valueOf(this.command) + " member=\"" + this.memberList.get(0) + "\"";
        }
        this.command = String.valueOf(this.command) + "/>";
        this.command = String.valueOf(this.command) + "<NewDataSet dsname=\"" + newDataSet.trim() + "\"";
        if (this.memberList.size() == 1 && !this.memberList.get(0).contains("*") && (oldDataSetType.equalsIgnoreCase("PS") || oldDataSetType.equalsIgnoreCase("PSL") || oldDataSetType.equalsIgnoreCase("Sequential") || oldDataSetType.equalsIgnoreCase("VSAM"))) {
            this.command = String.valueOf(this.command) + " member=\"" + this.memberList.get(0) + "\"";
        } else if (this.memberList.size() == 2 && this.cmpDiffName) {
            this.command = String.valueOf(this.command) + " member=\"" + this.memberList.get(1) + "\"";
        }
        this.command = String.valueOf(this.command) + "/>";
        if (this.memberList.size() > 1 && !this.cmpDiffName) {
            this.command = String.valueOf(this.command) + "<MemberList>";
            count = 0;
            while (count < this.memberList.size()) {
                this.command = String.valueOf(this.command) + "<Member name=\"" + this.memberList.get(count) + "\"/>";
                ++count;
            }
            this.command = String.valueOf(this.command) + "</MemberList>";
        }
        if (!maxMisMatches.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<MaxMismatches>" + maxMisMatches + "</MaxMismatches>";
        }
        if (!outputPageSize.trim().isEmpty()) {
            this.command = String.valueOf(this.command) + "<OutputPageSize>" + outputPageSize + "</OutputPageSize>";
        }
        if (!this.isPgmCompare) {
            this.command = String.valueOf(this.command) + "<CompareTextParameters";
            if (!printFormat.isEmpty()) {
                this.command = String.valueOf(this.command) + " printFormat= \"" + printFormat + "\"";
            }
            this.command = String.valueOf(this.command) + ">";
            if (!oldLayoutDSN.trim().isEmpty() && !this.oldLayoutMember.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + "<OldLayout><DataSetName>" + oldLayoutDSN.trim() + "</DataSetName>" + "<MemberName>" + this.oldLayoutMember + "</MemberName>" + "</OldLayout>";
            }
            if (!newLayoutDSN.trim().isEmpty() && !this.newLayoutMember.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + "<NewLayout><DataSetName>" + newLayoutDSN.trim() + "</DataSetName>" + "<MemberName>" + this.newLayoutMember + "</MemberName>" + "</NewLayout>";
            }
            if (this.positionList.size() > 0) {
                this.command = String.valueOf(this.command) + "<PositionList>";
                count = 0;
                while (count < this.positionList.size()) {
                    this.command = String.valueOf(this.command) + "<Position oldPositionOffset=\"" + this.positionList.get(count).getOldPosition() + "\" " + "newPositionOffset=\"" + this.positionList.get(count).getNewPosition() + "\" " + "positionLength=\"" + this.positionList.get(count).getLength() + "\" " + "/>";
                    ++count;
                }
                this.command = String.valueOf(this.command) + "</PositionList>";
            }
            if (dynamicSelCrit.length > 0 && !dynamicSelCrit[0].trim().isEmpty()) {
                this.command = String.valueOf(this.command) + "<SelectionCriteria><DynamicSelCrit>";
                this.command = String.valueOf(this.command) + "<DynamicSelCritLine>*** CA File Master Plus              9.0.0   Selection Criteria</DynamicSelCritLine>";
                this.command = String.valueOf(this.command) + "<DynamicSelCritLine>\"SELECTION CRITERIA MEMBER\"</DynamicSelCritLine>";
                count = 0;
                while (count < dynamicSelCrit.length) {
                    this.command = String.valueOf(this.command) + "<DynamicSelCritLine>" + dynamicSelCrit[count] + "</DynamicSelCritLine>";
                    ++count;
                }
                this.command = String.valueOf(this.command) + "</DynamicSelCrit>";
                this.command = String.valueOf(this.command) + "</SelectionCriteria>";
            }
            this.command = String.valueOf(this.command) + "</CompareTextParameters>";
        } else {
            this.command = String.valueOf(this.command) + "<CompareProgramParameters";
            if (!printFormat.isEmpty()) {
                this.command = String.valueOf(this.command) + " printFormat=\"" + printFormat + "\"";
            }
            if (!CSECTCompare.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + " csectCompare=\"" + CSECTCompare + "\"";
            }
            this.command = String.valueOf(this.command) + ">";
            if (CSECTOptions.length() > 0) {
                CSECTOptions = CSECTOptions.substring(1, CSECTOptions.length() - 1);
                CSECTOptions = CSECTOptions.replace(",", "");
            }
            if (!CSECTOptions.trim().isEmpty()) {
                if (properties.equalsIgnoreCase("I")) {
                    this.command = String.valueOf(this.command) + "<PropertiesInclude " + CSECTOptions + " />";
                } else if (properties.equalsIgnoreCase("E")) {
                    this.command = String.valueOf(this.command) + "<PropertiesExclude " + CSECTOptions + " />";
                }
            }
            if (!this.CSECTInclude.trim().isEmpty() || !this.CSECTExclude.trim().isEmpty()) {
                this.command = String.valueOf(this.command) + "<CSECTSelection>";
                if (!this.CSECTInclude.trim().isEmpty()) {
                    this.command = String.valueOf(this.command) + "<CSECTInclude>" + this.CSECTInclude + "</CSECTInclude>";
                }
                if (!this.CSECTExclude.trim().isEmpty()) {
                    this.command = String.valueOf(this.command) + "<CSECTExclude>" + this.CSECTExclude + "</CSECTExclude>";
                }
                this.command = String.valueOf(this.command) + "</CSECTSelection>";
            }
            this.command = String.valueOf(this.command) + "</CompareProgramParameters>";
        }
        this.command = String.valueOf(this.command) + "</Compare></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

