/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class RunGetCRLMem
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private static final String service = "filemaster/fmp";
    private XMLRequest xml = null;
    private boolean canRetry = true;
    private String command;
    private String uuid;

    public RunGetCRLMem(FileMasterServer server, FileMasterDataset dataset, FileMasterMember member) {
        this.dataset = dataset;
        this.server = server;
        this.member = member;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, service);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String uuid = FileMasterSession.getUUID(this.server, true);
            if (uuid != null) {
                long t1;
                map.put("uuid", uuid);
                long t0 = System.currentTimeMillis();
                while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
                }
                this.xml = connection.connect("implay", map, false, this.createXMLSelMem());
                if (this.xml.getAttachedFile() != null) {
                    File file = this.xml.getAttachedFile();
                    FileInputStream is = new FileInputStream(file);
                    this.xml = new XMLRequest((InputStream)is);
                } else {
                    Element reqElement = this.xml.getRoot();
                    if (reqElement != null) {
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                            if (this.canRetry) {
                                this.canRetry = false;
                                FileMasterSession.removeSession(this.server, uuid);
                                this.run();
                            }
                            FileMasterSession.removeSession(this.server, uuid);
                        }
                        if (reqElement.getAttribute("errorlevel").equalsIgnoreCase("16")) {
                            FileMasterSession.removeSession(this.server, uuid);
                            this.run();
                        }
                    }
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    public XMLDocument createXMLSelMem() {
        this.command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<GetCrlMbr>" + "<CrlMember dsname=\"" + (Object)((Object)this.dataset) + "\" member=\"" + (Object)((Object)this.member) + "\"/>";
        this.command = String.valueOf(this.command) + "</GetCrlMbr></GUIRequest>";
        return CommonMFCalls.createXMLDoc(this.command);
    }
}

