/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.handlers;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.runners.RunGetDelete;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeleteMemHandler
extends AbstractHandler
implements IElementUpdater {
    FMServerTreeModel fmModel = FMServerTreeModel.getInstance();
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private ExecutionEvent event;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)sel;
        this.event = event;
        if (selection.isEmpty()) {
            return null;
        }
        Object object = selection.getFirstElement();
        TT_TreeItem treeItem = (TT_TreeItem)object;
        this.server = (FileMasterServer)treeItem.getParent().getServer();
        this.dataSet = (FileMasterDataset)treeItem.getParent().getValue();
        boolean showDialog = this.server.getFmpPreferences().getFmDefaultPrefs().isConfirmDeleteMember();
        ArrayList<FileMasterMember> list = new ArrayList<FileMasterMember>(selection.size());
        for (Object item : selection) {
            FileMasterMember treeItem1;
            if (!(item instanceof TT_TreeItem) || (treeItem1 = (FileMasterMember)((TT_TreeItem)item).getValue()) == null) continue;
            list.add(treeItem1);
        }
        if (showDialog) {
            boolean result;
            if (list.size() == 0) {
                return null;
            }
            String question = null;
            if (list.size() > 1) {
                question = String.format("Do you want to delete these %d items?", selection.size());
                result = MessageDialog.openConfirm(null, (String)"Confirm Delete", (String)question);
            } else {
                FileMasterMember target = list.get(0);
                String deleteItem = "member";
                question = String.format("Do you want to delete %s: %s?", deleteItem, ((Object)((Object)target)).toString());
                result = MessageDialog.openConfirm(null, (String)"Confirm Delete", (String)question);
            }
            if (result) {
                RunGetDelete runner = new RunGetDelete(this.dataSet, this.server, list);
                BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                if (runner.getXml() != null) {
                    this.handleResponse(runner.getXml(), list);
                }
            }
        } else {
            RunGetDelete runner = new RunGetDelete(this.dataSet, this.server, list);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            if (runner.getXml() != null) {
                this.handleResponse(runner.getXml(), list);
            }
        }
        return null;
    }

    private void handleResponse(XMLRequest xml, ArrayList<FileMasterMember> list) {
        ArrayList<String> contentAL = new ArrayList<String>();
        TT_TreeItem toBeRemoved = null;
        int successMembers = 0;
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList memberResponse = element.getElementsByTagName("MemberUtilityResponse");
                String pgmRetCode = ((Element)memberResponse.item(0)).getAttribute("programReturnCode");
                NodeList nodes = element.getElementsByTagName("Line");
                if (pgmRetCode.equalsIgnoreCase("0")) {
                    for (FileMasterMember value : list) {
                        toBeRemoved = this.fmModel.removeItem(this.fmModel.dlistMap.get((String.valueOf(this.server.getUUIDString()) + this.dataSet.getName() + value.getName()).hashCode()));
                        this.fmModel.save();
                        ++successMembers;
                    }
                }
                int i = 0;
                while (i < nodes.getLength()) {
                    Element lineElement = (Element)nodes.item(i);
                    String line = new String();
                    line = DeleteMemHandler.getTagValue("Line", lineElement);
                    if (line.startsWith("Failed:")) {
                        line = line.replace("Failed:", "").trim();
                        String[] members = line.split(",");
                        int index = 0;
                        while (index < members.length) {
                            list.remove((Object)((FileMasterMember)this.fmModel.dlistMap.get((String.valueOf(this.server.getUUIDString()) + this.dataSet.getName() + members[index]).hashCode()).getValue()));
                            ++index;
                        }
                        for (FileMasterMember value : list) {
                            toBeRemoved = this.fmModel.removeItem(this.fmModel.dlistMap.get((String.valueOf(this.server.getUUIDString()) + this.dataSet.getName() + value.getName()).hashCode()));
                            this.fmModel.save();
                        }
                    } else {
                        contentAL.add(line);
                    }
                    ++i;
                }
                this.updateReportsView(contentAL.toArray(new String[contentAL.size()]));
                if (pgmRetCode.equals("0")) {
                    MessageDialog.openInformation(null, (String)"Delete Member", (String)(String.valueOf(successMembers) + " members were successfully deleted."));
                }
            }
        }
        try {
            IWorkbenchWindow window;
            IWorkbenchPage page;
            IViewPart view;
            if (toBeRemoved != null && (view = (page = (window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)this.event)).getActivePage()).showView("com.ca.filemaster.views.directorylist")) instanceof DirectoryListView) {
                TreeViewer viewer = ((DirectoryListView)view).getViewer();
                if (viewer != null) {
                    viewer.refresh(true);
                }
                TT_TreeItem selectionIndex = toBeRemoved;
                viewer.setSelection((ISelection)new StructuredSelection(selectionIndex), true);
                view.setFocus();
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void updateReportsView(String[] content) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            IViewPart view;
            if (!content.toString().isEmpty() && (view = page.showView("com.ca.filemaster.views.reportsview", UUID.randomUUID().toString(), 1)) instanceof ReportView) {
                ((ReportView)view).updateReportViewer(content);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    public void updateElement(UIElement element, Map parameters) {
    }
}

