/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLResponseParser {
    private static final String TOTAL_MATCH_STRING_NOT_FOUND = "String not found";
    private static final String TOTAL_MATCH_STRING_FOUND = "String found";
    private String displayMode;
    private String hex;
    private ArrayList<Integer> rangeLineNumber = new ArrayList();
    private ArrayList<Integer> rangeStart = new ArrayList();
    private ArrayList<Integer> rangeEnd = new ArrayList();
    private ArrayList<Integer> rangeIndex = new ArrayList();
    private ArrayList<String> rangeHex = new ArrayList();
    private ArrayList<FileMasterRecord> fileMasterRecords = new ArrayList();
    private XMLRequest xmlRequest;
    private String charDataHex = "N";
    private int cursorPositionBase = -1;
    private int cursorPosition = -1;
    private int cursorPositionLineNumber = -1;
    private int cursorFieldId = -1;
    private String cursorFieldName = "";
    private boolean isCursorInHexField = false;
    private String messageAsAString = null;
    private String[] message = null;
    private String messageCode = null;
    private ArrayList<String> moreThanOneMessageCode = new ArrayList();
    private String displayMessage = null;
    private Logger log = Logger.getLogger(XMLResponseParser.class.getName());
    private int returnCode = -1;

    public XMLResponseParser(XMLRequest xmlRequest) {
        this.xmlRequest = xmlRequest;
        this.rangeLineNumber.clear();
        this.rangeEnd.clear();
        this.rangeIndex.clear();
        this.rangeStart.clear();
        this.rangeHex.clear();
        this.parse();
    }

    private void parse() {
        NodeList records;
        NodeList messages;
        NodeList retCode;
        Node rcNode;
        Element rcElement;
        Element rootElement = this.xmlRequest.getRoot();
        if (rootElement == null) {
            return;
        }
        NodeList recordList = rootElement.getElementsByTagName(Constants.ELEMENT_RECORD_LIST);
        if (recordList.getLength() > 0) {
            this.hex = ((Element)recordList.item(0)).getAttribute(Constants.ATTRIBUTE_HEX);
            this.displayMode = ((Element)recordList.item(0)).getAttribute(Constants.ATTRIBUTE_DISPLAYMODE);
        }
        if ((rcElement = (Element)(rcNode = (retCode = rootElement.getElementsByTagName(Constants.ELEMENT_RETURN_CODE)).item(0))) != null) {
            this.returnCode = Integer.parseInt(CommonMFCalls.getTagValue(Constants.ELEMENT_RETURN_CODE, rcElement));
        }
        if ((messages = rootElement.getElementsByTagName("Message")) != null && messages.getLength() > 0) {
            int j = 0;
            while (j < messages.getLength()) {
                Element messageElement = (Element)messages.item(j);
                NodeList x = messageElement.getChildNodes();
                Node nValue = x.item(j);
                if (nValue != null) {
                    String value = nValue.getNodeValue();
                    if (value != null) {
                        this.messageAsAString = value.trim();
                        this.message = value.trim().split(" ");
                        this.messageCode = this.message[0];
                    }
                } else if (messageElement.getFirstChild().getNodeValue() != null) {
                    String SecondValue = messageElement.getFirstChild().getNodeValue();
                    this.messageAsAString = SecondValue.trim();
                    this.moreThanOneMessageCode.add(this.messageAsAString);
                }
                ++j;
            }
        }
        if ((records = rootElement.getElementsByTagName(Constants.ELEMENT_RECORD)) == null) {
            return;
        }
        this.extractFileMasterRecordAndAddToFileMasterRecords(records);
        int i = 0;
        while (i < records.getLength()) {
            Element record = (Element)records.item(i);
            String recordNumber = record.getAttribute(Constants.ATTRIBUTE_NUMBER);
            if (!record.hasAttribute(Constants.ATTRIBUTE_EXCLUDED)) {
                Element recordFields = (Element)record.getElementsByTagName(Constants.ELEMENT_RECORD_FIELDS).item(0);
                int numberOfRecordFields = recordFields.getElementsByTagName(Constants.ELEMENT_RECORD_FIELD).getLength();
                int p = 0;
                while (p < numberOfRecordFields) {
                    Element recordField = (Element)recordFields.getElementsByTagName(Constants.ELEMENT_RECORD_FIELD).item(p);
                    if (recordField.hasAttribute(Constants.ATTRIBUTE_CHARDATAHEX)) {
                        this.charDataHex = recordField.getAttribute(Constants.ATTRIBUTE_CHARDATAHEX);
                    }
                    if (recordField.hasAttribute(Constants.ATTRIBUTE_CURSOR)) {
                        this.cursorPosition = Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_CURSOR));
                        this.cursorPositionLineNumber = Integer.parseInt(recordNumber);
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_POSITION)) {
                            this.cursorPositionBase = Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_POSITION));
                        }
                        if (recordField.hasAttribute(Constants.ATTRIBUTE_ID)) {
                            this.cursorFieldId = Integer.parseInt(recordField.getAttribute(Constants.ATTRIBUTE_ID));
                        }
                    }
                    if (recordField.hasChildNodes()) {
                        NodeList recordFieldChildNodes = recordField.getChildNodes();
                        int j = 0;
                        while (j < recordFieldChildNodes.getLength()) {
                            Element x = (Element)recordFieldChildNodes.item(j);
                            if (x.getNodeName() == Constants.ELEMENT_FIND_LIST) {
                                NodeList findListChildNodes = x.getChildNodes();
                                int k = 0;
                                while (k < findListChildNodes.getLength()) {
                                    Element range = (Element)findListChildNodes.item(k);
                                    if (range.getNodeName().equals(Constants.ELEMENT_RANGE)) {
                                        int start = Integer.parseInt(range.getAttribute(Constants.ATTRIBUTE_RANGE_START));
                                        int end = Integer.parseInt(range.getAttribute(Constants.ATTRIBUTE_RANGE_END));
                                        int lineNumber = Integer.parseInt(recordNumber);
                                        this.rangeLineNumber.add(lineNumber);
                                        this.rangeStart.add(start);
                                        this.rangeEnd.add(end);
                                        this.rangeIndex.add(k);
                                        if (range.hasAttribute(Constants.ATTRIBUTE_HEX)) {
                                            this.rangeHex.add(range.getAttribute(Constants.ATTRIBUTE_HEX));
                                        } else {
                                            this.rangeHex.add("N");
                                        }
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    ++p;
                }
            }
            ++i;
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public ArrayList<Integer> getRangeBegin() {
        return this.rangeStart;
    }

    public ArrayList<Integer> getRangeEnd() {
        return this.rangeEnd;
    }

    public ArrayList<Integer> getRangeLineNumber() {
        return this.rangeLineNumber;
    }

    public ArrayList<Integer> getRangeIndex() {
        return this.rangeIndex;
    }

    public int getCursorPositionLineNumber() {
        return this.cursorPositionLineNumber;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String[] getMessage() {
        return this.message;
    }

    public XMLRequest getXmlRequest() {
        return this.xmlRequest;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public String getHex() {
        return this.hex;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean updateTotalMatchString() {
        if (this.messageCode == null || this.messageCode.isEmpty() || this.message == null || this.message.length == 0) {
            this.displayMessage = "";
            return false;
        }
        if (this.messageCode.equals("CAWA163I")) {
            this.displayMessage = TOTAL_MATCH_STRING_FOUND;
            return true;
        }
        if (this.messageCode.equals("CAWA3000E")) {
            this.displayMessage = "";
            return false;
        }
        if (this.messageCode.equals("CAWA445I")) {
            this.displayMessage = TOTAL_MATCH_STRING_NOT_FOUND;
            return false;
        }
        if (this.messageCode.equals("CAWA160E") || this.messageCode.equals("CAWA162I") || this.messageCode.equals("CAWA163I")) {
            this.displayMessage = "String not found in any field name";
            return false;
        }
        if (this.messageCode.equals("CAWA161E")) {
            this.displayMessage = "Field is not valid for Change";
            return false;
        }
        if (this.messageCode.equals("CAWA446I") || this.messageCode.equals("CAWA447I")) {
            this.displayMessage = "No more matches found";
            return false;
        }
        if (this.messageCode.equals("CAWA448I")) {
            this.displayMessage = "String changed";
            return true;
        }
        if (this.messageCode.equals("CAWA449I")) {
            int indexValueforFound = -1;
            int x = 0;
            while (x < this.message.length) {
                if (this.message[x].equals("times")) {
                    indexValueforFound = x;
                    break;
                }
                ++x;
            }
            this.displayMessage = String.valueOf(this.message[indexValueforFound - 1]) + " times changed";
            return true;
        }
        if (this.messageCode.equals("CAWA442I")) {
            int indexValueforFound = -1;
            int x = 0;
            while (x < this.message.length) {
                if (this.message[x].equals("found")) {
                    indexValueforFound = x;
                    break;
                }
                ++x;
            }
            this.displayMessage = "Found " + this.message[indexValueforFound + 1] + " times";
            return true;
        }
        if (this.messageCode.equals("CAWA441I")) {
            this.displayMessage = TOTAL_MATCH_STRING_FOUND;
            return true;
        }
        if (this.messageCode.equals("CAWA444I")) {
            int indexValueforExculde = -1;
            int x = 0;
            while (x < this.message.length) {
                if (this.message[x].equals("excluded")) {
                    indexValueforExculde = x;
                    break;
                }
                ++x;
            }
            this.displayMessage = String.valueOf(this.message[indexValueforExculde + 1]) + " times excluded";
            return true;
        }
        if (this.messageCode.equals("CAWA438I")) {
            int indexValueforExculde = -1;
            int x = 0;
            while (x < this.message.length) {
                if (this.message[x].equals("CAWA438I")) {
                    indexValueforExculde = x;
                    break;
                }
                ++x;
            }
            this.displayMessage = String.valueOf(this.message[indexValueforExculde + 1]) + " times excluded";
            return true;
        }
        if (this.messageCode.equals("CAWA443I")) {
            this.displayMessage = "String excluded";
            return true;
        }
        this.log.log(Level.WARNING, "unknown message code: " + this.messageCode);
        this.log.log(Level.WARNING, this.messageAsAString);
        this.displayMessage = this.messageAsAString;
        return false;
    }

    public String getDisplayMessage() {
        this.updateTotalMatchString();
        return this.displayMessage;
    }

    public ArrayList<String> getMoreMessagesForDisplay() {
        return this.moreThanOneMessageCode;
    }

    public String getMessageAsAString() {
        return this.messageAsAString;
    }

    public int getCursorPositionBase() {
        return this.cursorPositionBase;
    }

    private void extractFileMasterRecordAndAddToFileMasterRecords(NodeList records) {
        int recordCount = 0;
        while (recordCount < records.getLength()) {
            FileMasterRecord fileMasterRecord = new FileMasterRecord();
            Node recordNode = records.item(recordCount);
            NamedNodeMap recordAttributes = recordNode.getAttributes();
            fileMasterRecord.setNumber(Integer.parseInt(this.getAttributeValue("number", recordAttributes)));
            fileMasterRecord.setLength(Integer.parseInt(this.getAttributeValue("length", recordAttributes)));
            fileMasterRecord.setExcluded(!this.getAttributeValue("excluded", recordAttributes).equals("N"));
            fileMasterRecord.setLastRecord(this.getAttributeValue("eof", recordAttributes).equals("Y"));
            fileMasterRecord.setRRN(Integer.parseInt(this.getAttributeValue("rrn", recordAttributes)));
            Node recordFields = ((Element)recordNode).getElementsByTagName("RecordFields").item(0);
            if (recordFields == null) {
                return;
            }
            NodeList recordField = ((Element)recordFields).getElementsByTagName("RecordField");
            int i = 0;
            while (i < recordField.getLength()) {
                Node protectedList;
                Node fieldNode = recordField.item(i);
                FileMasterRecordField fileMasterRecordField = new FileMasterRecordField();
                NamedNodeMap fieldAttributes = fieldNode.getAttributes();
                if (fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CURSOR) == null) {
                    fileMasterRecordField.setCursorEnabled(false);
                } else {
                    fileMasterRecordField.setCursorEnabled(true);
                    Integer cursor = Integer.valueOf(this.getAttributeValue("cursor", fieldAttributes));
                    fileMasterRecordField.setCursor(cursor);
                }
                if (fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CHARDATAHEX) == null) {
                    fileMasterRecordField.setCharDataHex("N");
                } else {
                    String charDataHex = this.getAttributeValue(Constants.ATTRIBUTE_CHARDATAHEX, fieldAttributes);
                    fileMasterRecordField.setCharDataHex(charDataHex);
                }
                String fileMasterRecordFieldId = fieldAttributes.getNamedItem("id").getNodeValue();
                fileMasterRecordField.setId(fileMasterRecordFieldId);
                String fileMasterRecordFieldMaxLengthD = fieldAttributes.getNamedItem("maxLengthD").getNodeValue();
                String fileMasterRecordFieldMaxLengthP = fieldAttributes.getNamedItem("maxLengthP").getNodeValue();
                fileMasterRecordField.getLayoutField().setPosition(this.getAttributeValue("position", fieldAttributes));
                fileMasterRecordField.setMaxLengthD(fileMasterRecordFieldMaxLengthD);
                fileMasterRecordField.setMaxLengthP(fileMasterRecordFieldMaxLengthP);
                fileMasterRecordField.getLayoutField().setId(this.getAttributeValue("id", fieldAttributes));
                fileMasterRecordField.setColorData(this.getAttributeValue("colorData", fieldAttributes).equals("Y"));
                fileMasterRecordField.setColorFieldName(this.getAttributeValue("colorName", fieldAttributes).equals("Y"));
                fileMasterRecordField.setDataInputError(this.getAttributeValue("dataInpuError", fieldAttributes).equals("Y"));
                fileMasterRecordField.getLayoutField().setLevel(this.getTagValue("Level", fieldNode));
                fileMasterRecordField.getLayoutField().setName(this.getTagValue("Name", fieldNode));
                fileMasterRecordField.getLayoutField().setFormatChar(this.getTagValue("FormatChar", fieldNode));
                fileMasterRecordField.getLayoutField().setSigned(this.getTagValue("Signed", fieldNode));
                fileMasterRecordField.getLayoutField().setIntegerLength(this.getTagValue("IntegerLength", fieldNode));
                fileMasterRecordField.getLayoutField().setFractionLength(this.getTagValue("FractionLength", fieldNode));
                fileMasterRecord.addLayoutLevelOrder(fileMasterRecordField.getLayoutField().getLevel(), fileMasterRecordField.getLayoutField().getId());
                fileMasterRecordField.setCharData(this.getTagValue("CharData", fieldNode));
                fileMasterRecordField.setGroupField(!this.hasCharData(fieldNode));
                if (fileMasterRecordField.getCharDataHex().equalsIgnoreCase("Y") && fileMasterRecordField.isCursorEnabled() && this.hex.equals("N") && this.displayMode != null && this.displayMode.equalsIgnoreCase("S")) {
                    this.isCursorInHexField = true;
                }
                if ((protectedList = ((Element)fieldNode).getElementsByTagName("ProtectedList").item(0)) != null) {
                    Node range = ((Element)protectedList).getElementsByTagName("Range").item(0);
                    NamedNodeMap rangeValues = range.getAttributes();
                    int start = Integer.parseInt(this.getAttributeValue("start", rangeValues));
                    int end = Integer.parseInt(this.getAttributeValue("end", rangeValues));
                    if (start > 0 && end > 0) {
                        fileMasterRecordField.setProtected(true);
                    }
                }
                fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                ++i;
            }
            this.fileMasterRecords.add(fileMasterRecord);
            ++recordCount;
        }
    }

    private boolean hasCharData(Node node) {
        return ((Element)node).getElementsByTagName("CharData").item(0) != null;
    }

    private String getAttributeValue(String attributeName, NamedNodeMap namedNodeMap) {
        if (namedNodeMap.getNamedItem(attributeName) != null) {
            return namedNodeMap.getNamedItem(attributeName).getNodeValue();
        }
        return "0";
    }

    private String getTagValue(String tagName, Node node) {
        if (((Element)node).getElementsByTagName(tagName).item(0) != null) {
            return ((Element)node).getElementsByTagName(tagName).item(0).getTextContent();
        }
        return "";
    }

    public ArrayList<FileMasterRecord> getFileMasterRecords() {
        return this.fileMasterRecords;
    }

    public int getCursorFieldId() {
        return this.cursorFieldId;
    }

    public void setCursorFieldId(int cursorFieldId) {
        this.cursorFieldId = cursorFieldId;
    }

    public String getCursorFieldName() {
        return this.cursorFieldName;
    }

    public void setCursorFieldName(String cursorFieldName) {
        this.cursorFieldName = cursorFieldName;
    }

    public boolean isCursorInHexField() {
        return this.isCursorInHexField;
    }

    public String getCharDataHex() {
        return this.charDataHex;
    }
}

