/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.GenericAddPageMemberSorter;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetWCMEM;
import com.ca.filemaster.ui.wizards.ChangedLabelProvider;
import com.ca.filemaster.ui.wizards.CreatedLabelProvider;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.DescriptionLabelProvider;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.IDLabelProvider;
import com.ca.filemaster.ui.wizards.MemberLabelProvider;
import com.ca.filemaster.ui.wizards.SizeLabelProvider;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericAddPage
extends FileMasterWizard
implements SelectionListener,
ICheckStateListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.addLayoutPage";
    protected final String NEW_CONTEXT_HELP_ID = "com.ca.filemaster.help.insertLayout";
    protected final String CONTEXT_SEL_HELP_ID = "com.ca.filemaster.help.addSelCritMemPage";
    public String dataSetName = "";
    private String memberName = "";
    private String newDatasetName;
    private String oldDatasetName;
    protected String newServer;
    private String oldServer;
    private Text numberOfMem;
    protected boolean pendingMessage = false;
    private boolean isSingleMember;
    private boolean topLayoutSelection = false;
    private Label serverNameLabel;
    private Label memberNameLabel;
    protected Combo serverNameCombo;
    public Combo memberNameCombo;
    protected Button memberSelectBtn;
    protected Button selectAllClearButton;
    private Group selectMembersGroup;
    protected CheckboxTableViewer checkboxTableViewer;
    private Table membersTable;
    private Listener sortListener;
    protected FileMasterServer server;
    private boolean msgDisplayed;
    protected FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
    private FMLayoutTreeModel fmltModel = FMLayoutTreeModel.getInstance();
    private boolean isDirectoryListCaller = false;
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    private Boolean ShowDialog = false;
    private ArrayList<FileMasterMember> memberList = new ArrayList();

    public GenericAddPage(String pageName, FileMasterServer server, String datasetName, String memberName, boolean isDirectoryListCaller) {
        super(pageName, datasetName, server);
        this.setTitle("Add Layout");
        this.server = server;
        this.dataSetName = datasetName;
        this.memberName = memberName;
        this.isDirectoryListCaller = isDirectoryListCaller;
        this.oldDatasetName = "";
        this.msgDisplayed = false;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.getTitle().equalsIgnoreCase("Add Layout")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.addLayoutPage");
        } else if (this.getTitle().equalsIgnoreCase("Add Selection Criteria")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.addSelCritMemPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.insertLayout");
        }
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Combo(this.dataSetComposite, 2056);
        GridData gd_serverNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.serverNameCombo.setLayoutData((Object)gd_serverNameCombo);
        this.serverNameCombo.setItems(this.getServers());
        if (this.serverNameCombo.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer("ServerAddLayoutPage1");
            int count = 0;
            while (count < this.serverNameCombo.getItemCount()) {
                if (this.serverNameCombo.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.serverNameCombo.setText(this.serverNameCombo.getItem(count).toString());
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.serverNameCombo.setText(this.serverNameCombo.getItem(0));
            }
        }
        this.serverNameCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!GenericAddPage.this.msgDisplayed) {
                    GenericAddPage.this.oldServer = GenericAddPage.this.serverNameCombo.getText();
                }
                GenericAddPage.this.msgDisplayed = false;
            }
        });
        this.serverNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericAddPage.this.newServer = GenericAddPage.this.serverNameCombo.getText().trim();
                GenericAddPage.this.pendingMessage = true;
                if (GenericAddPage.this.oldServer != null) {
                    GenericAddPage.this.displayServerChangedMsg();
                }
                GenericAddPage.this.changeServer();
                GenericAddPage.this.setPageComplete(GenericAddPage.this.canFlipToNextPage());
            }
        });
        if (this.isDirectoryListCaller) {
            this.serverNameCombo.setEnabled(false);
        }
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        super.createDataSet();
        this.dataSetCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!GenericAddPage.this.msgDisplayed) {
                    GenericAddPage.this.oldDatasetName = GenericAddPage.this.dataSetCombo.getText();
                }
                GenericAddPage.this.msgDisplayed = false;
            }
        });
        this.dataSetCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                boolean datasetError;
                GenericAddPage.this.newDatasetName = GenericAddPage.this.dataSetCombo.getText().trim();
                GenericAddPage.this.ShowDialog = !GenericAddPage.this.store.getBoolean("CLOSE_VALUE");
                boolean bl = datasetError = Validator.dataset(GenericAddPage.this.dataSetCombo.getText(), true) != 0 && Validator.dataset(GenericAddPage.this.dataSetCombo.getText(), true) != 3 && Validator.dataset(GenericAddPage.this.dataSetCombo.getText(), true) != 1;
                if (!(!GenericAddPage.this.ShowDialog.booleanValue() || datasetError || GenericAddPage.this.checkboxTableViewer.getTable().getItemCount() <= 1 && GenericAddPage.this.memberNameCombo.getText().isEmpty() || GenericAddPage.this.oldDatasetName.equalsIgnoreCase(GenericAddPage.this.newDatasetName))) {
                    GenericAddPage.this.pendingMessage = true;
                } else {
                    GenericAddPage.this.pendingMessage = false;
                    if (!GenericAddPage.this.oldDatasetName.equalsIgnoreCase(GenericAddPage.this.newDatasetName)) {
                        GenericAddPage.this.oldDatasetName = GenericAddPage.this.newDatasetName;
                        GenericAddPage.this.checkboxTableViewer.getTable().removeAll();
                        GenericAddPage.this.checkboxTableViewer.setInput(null);
                        GenericAddPage.this.memberNameCombo.setText("");
                    }
                }
                GenericAddPage.this.displayDatasetChangedMsg();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.dataSetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean datasetError;
                GenericAddPage.this.newDatasetName = GenericAddPage.this.dataSetCombo.getText().trim();
                GenericAddPage.this.ShowDialog = !GenericAddPage.this.store.getBoolean("CLOSE_VALUE");
                boolean bl = datasetError = Validator.dataset(GenericAddPage.this.dataSetCombo.getText(), true) != 0 && Validator.dataset(GenericAddPage.this.dataSetCombo.getText(), true) != 3 && Validator.dataset(GenericAddPage.this.dataSetCombo.getText(), true) != 1;
                if (!(!GenericAddPage.this.ShowDialog.booleanValue() || datasetError || GenericAddPage.this.checkboxTableViewer.getTable().getItemCount() <= 1 && GenericAddPage.this.memberNameCombo.getText().isEmpty() || GenericAddPage.this.oldDatasetName.equalsIgnoreCase(GenericAddPage.this.newDatasetName))) {
                    GenericAddPage.this.pendingMessage = true;
                } else {
                    GenericAddPage.this.pendingMessage = false;
                    if (!GenericAddPage.this.oldDatasetName.equalsIgnoreCase(GenericAddPage.this.newDatasetName)) {
                        GenericAddPage.this.oldDatasetName = GenericAddPage.this.newDatasetName;
                        GenericAddPage.this.checkboxTableViewer.getTable().removeAll();
                        GenericAddPage.this.checkboxTableViewer.setInput(null);
                        GenericAddPage.this.memberNameCombo.setText("");
                    }
                }
                GenericAddPage.this.displayDatasetChangedMsg();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        FMHistory.intializeComboBoxes(this.dataSetCombo, "DatasetListAddLayoutPage1");
        if (!this.isDirectoryListCaller) {
            this.dataSetCombo.setText(this.dataSetName);
        }
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 2048);
        GridData gd_memberNameCombo = new GridData(4, 4, false, false, 1, 1);
        this.memberNameCombo.setLayoutData((Object)gd_memberNameCombo);
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.memberNameCombo.setTextLimit(8);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        if (this.dataSetCombo.getText() != "") {
            this.memberNameCombo.setFocus();
        } else {
            this.dataSetCombo.setFocus();
        }
        FMHistory.intializeComboBoxes(this.memberNameCombo, "MemberListAddLayoutPage1");
        this.memberSelectBtn = new Button(this.dataSetComposite, 0);
        this.memberSelectBtn.setText("S&elect");
        this.memberSelectBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.memberSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericAddPage.this.doSelect();
                if (!GenericAddPage.this.topLayoutSelection && GenericAddPage.this.checkboxTableViewer.getTable().getItemCount() > 0) {
                    GenericAddPage.this.selectAllClearButton.setEnabled(true);
                } else {
                    GenericAddPage.this.selectAllClearButton.setEnabled(false);
                }
            }
        });
        new Label(this.dataSetComposite, 0);
        this.selectMembersGroup = new Group(this.container, 0);
        this.selectMembersGroup.setLayout((Layout)new GridLayout(2, false));
        this.selectMembersGroup.setSize(this.selectMembersGroup.computeSize(-1, -1));
        this.selectMembersGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectMembersGroup.setText("Select member");
        this.selectMembersGroup.setRedraw(true);
        this.createViewer((Composite)this.selectMembersGroup);
        this.selectAllClearButton = new Button((Composite)this.selectMembersGroup, 0);
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        this.selectAllClearButton.setLayoutData((Object)gd_selectAllClearButton);
        this.selectAllClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!GenericAddPage.this.isSingleMember) {
                    if (GenericAddPage.this.selectAllClearButton.getText() == "Select &All") {
                        GenericAddPage.this.checkboxTableViewer.setAllChecked(true);
                        GenericAddPage.this.selectAllClearButton.setText("&Clear Selections");
                    } else {
                        GenericAddPage.this.selectAllClearButton.setText("Select &All");
                        GenericAddPage.this.checkboxTableViewer.setAllChecked(false);
                    }
                } else {
                    GenericAddPage.this.selectAllClearButton.setEnabled(false);
                    GenericAddPage.this.checkboxTableViewer.setAllChecked(false);
                }
                GenericAddPage.this.setPageComplete(GenericAddPage.this.isPageComplete());
            }
        });
        this.checkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
        if (!this.isSingleMember) {
            this.selectAllClearButton.setText("Select &All");
        } else {
            this.selectAllClearButton.setText("&Clear Selections");
        }
        this.selectAllClearButton.setEnabled(false);
        this.selectAllClearButton.setVisible(false);
        this.numberOfMem = new Text((Composite)this.selectMembersGroup, 8);
        this.numberOfMem.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.numberOfMem, (int)12);
        this.numberOfMem.setEnabled(false);
        if (!this.topLayoutSelection) {
            this.selectAllClearButton.setVisible(true);
            this.getShell().getDefaultButton().setText("OK");
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.checkboxTableViewer.getCheckedElements().length >= 1) {
            this.selectAllClearButton.setText("&Clear Selections");
        } else {
            this.selectAllClearButton.setText("Select &All");
        }
        if (this.checkboxTableViewer.getCheckedElements().length == 0) {
            this.selectAllClearButton.setText("Select &All");
        }
        if (this.topLayoutSelection && this.checkboxTableViewer.getCheckedElements().length > 1) {
            this.checkboxTableViewer.setCheckedElements(new Object[]{event.getElement()});
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    private void createViewer(Composite parent) {
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)this.selectMembersGroup, (int)68354);
        this.membersTable = this.checkboxTableViewer.getTable();
        this.membersTable.setLinesVisible(true);
        this.membersTable.setHeaderVisible(true);
        GridData gd_table = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_table.heightHint = 200;
        gd_table.widthHint = 620;
        this.membersTable.setLayoutData((Object)gd_table);
        this.columnSorterListener();
        this.createColumns(parent, this.checkboxTableViewer);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkboxTableViewer.setInput(null);
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                event.getCheckable().setChecked(event.getElement(), event.getChecked());
                GenericAddPage.this.setPageComplete(GenericAddPage.this.isPageComplete());
            }
        });
    }

    private void createColumns(Composite parent, CheckboxTableViewer viewer) {
        String[] titles = new String[]{"Member", "Size", "Created", "Changed", "ID", "Description"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 125};
        viewer.setSorter((ViewerSorter)new GenericAddPageMemberSorter());
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)viewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(titles[i]);
            tableColumn.setWidth(bounds[i]);
            switch (i) {
                case 0: {
                    this.membersTable.setSortColumn(tableColumn);
                    this.membersTable.setSortDirection(128);
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new MemberLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SizeLabelProvider());
                    break;
                }
                case 2: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new CreatedLabelProvider());
                    break;
                }
                case 3: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new ChangedLabelProvider());
                    break;
                }
                case 4: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new IDLabelProvider());
                    break;
                }
                case 5: {
                    tableColumn.addListener(13, this.sortListener);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new DescriptionLabelProvider());
                }
            }
            ++i;
        }
    }

    private void columnSorterListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = GenericAddPage.this.checkboxTableViewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                GenericAddPage.this.checkboxTableViewer.refresh();
            }
        };
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("&Select...")) {
            DatasetWizard wizard = new DatasetWizard(true);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        } else if (this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"DSN lists PDS in preferences is undefined. No DSN lists found");
        } else if (this.dataSetCombo.getText().isEmpty() || Validator.dataset(this.dataSetCombo.getText(), true) == 3) {
            GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.canFlipToNextPage());
    }

    public boolean canFlipToNextPage() {
        this.error = "";
        boolean returnVal = this.nextOrFinish();
        if (returnVal) {
            returnVal = this.checkboxTableViewer.getCheckedElements().length == 1 || Validator.member(this.memberNameCombo.getText(), true) == 0;
        }
        return returnVal;
    }

    public boolean canFinish() {
        if (!this.topLayoutSelection) {
            boolean returnVal = false;
            returnVal = this.nextOrFinish();
            if (returnVal) {
                returnVal = true;
            }
            return returnVal;
        }
        return false;
    }

    public boolean nextOrFinish() {
        this.error = "";
        boolean returnVal = false;
        returnVal = super.isPageComplete();
        if (this.dataSetCombo != null && this.memberSelectBtn != null) {
            switch (Validator.dataset(this.dataSetCombo.getText(), true)) {
                case 0: {
                    this.memberSelectBtn.setEnabled(true);
                    break;
                }
                default: {
                    this.memberSelectBtn.setEnabled(false);
                }
            }
        }
        if (returnVal) {
            returnVal = this.ValidateMember();
        }
        if (this.dataSetCombo != null && this.memberNameCombo != null && this.checkboxTableViewer != null) {
            this.dataSetName = this.dataSetCombo.getText().trim();
            if (returnVal && this.dataSetName.startsWith("\"")) {
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.length() - 1);
            }
            if (this.getName().equalsIgnoreCase("Add Layout")) {
                if (this.checkboxTableViewer.getCheckedElements().length == 0) {
                    this.memberName = this.memberNameCombo.getText().trim();
                    FileMasterDataset fmdataset = new FileMasterDataset(null);
                    fmdataset.setName(this.dataSetName);
                    fmdataset.setDsOrg("PDS");
                    TT_TreeItem dsItem = null;
                    dsItem = this.fmltModel.findObject((Object)fmdataset);
                    if (dsItem != null) {
                        FileMasterMember fmmember = new FileMasterMember(dsItem);
                        fmmember.setName(this.memberName);
                        if (this.fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                            this.setErrorMessage("Duplicate member name");
                            return false;
                        }
                    }
                } else {
                    int count = 0;
                    while (count < this.checkboxTableViewer.getCheckedElements().length) {
                        this.memberName = ((FileMasterMember)((Object)this.checkboxTableViewer.getCheckedElements()[count])).getName();
                        FileMasterDataset fmdataset = new FileMasterDataset(null);
                        fmdataset.setName(this.dataSetName);
                        fmdataset.setDsOrg("PDS");
                        TT_TreeItem dsItem = null;
                        dsItem = this.fmltModel.findObject((Object)fmdataset);
                        if (dsItem != null) {
                            FileMasterMember fmmember = new FileMasterMember(dsItem);
                            fmmember.setName(this.memberName);
                            if (this.fmltModel.findObjectInTree((Object)fmmember, dsItem) != null) {
                                this.setErrorMessage("Duplicate member name");
                                return false;
                            }
                        }
                        ++count;
                    }
                }
            }
        }
        return returnVal;
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.fmstModel.getServers().length];
        int serverCount = 0;
        while (serverCount < this.fmstModel.getServers().length) {
            listOfServers[serverCount] = this.fmstModel.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        if (!this.isDirectoryListCaller && this.fmstModel.getServers().length > 0) {
            this.server = (FileMasterServer)this.fmstModel.getServers()[0].getServer();
        }
        this.serverChanged(this.server);
        return listOfServers;
    }

    protected boolean ValidateMember() {
        if (this.memberNameCombo != null && this.memberSelectBtn != null) {
            if (Validator.member(this.memberNameCombo.getText(), true) == 0) {
                this.memberSelectBtn.setEnabled(false);
                return true;
            }
            if (this.memberSelectBtn != null && this.checkboxTableViewer != null) {
                switch (Validator.member(this.memberNameCombo.getText(), true)) {
                    case 0: 
                    case 7: {
                        this.memberSelectBtn.setEnabled(true);
                        break;
                    }
                    case 6: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.memberNameCombo.getText(), true)] + "\n";
                        this.memberSelectBtn.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.memberNameCombo.getText(), true)] + "\n";
                        if (this.checkboxTableViewer.getCheckedElements().length <= 0) break;
                        this.error = new String();
                    }
                }
                if (this.error.length() > 0) {
                    this.setErrorMessage(this.error);
                    return this.checkboxTableViewer.getCheckedElements().length > 0;
                }
                this.setErrorMessage(null);
                return this.checkboxTableViewer.getCheckedElements().length > 0;
            }
        }
        return false;
    }

    private void doSelect() {
        int oldSelectedMember = this.checkboxTableViewer.getCheckedElements().length;
        this.memberList.clear();
        int i = 0;
        while (i < oldSelectedMember) {
            this.memberList.add((FileMasterMember)((Object)this.checkboxTableViewer.getCheckedElements()[i]));
            ++i;
        }
        FileMasterMember member = new FileMasterMember(null);
        FileMasterDataset dataset = new FileMasterDataset(null);
        member.setName(this.memberNameCombo.getText());
        dataset.setName(this.dataSetCombo.getText());
        RunGetWCMEM runner = new RunGetWCMEM(dataset, this.server, member, true, "L");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                this.numberOfMem.setText("No members returned.");
                this.numberOfMem.setEnabled(true);
            } else {
                NodeList nodes = element.getElementsByTagName("MemberInfo");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i2 = 0;
                    while (i2 < messages.getLength()) {
                        Node msgNode = messages.item(i2);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + CommonMFCalls.getTagValue("Message", msgElement);
                        ++i2;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = CommonMFCalls.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    this.numberOfMem.setText("No members returned.");
                    this.numberOfMem.setEnabled(true);
                } else {
                    int i3 = 0;
                    while (i3 < nodes.getLength()) {
                        Element memElement = (Element)nodes.item(i3);
                        FileMasterMember wcMember = new FileMasterMember(null);
                        if (memElement.getAttribute("fmfiletype").equalsIgnoreCase("S")) {
                            wcMember.setName(memElement.getAttribute("name"));
                            wcMember.setRecordCount(memElement.getAttribute("recordCount"));
                            wcMember.setDateCreated(memElement.getAttribute("dateCreated"));
                            wcMember.setDateChanged(memElement.getAttribute("dateChanged"));
                            wcMember.setID(memElement.getAttribute("userID"));
                            wcMember.setCLDescription(memElement.getAttribute("description"));
                            if (!this.memberList.contains((Object)wcMember)) {
                                this.memberList.add(wcMember);
                            }
                        }
                        ++i3;
                    }
                    this.checkboxTableViewer.setInput((Object)this.memberList.toArray(new FileMasterMember[this.memberList.size()]));
                    this.checkboxTableViewer.refresh();
                    if (this.memberList.size() == 1) {
                        this.numberOfMem.setText(String.valueOf(this.memberList.size()) + " member returned.");
                    } else {
                        this.numberOfMem.setText(String.valueOf(this.memberList.size()) + " members returned.");
                    }
                    this.numberOfMem.setEnabled(true);
                }
            }
            if (this.memberList.size() > 0) {
                this.selectAllClearButton.setEnabled(true);
            } else {
                this.selectAllClearButton.setEnabled(false);
            }
        }
    }

    private String getTagValue(String sTag, Element msgElement) {
        NodeList nlList = msgElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverNameCombo.getText())) {
                this.server = (FileMasterServer)((Object)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class));
                this.serverChanged(this.server);
                break;
            }
            ++servers;
        }
    }

    protected int displayServerChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newServer != null && !this.newServer.equals(this.oldServer)) {
                String question = "Are you sure you want to change the server? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Server Change", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldServer = this.newServer;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.checkboxTableViewer.getTable().removeAll();
                    this.checkboxTableViewer.setInput(null);
                    this.memberNameCombo.setText("");
                    this.dataSetCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.serverNameCombo.setText(this.oldServer);
                    this.newServer = this.oldServer;
                }
            }
        }
        return returncode;
    }

    private int displayDatasetChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newDatasetName != null && !this.newDatasetName.equals(this.oldDatasetName)) {
                String question = "Are you sure you want to change the data set? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldDatasetName = this.newDatasetName;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.checkboxTableViewer.getTable().removeAll();
                    this.checkboxTableViewer.setInput(null);
                    this.memberNameCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.dataSetCombo.setText(this.oldDatasetName);
                    this.newDatasetName = this.oldDatasetName;
                }
            }
        }
        return returncode;
    }
}

