/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster;

import com.ca.filemaster.AllocateNewParmPDSWizard;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.DSNListWizard;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ParmFilesPrefsTab {
    public static Button dsnListRadioBtn;
    public static Button selCriteriaBtn;
    public static Button cusRecordLayoutBtn;
    public static Text dsnListField;
    public static Text selCriteriaField;
    public static Text cusRecordLayField;
    public static Composite BtnComposite;
    public static Button allocateBtn;
    public static Button selectBtn;
    public static Button dsnListsBtn;
    private static Shell newShell;
    private static FileMasterServer server;

    protected static Composite parmFilesPrefs(TabFolder tabFolder, Shell shell, FileMasterServer server) {
        newShell = shell;
        ParmFilesPrefsTab.server = server;
        Composite dsnListComposite = new Composite((Composite)tabFolder, 0);
        dsnListComposite.setBackground(shell.getDisplay().getSystemColor(22));
        dsnListComposite.setLayout((Layout)new GridLayout(1, false));
        Group dsnGrp = new Group(dsnListComposite, 0);
        dsnGrp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        dsnGrp.setLayout((Layout)new GridLayout(2, false));
        dsnGrp.setText("Update processing parms");
        dsnListRadioBtn = new Button((Composite)tabFolder, 16);
        dsnListRadioBtn.setText("DS&N lists:");
        dsnListField = new Text((Composite)tabFolder, 2048);
        GridData gd_dsnListField = new GridData(16384, 0x1000000, true, false, 1, 1);
        dsnListField.setLayoutData((Object)gd_dsnListField);
        TextUtil.setWidth((Text)dsnListField, (int)25);
        dsnListField.setText(FMPreferences.getDSNListPDS());
        dsnListField.setTextLimit(44);
        dsnListField.addVerifyListener((VerifyListener)new verifytoUpperCase());
        dsnListField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ParmFilesPrefsTab.Modify(e);
            }
        });
        dsnListField.setText("");
        selCriteriaBtn = new Button((Composite)dsnGrp, 16);
        selCriteriaBtn.setText("S&election criteria:");
        selCriteriaBtn.setSelection(true);
        selCriteriaField = new Text((Composite)dsnGrp, 2048);
        GridData gd_selCriteriaField = new GridData(16384, 0x1000000, true, false, 1, 1);
        selCriteriaField.setLayoutData((Object)gd_selCriteriaField);
        TextUtil.setWidth((Text)selCriteriaField, (int)25);
        selCriteriaField.setTextLimit(44);
        selCriteriaField.addVerifyListener((VerifyListener)new verifytoUpperCase());
        selCriteriaField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ParmFilesPrefsTab.Modify(e);
            }
        });
        cusRecordLayoutBtn = new Button((Composite)dsnGrp, 16);
        cusRecordLayoutBtn.setText("C&ustom record layout:");
        cusRecordLayField = new Text((Composite)dsnGrp, 2048);
        GridData gd_cusRecordLayField = new GridData(16384, 0x1000000, true, false, 1, 1);
        cusRecordLayField.setLayoutData((Object)gd_cusRecordLayField);
        TextUtil.setWidth((Text)cusRecordLayField, (int)25);
        cusRecordLayField.setTextLimit(44);
        cusRecordLayField.addVerifyListener((VerifyListener)new verifytoUpperCase());
        cusRecordLayField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ParmFilesPrefsTab.Modify(e);
            }
        });
        BtnComposite = new Composite(dsnListComposite, 0);
        BtnComposite.setLayout((Layout)new GridLayout(3, false));
        allocateBtn = new Button(BtnComposite, 8);
        allocateBtn.setText("Allo&cate...");
        allocateBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParmFilesPrefsTab.Select(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        selectBtn = new Button(BtnComposite, 8);
        selectBtn.setText("&Select...");
        selectBtn.setEnabled(false);
        selectBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParmFilesPrefsTab.Select(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        dsnListsBtn = new Button(BtnComposite, 8);
        dsnListsBtn.setText("DSN &Lists...");
        dsnListsBtn.setVisible(false);
        dsnListsBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParmFilesPrefsTab.Select(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return dsnListComposite;
    }

    private static void Modify(FocusEvent e) {
        if (selCriteriaField.isFocusControl()) {
            ParmFilesPrefsTab.toggleRadioGroup(false);
            selCriteriaBtn.setSelection(true);
        } else if (cusRecordLayField.isFocusControl()) {
            ParmFilesPrefsTab.toggleRadioGroup(false);
            cusRecordLayoutBtn.setSelection(true);
        }
    }

    private static void toggleRadioGroup(boolean selected) {
        if (selCriteriaBtn != null && cusRecordLayoutBtn != null) {
            selCriteriaBtn.setSelection(selected);
            cusRecordLayoutBtn.setSelection(selected);
        }
    }

    private static void Select(SelectionEvent e) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestingToolsWizardDialog dialog = null;
        if (e.getSource().equals(selectBtn)) {
            String filterText = "";
            filterText = selCriteriaBtn.getSelection() ? selCriteriaField.getText() : cusRecordLayField.getText();
            DatasetWizard wizard = new DatasetWizard(false, filterText, "", server.getName());
            dialog = new TestingToolsWizardDialog(newShell, (IWizard)wizard);
            dialog.create();
            dialog.open();
        } else if (e.getSource().equals(dsnListsBtn)) {
            if (server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
                MessageDialog.openWarning((Shell)window.getShell(), (String)"Warning", (String)Validator.errorMsg[20]);
            } else if (!dsnListRadioBtn.getSelection()) {
                if (selCriteriaBtn.getSelection()) {
                    if (selCriteriaField.getText().isEmpty() || Validator.dataset(selCriteriaField.getText(), true) == 3) {
                        GenericImportWizard wizard = new GenericImportWizard("Select DSN List", server, false);
                        dialog = new TestingToolsWizardDialog(window.getShell(), (IWizard)wizard);
                        dialog.open();
                    } else {
                        DatasetWizard wizard = new DatasetWizard(false);
                        dialog = new TestingToolsWizardDialog(window.getShell(), (IWizard)wizard);
                        dialog.open();
                    }
                } else if (cusRecordLayoutBtn.getSelection()) {
                    if (cusRecordLayField.getText().isEmpty() || Validator.dataset(cusRecordLayField.getText(), true) == 3) {
                        DSNListWizard wizard = new DSNListWizard(server);
                        dialog = new TestingToolsWizardDialog(window.getShell(), (IWizard)wizard);
                        dialog.open();
                    } else {
                        DatasetWizard wizard = new DatasetWizard(false);
                        dialog = new TestingToolsWizardDialog(window.getShell(), (IWizard)wizard);
                        dialog.open();
                    }
                }
            }
        } else if (e.getSource().equals(allocateBtn)) {
            AllocateNewParmPDSWizard wizard;
            String newPDSName = "";
            dsnListRadioBtn.getSelection();
            if (selCriteriaBtn.getSelection()) {
                if (!selCriteriaField.getText().trim().equalsIgnoreCase(server.getFmpPreferences().getFmParmFilePrefs().getSelectionCriteria())) {
                    newPDSName = selCriteriaField.getText().trim();
                }
                wizard = new AllocateNewParmPDSWizard(server.getFmpPreferences().getFmParmFilePrefs().getSelectionCriteria(), newPDSName, server);
                dialog = new TestingToolsWizardDialog(newShell, (IWizard)wizard);
                dialog.open();
            }
            if (cusRecordLayoutBtn.getSelection()) {
                if (!cusRecordLayField.getText().trim().equalsIgnoreCase(server.getFmpPreferences().getFmParmFilePrefs().getCustomerRecordLayout())) {
                    server.getFmpPreferences().getFmParmFilePrefs().setCustomerRecordLayout(cusRecordLayField.getText().trim());
                }
                wizard = new AllocateNewParmPDSWizard(server.getFmpPreferences().getFmParmFilePrefs().getCustomerRecordLayout(), newPDSName, server);
                dialog = new TestingToolsWizardDialog(newShell, (IWizard)wizard);
                dialog.open();
            }
        }
    }
}

