/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster;

import com.ca.filemaster.common.FileMasterSession;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static final String PLUGIN_ID = "com.ca.filemaster";
    private static final String CHEATSHEET = "com.ca.testingtools.cheatsheet.overview";
    private static final boolean forceCheatsheet = Boolean.getBoolean("com.ca.filemaster.forcecheatsheet");
    public static Activator plugin;
    private Thread cancelSessions;
    private Runnable runnableObj = this;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public void start(BundleContext context) throws Exception {
        if (this.cancelSessions == null) {
            this.cancelSessions = new Thread(this.runnableObj, "CancelSessions");
        }
        super.start(context);
        plugin = this;
        TrayDialog.setDialogHelpAvailable((boolean)true);
        this.setCheatSheet();
        if (!this.cancelSessions.isAlive()) {
            this.cancelSessions = new Thread(this.runnableObj, "CancelSessions");
        }
        this.cancelSessions.start();
    }

    private void setCheatSheet() {
        ScopedPreferenceStore instancePreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
        String cheatsheet = instancePreferences.getString("initial_symdump_cheatsheet");
        if (!CHEATSHEET.equals(cheatsheet) || forceCheatsheet) {
            Display display = Display.getDefault();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenCheatSheetAction action = new OpenCheatSheetAction(Activator.CHEATSHEET);
                        action.run();
                    }
                });
            }
            instancePreferences.setValue("initial_symdump_cheatsheet", CHEATSHEET);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.log.log(Level.WARNING, "Closing the File Master Plus plugin.");
        FileMasterSession.cancelSession();
        Job.getJobManager().cancel((Object)PLUGIN_ID);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    @Override
    public void run() {
        FileMasterSession.cancelSession();
    }
}

