/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.wizards;

import com.ca.testingtools.common.FileName;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.MRUCombo;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.protsym.wizards.LoadProtsymWizard;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifyDSN;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoadProtsymPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private LoadProtsymWizard wizard;
    private MRUCombo SourceDSN;
    private Combo SourceType;
    private Text from;
    private Text to;
    private Button all;
    private Button none;
    private Button rc;
    private IDialogSettings settings;
    private static final boolean showMessage = Boolean.getBoolean("com.ca.testingtools.protsym.showmessage");
    private static final String LISTING = "listing";
    private static final String FILETYPE = "type";
    private static final String FILETYPE_IX = "type_ix";
    private static final String FROMNAME = "from";
    private static final String TONAME = "to";
    private static final String REPORTTYPE = "report";
    private final String CONTEXT_HELP_ID = "com.ca.testingtools.help.loadProtsymPage";
    private static final byte REPORT_NONE = 0;
    private static final byte REPORT_ALL = 1;
    private static final byte REPORT_RC = 2;
    private boolean noReport = false;
    private String myProtsym;
    private String myFtype;
    private String[] dsnTypeLabels = new String[]{"IBM PDS", "IBM Sequential", "CA Panvalet", "CA Librarian", "CA Endevor"};
    private TTServer server;
    private ProtsymDataset protsym;
    private static final String sourceClass = LoadProtsymPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private XMLRequest xml;

    protected LoadProtsymPage(String pageName, ProtsymDataset protsym, TTServer server) {
        super(pageName);
        this.protsym = protsym;
        this.server = server;
    }

    public void createControl(Composite parent) {
        this.wizard = (LoadProtsymWizard)this.getWizard();
        this.settings = this.wizard.getDialogSettings();
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        control.setLayout((Layout)gridLayout);
        Group source0 = new Group(control, 16);
        source0.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label((Composite)source0, 0);
        Label label2 = new Label((Composite)source0, 0);
        this.myProtsym = this.protsym.getName();
        label.setText(String.format("Server:%s Port:%d", this.server.getHostname(), this.server.getPort()));
        label2.setText("PROTSYM: " + this.myProtsym);
        Group source = new Group(control, 16);
        source.setLayout((Layout)new GridLayout(1, true));
        source.setText("Listing Data Set");
        this.SourceDSN = new MRUCombo((Composite)source, 4, "SOURCE");
        this.SourceDSN.getCombo().setTextLimit(44);
        Combo combo = this.SourceDSN.getCombo();
        TextUtil.setWidth((Combo)combo, (int)20, (int)44);
        combo.addVerifyListener((VerifyListener)new verifyDSN());
        String name = this.settings.get("SOURCE");
        int index = name == null ? -1 : combo.indexOf(name);
        combo.select(index);
        this.SourceType = new Combo((Composite)source, 12);
        this.SourceType.setLayoutData((Object)new GridData(16384, 0, true, false));
        this.SourceType.setItems(this.dsnTypeLabels);
        try {
            index = this.settings.getInt(FILETYPE_IX);
        }
        catch (NumberFormatException numberFormatException) {
            index = 0;
        }
        this.SourceType.select(index);
        Composite remaining = control;
        Group members = new Group(remaining, 16);
        members.setLayout((Layout)new GridLayout(2, false));
        members.setText("Member");
        label = new Label((Composite)members, 0);
        label.setText("From");
        label.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.from = new Text((Composite)members, 4);
        name = this.settings.get(FROMNAME);
        this.from.setText(name == null ? "" : name);
        this.from.setTextLimit(10);
        TextUtil.setWidth((Text)this.from, (int)8, (int)10);
        VerifyListener fromKeyListener = new VerifyListener(){
            private Pattern p = Pattern.compile("[*$@#0-9A-Z]+");

            public void verifyText(VerifyEvent e) {
                e.text = e.text.replaceAll(" ", "").toUpperCase();
                int length = e.text.length();
                if (length == 0) {
                    return;
                }
                Matcher m = this.p.matcher(e.text);
                e.doit = m.matches();
            }
        };
        this.from.addVerifyListener(fromKeyListener);
        label = new Label((Composite)members, 0);
        label.setText("To");
        label.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.to = new Text((Composite)members, 4);
        name = this.settings.get(TONAME);
        this.to.setText(name == null ? "" : name.replace('*', ' ').trim());
        this.to.setTextLimit(10);
        TextUtil.setWidth((Text)this.to, (int)8, (int)10);
        VerifyListener toKeyListener = new VerifyListener(){
            private Pattern p = Pattern.compile("[$@#0-9A-Z]+");

            public void verifyText(VerifyEvent e) {
                e.text = e.text.replaceAll(" ", "").toUpperCase();
                int length = e.text.length();
                if (length == 0) {
                    return;
                }
                Matcher m = this.p.matcher(e.text);
                e.doit = m.matches();
            }
        };
        this.to.addVerifyListener(toKeyListener);
        if (showMessage) {
            Group reportgroup = new Group(remaining, 16);
            reportgroup.setLayout((Layout)new GridLayout(3, false));
            reportgroup.setText("Messages");
            this.all = new Button((Composite)reportgroup, 16);
            this.all.setText("All");
            this.none = new Button((Composite)reportgroup, 16);
            this.none.setText("None");
            this.rc = new Button((Composite)reportgroup, 16);
            this.rc.setText("RC");
            try {
                int reptype = this.settings.getInt(REPORTTYPE);
                switch (reptype) {
                    case 0: {
                        this.none.setSelection(true);
                        break;
                    }
                    case 2: {
                        this.rc.setSelection(true);
                        break;
                    }
                    default: {
                        this.all.setSelection(true);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.all.setSelection(true);
            }
            this.all.addSelectionListener((SelectionListener)this);
            this.none.addSelectionListener((SelectionListener)this);
            this.rc.addSelectionListener((SelectionListener)this);
        }
        this.SourceDSN.getCombo().forceFocus();
        this.SourceDSN.getCombo().addSelectionListener((SelectionListener)this);
        this.SourceDSN.getCombo().addModifyListener((ModifyListener)this);
        this.from.addModifyListener((ModifyListener)this);
        this.to.addModifyListener((ModifyListener)this);
        this.SourceType.addSelectionListener((SelectionListener)this);
        this.setTitle("Load Listing(s) into PROTSYM");
        this.setControl((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.loadProtsymPage");
    }

    public boolean submit() {
        if (this.isPageComplete()) {
            this.SourceDSN.save();
            this.setErrorMessage(null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dsn", this.protsym.getName());
            if (showMessage) {
                if (this.all.getSelection()) {
                    map.put(REPORTTYPE, "all");
                } else if (this.none.getSelection()) {
                    map.put(REPORTTYPE, "none");
                } else {
                    map.put(REPORTTYPE, "rc");
                }
            } else {
                map.put(REPORTTYPE, "all");
            }
            int fileix = this.SourceType.getSelectionIndex();
            switch (fileix) {
                case 0: {
                    this.myFtype = FileName.FileType.IBMPDS.toString();
                    break;
                }
                case 1: {
                    this.myFtype = FileName.FileType.IBMSEQ.toString();
                    break;
                }
                case 2: {
                    this.myFtype = FileName.FileType.PANVALET.toString();
                    break;
                }
                case 3: {
                    this.myFtype = FileName.FileType.LIBRARIAN.toString();
                    break;
                }
                case 4: {
                    this.myFtype = FileName.FileType.ENDEVOR.toString();
                }
            }
            map.put(LISTING, this.SourceDSN.getSelected());
            map.put(FILETYPE, this.myFtype);
            map.put(FROMNAME, this.from.getText());
            String tostr = this.to.getText();
            if (tostr.isEmpty()) {
                map.put(TONAME, "");
            } else {
                map.put(TONAME, this.to.getText());
            }
            IWizardContainer container = this.getContainer();
            this.noReport = showMessage ? this.none.getSelection() : false;
            LoadPROTSYM loadlisting = new LoadPROTSYM(map, this.server);
            try {
                container.run(true, true, (IRunnableWithProgress)loadlisting);
            }
            catch (InvocationTargetException e) {
                this.showError("Invocation Target Exception", e);
                return false;
            }
            catch (InterruptedException e) {
                String error = HexUtil.getErrorText((Throwable)e);
                this.showError(error, e);
                return false;
            }
            this.xml = loadlisting.getXml();
            if (this.xml == null) {
                return false;
            }
            for (Map.Entry<String, Object> item : map.entrySet()) {
                this.settings.put(item.getKey(), String.valueOf(item.getValue()));
            }
            this.settings.put("SOURCE", this.SourceDSN.getSelected());
            this.settings.put(FILETYPE_IX, fileix);
            return true;
        }
        return false;
    }

    public boolean isPageComplete() {
        int last;
        this.setErrorMessage(null);
        if (this.SourceDSN.getSelected() == null) {
            this.setErrorMessage("Specify Source Data Set Name");
            return false;
        }
        String member = this.from.getText().trim();
        if (member.length() < 1) {
            this.setErrorMessage("From Member Name Missing");
            return false;
        }
        if (member.length() > 8 && !this.SourceType.getText().equals("CA Panvalet")) {
            this.setErrorMessage("From Member Name too Long");
            return false;
        }
        int first = member.indexOf(42);
        if (first != (last = member.lastIndexOf(42))) {
            this.setErrorMessage("Only One * Allowed");
            return false;
        }
        char firstchar = member.charAt(0);
        if (firstchar >= '0' && firstchar <= '9') {
            this.setErrorMessage("First character of From member cannot be digit");
            return false;
        }
        boolean wildcard = false;
        if (last >= 0 && last == member.length() - 1) {
            wildcard = true;
        } else if (last >= 0) {
            this.setErrorMessage("Wildcard '*' must be at end of name");
            return false;
        }
        if (this.SourceType.getText().equals("IBM Sequential") && wildcard) {
            this.setErrorMessage("Wildcard From member invalid for sequential file");
            return false;
        }
        String tomember = this.to.getText().trim();
        if (tomember.length() > 0 && wildcard) {
            this.setErrorMessage("To member invalid with wildcard From member");
            return false;
        }
        if (this.SourceType.getText().equals("IBM Sequential") && tomember.length() > 0 && !member.equals(tomember)) {
            this.setErrorMessage("To member invalid for IBM Sequential file");
            return false;
        }
        if (tomember.length() > 8 && !this.SourceType.getText().equals("CA Panvalet")) {
            this.setErrorMessage("To Member Name too Long");
            return false;
        }
        if (tomember.length() > 0) {
            firstchar = tomember.charAt(0);
            if (firstchar >= '0' && firstchar <= '9') {
                this.setErrorMessage("First character of To member cannot be digit");
                return false;
            }
            char[] cArray = new char[]{'$', '@', '#'};
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char item = cArray[n2];
                if (tomember.lastIndexOf(item) > 0) {
                    this.setErrorMessage(String.format("%c can only be first character of member name", Character.valueOf(item)));
                    return false;
                }
                ++n2;
            }
            try {
                ByteBuffer from = ByteBuffer.wrap(member.getBytes("IBM1047"));
                ByteBuffer to = ByteBuffer.wrap(tomember.getBytes("IBM1047"));
                if (from.compareTo(to) > 0) {
                    this.setErrorMessage("To member is not greater than From member");
                    return false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return super.isPageComplete();
    }

    private void showError(String text, Throwable e) {
        TT_ErrorDialog.openError((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)text, (Throwable)e);
    }

    private void showWarning(String message) {
        this.setMessage(message, 2);
        MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)message);
    }

    public void modifyText(ModifyEvent e) {
        this.wizard.getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.wizard.getContainer().updateButtons();
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isNoReport() {
        return this.noReport;
    }

    public class LoadPROTSYM
    implements IRunnableWithProgress {
        private static final String DIALOG_TITLE = "load Listing into PROTSYM";
        private Map<String, Object> map;
        private XMLRequest xml = null;
        private TTServer server;

        public XMLRequest getXml() {
            return this.xml;
        }

        public LoadPROTSYM(Map<String, Object> map, TTServer server) {
            this.map = map;
            this.server = server;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask("Loading Listing into PROTSYM File", 1);
            ServerConnect connect = new ServerConnect(this.server, "testingtools/import");
            try {
                this.xml = connect.connect("import", this.map, true);
            }
            catch (TTException e) {
                String error = HexUtil.getErrorText((Throwable)e);
                TT_ErrorDialog.openError((Shell)LoadProtsymPage.this.getShell(), (String)DIALOG_TITLE, (String)error);
                this.xml = new XMLRequest();
                this.xml.setStatus(16, error);
            }
            monitor.done();
        }
    }
}

