/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.views.list;

import com.ca.testingtools.protsym.Member;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProtsymViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final DateFormat dayFormat = new SimpleDateFormat("yyyy'/'MM'/'dd");
    private static final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    static {
        dayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public String getColumnText(Object obj, int index) {
        Member member = (Member)obj;
        switch (index) {
            case 0: {
                return member.getName();
            }
            case 1: {
                return member.getLanguage();
            }
            case 2: {
                return member.isLocked() ? "Locked" : dayFormat.format(member.getTimestamp().getTime());
            }
            case 3: {
                return member.isLocked() ? "" : timeFormat.format(member.getTimestamp().getTime());
            }
            case 4: {
                return member.getDsn();
            }
        }
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return null;
    }

    public Image getImage(Object obj) {
        return null;
    }
}

