/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.ui.lister.pli;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.protsym.Outline;
import com.ca.testingtools.protsym.ui.lister.util.AbstractTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class PLITextHover
extends AbstractTextHover {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private char[] delimiters = new char[]{',', '(', ')', '+', '-', ' ', '\''};

    public PLITextHover(IScanSource scanner, Outline outline) {
        super(scanner, outline);
    }

    @Override
    public char[] getDelimiters() {
        return this.delimiters;
    }

    @Override
    protected String getHoverText(String token, IDocument document) {
        String ucToken = token.toUpperCase();
        StringBuilder string = new StringBuilder(80);
        TreeObject[] treeObjectArray = this.outline.getQualifiedObjects(ucToken);
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject to = treeObjectArray[n2];
            String nflg = to.getAttribute("gt_nflg");
            int line = to.getLineNumber();
            if (line > 0) {
                try {
                    IRegion def = document.getLineInformation(line - 1);
                    String source = document.get(def.getOffset(), def.getLength());
                    String text = this.scanner.getSourceSegment(source);
                    if (!nflg.equals("40")) {
                        text = String.format("%d %s", line, text);
                    }
                    if (text != null) {
                        string.append(text.trim());
                        string.append(HexUtil.LF);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            ++n2;
        }
        if (string.length() == 0) {
            return null;
        }
        string.setLength(string.length() - HexUtil.LF.length());
        return string.toString();
    }
}

