/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.core.IConstants;
import com.ca.testingtools.protsym.Member;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ProtsymUtil {
    private static final String sourceClass = ProtsymUtil.class.getName();
    static Logger log = Logger.getLogger(sourceClass);
    static String cacopyright = "Copyright (c) 2016 CA";

    private ProtsymUtil() {
    }

    public static boolean isProtsym(IResource res) {
        switch (ProtsymUtil.getType(res)) {
            case UNKNOWN: 
            case INVALID: {
                return false;
            }
        }
        return true;
    }

    public static ProtsymType getType(IResource resource) {
        if (!(resource instanceof IResource)) {
            return ProtsymType.INVALID;
        }
        if (!resource.exists()) {
            return ProtsymType.INVALID;
        }
        if (!(resource instanceof IFile)) {
            return ProtsymType.INVALID;
        }
        IFile file = (IFile)resource;
        if (!file.isAccessible()) {
            return ProtsymType.INVALID;
        }
        String extension = file.getFileExtension();
        if (Arrays.binarySearch(IConstants.FILE_EXTENSION_LIST, extension) >= 0) {
            if (extension.equals("iCOB")) {
                return ProtsymType.COBOL;
            }
            if (extension.equals("iPLI")) {
                return ProtsymType.PLI;
            }
            if (extension.equals("iASM")) {
                return ProtsymType.ASM;
            }
        }
        return ProtsymType.INVALID;
    }

    public static boolean isZip(IFile file) {
        boolean intertest = false;
        try {
            ZipFile zipfile = new ZipFile(file.getFullPath().toFile(), 1);
            ZipEntry zipEntry = zipfile.getEntry("listing");
            boolean bl = intertest = zipEntry != null;
            if (!intertest) {
                zipEntry = zipfile.getEntry("metadata");
            }
            intertest = zipEntry != null;
            zipfile.close();
        }
        catch (IOException iOException) {
            intertest = false;
        }
        return intertest;
    }

    public static String getShortName(IResource res) {
        String name = res.getName();
        if (ProtsymUtil.isProtsym(res)) {
            String extension = res.getFileExtension();
            int index = name.lastIndexOf(extension);
            name = name.substring(0, index);
        }
        return name;
    }

    public static IFile getProtsym(Member member) {
        IFolder folder = ProtsymUtil.getFolder(member.getDataset().getName());
        if (folder == null) {
            return null;
        }
        String membername = String.valueOf(member.getName()) + ".";
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getName().startsWith(membername) && resource.getType() == 1) {
                    return (IFile)resource;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            return null;
        }
        return null;
    }

    public static IProject getProject() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(".PROTSYM");
        return project;
    }

    public static synchronized IFolder getFolder(String dsn) {
        IProject project = ProtsymUtil.getProject();
        IFolder folder = null;
        try {
            if (!project.exists()) {
                project.create(null);
                project.open(null);
                project.setHidden(true);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            if (!(folder = project.getFolder(dsn)).exists()) {
                folder.create(true, true, null);
            }
        }
        catch (CoreException e) {
            log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            folder = null;
        }
        return folder;
    }

    public static enum ProtsymType {
        COBOL,
        PLI,
        ASM,
        UNKNOWN,
        INVALID;

    }
}

