/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymDataset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProtsymListJob
extends Job {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = ProtsymListJob.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    protected final TTServer server;
    private final ProtsymDataset protsym;
    private IProfileSetContent container;
    private static final String REFRESHING = "Getting members list for %1$s @ %2$s";
    private static final String TESTINGTOOLS_SERVER = "testingtools/protsym";

    public ProtsymListJob(ProtsymDataset protsym, TTServer server, IProfileSetContent container) {
        super(String.format(REFRESHING, new Object[]{protsym, server.getName()}));
        this.server = server;
        this.protsym = protsym;
        this.container = container;
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.toString().equals("com.ca.testingtools.protsym")) {
            return true;
        }
        return super.belongsTo(family);
    }

    public TTServer getServer() {
        return this.server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ServerConnect connect = new ServerConnect(this.server, TESTINGTOOLS_SERVER);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("dsn", this.protsym.getName());
        try {
            XMLRequest xml = connect.connect("list", map, true);
            if (xml.getErrorLevel() == 0) {
                NodeList members = xml.getMembers();
                ArrayList<Member> list = new ArrayList<Member>(members.getLength());
                int index = 0;
                while (index < members.getLength()) {
                    Element element = (Element)members.item(index);
                    Member member = new Member(element);
                    member.setDataset(this.protsym);
                    list.add(member);
                    ++index;
                }
                if (list != null && list.size() > 0) {
                    final Member[] memberlist = list.toArray(new Member[list.size()]);
                    UIJob job = new UIJob("job"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ProtsymListJob.this.container.addContent((Object[])memberlist, true);
                            return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
                        }
                    };
                    job.schedule();
                }
            }
        }
        catch (TTException e1) {
            this.log.log(Level.INFO, ((Object)((Object)e1)).getClass().getSimpleName(), e1);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

