/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.protsym.ProtsymListJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;

public class ProtsymDataset
extends Dataset {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String NDVRSYM = "ndvrsym";
    private static final String NDVRLEASM = "ndvrleasm";
    public boolean ndvrsym = false;
    public boolean refreshleasm = false;

    public ProtsymDataset(TT_TreeItem parent) {
        super(parent);
    }

    public void setParent(TT_TreeItem parent) {
        super.setParent(parent);
        Element element = parent.getElement();
        String value = element.getAttribute(NDVRSYM);
        this.ndvrsym = Boolean.parseBoolean(value);
        value = element.getAttribute(NDVRLEASM);
        this.refreshleasm = Boolean.parseBoolean(value);
    }

    public void requestContents(final IProfileSetContent container) {
        final Object[] contents = this.getList();
        if (contents.length == 0) {
            TTServer server = (TTServer)this.getParent().getParent(TTServer.class).getValue();
            ProtsymListJob job = new ProtsymListJob(this, server, container);
            job.schedule();
        } else {
            UIJob job = new UIJob("job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    container.addContent(contents, true);
                    return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
                }
            };
            job.schedule();
        }
    }

    public boolean isRefreshleasm() {
        return this.refreshleasm;
    }

    public void setRefreshleasm(boolean refreshleasm) {
        this.refreshleasm = refreshleasm;
        this.getParent().getElement().setAttribute(NDVRLEASM, Boolean.toString(refreshleasm));
    }

    public boolean isNdvrsym() {
        return this.ndvrsym;
    }

    public void setNdvrsym(boolean ndvrsym) {
        this.ndvrsym = ndvrsym;
        this.getParent().getElement().setAttribute(NDVRSYM, Boolean.toString(ndvrsym));
    }

    public String getText() {
        String text = super.getText();
        if (this.isNdvrsym()) {
            text = String.valueOf(text) + " (NDVRSYM)";
            return text;
        }
        return text;
    }
}

