/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.Statement;
import com.ca.testingtools.common.StatementType;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ASMVariable;
import com.ca.testingtools.core.CobolVariable;
import com.ca.testingtools.core.Label;
import com.ca.testingtools.core.PLIVariable;
import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.protsym.ProtsymFile;
import com.ca.testingtools.protsym.RootObject;
import com.ca.testingtools.protsym.Structure;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Outline {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = Outline.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    private static final String FORMAT_NUMBER = "%06d:%s";
    private ProtsymFile protsymFile;
    private HashMap<String, ArrayList<TreeObject>> names;
    private HashMap<String, NamedNodeMap> altvars = new HashMap();
    private HashMap<Integer, Integer> statementXref;
    private HashMap<Integer, Integer> lineXref;
    private int language;
    private TreeObject tree = new RootObject("root", "ROOT");
    private Statement stmtTree;
    private static final TreeObject[] EMPTYTREE = new TreeObject[0];
    private static final String COBOLDELIMITER = " IN | OF ";
    private static final String DEFAULTDELIMITER = "\\.";
    private HashMap<Long, PLIVariable> PLIpointers = null;
    private ArrayList<PLIVariable> based = null;
    private static HashMap<String, Outline> files;

    private Outline(ProtsymFile protsymFile) throws TTException {
        this.protsymFile = protsymFile;
        this.reLoad();
        this.tree.setOwner(protsymFile.hashCode());
    }

    private Outline(InputStream inputStream, int language) throws TTException {
        this.protsymFile = null;
        this.language = language;
        this.buildOutline(inputStream);
    }

    public void reLoad() throws TTException {
        block5: {
            this.language = this.protsymFile.getLanguage();
            InputStream metadataFile = null;
            try {
                IPath location = this.protsymFile.getFile().getLocation();
                File toFile = location.toFile();
                ZipFile zipFile = new ZipFile(toFile, 1);
                ZipEntry zipEntry = zipFile.getEntry("metadata");
                if (zipEntry == null) break block5;
                metadataFile = zipFile.getInputStream(zipEntry);
                if (metadataFile == null) {
                    throw new TTException("Missing Metadata Resource");
                }
                try {
                    this.buildOutline(metadataFile);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
                    throw e;
                }
                zipFile.close();
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                throw new TTException("Invalid PROTSYM File");
            }
        }
    }

    private void cleanupOffset(Statement stmtTree) {
        ArrayList<Statement> list = this.getchildren(stmtTree);
        Statement[] statements = list.toArray(new Statement[list.size()]);
        int index = 1;
        while (index < statements.length) {
            int prioroffset;
            int offset = statements[index].getOffset();
            if (offset != 0 && (prioroffset = statements[index - 1].getOffset()) != 0) {
                statements[index - 1].setLastOffset(offset - 1);
            }
            ++index;
        }
    }

    private ArrayList<Statement> getchildren(Statement statement) {
        ArrayList<Statement> children = new ArrayList<Statement>();
        Statement[] statementArray = statement.getChildren(null);
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement child = statementArray[n2];
            children.add(child);
            children.addAll(this.getchildren(child));
            ++n2;
        }
        return children;
    }

    private void buildOutline(InputStream metadata) throws TTException {
        if (this.language == 128) {
            this.based = new ArrayList();
            this.PLIpointers = new HashMap();
        }
        XMLRequest xml = new XMLRequest(metadata);
        TreeObject[] treeObjectArray = this.tree.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject item = treeObjectArray[n2];
            this.tree.removeChildTree(item);
            ++n2;
        }
        Element member = xml.getFirstMember();
        if (member == null) {
            throw new TTException("Invalid Metadata File");
        }
        NodeList list = member.getElementsByTagName("symbols");
        if (list.getLength() < 1) {
            throw new TTException("Invalid Metadata File");
        }
        NodeList children = list.item(0).getChildNodes();
        int limit = children.getLength();
        this.names = new HashMap(limit);
        int i = 0;
        while (i < limit) {
            this.buildTree((Element)children.item(i), this.tree);
            ++i;
        }
        list = member.getElementsByTagName("statement");
        this.stmtTree = list.getLength() > 0 ? new Statement((Element)list.item(0)) : new Statement(StatementType.NOOP, 0, 0, 0);
        this.cleanupOffset(this.stmtTree);
        list = member.getElementsByTagName("linenumbers");
        if (list.getLength() > 0) {
            children = list.item(0).getChildNodes();
            limit = children.getLength();
            this.statementXref = new HashMap(limit);
            this.lineXref = new HashMap(limit);
            i = 0;
            while (i < limit) {
                Element xref = (Element)children.item(i);
                Integer linenumber = Integer.valueOf(xref.getAttribute("linenumber"));
                Integer statement = Integer.valueOf(xref.getAttribute("statementnumber"));
                this.statementXref.put(statement, linenumber);
                this.lineXref.put(linenumber, statement);
                ++i;
            }
        } else {
            this.statementXref = new HashMap(0);
            this.lineXref = new HashMap(0);
        }
        list = member.getElementsByTagName("altvarnames");
        if (list.getLength() > 0) {
            children = list.item(0).getChildNodes();
            this.altvars = new HashMap(children.getLength());
            limit = children.getLength();
            i = 0;
            while (i < limit) {
                Element altvar = (Element)children.item(i);
                NamedNodeMap nodes = altvar.getAttributes();
                this.altvars.put(XMLFile.getName((Element)altvar), nodes);
                ++i;
            }
        } else {
            this.altvars = new HashMap(0);
        }
        for (Map.Entry<String, ArrayList<TreeObject>> name : this.names.entrySet()) {
            for (TreeObject item : name.getValue()) {
                item.setAttribute("name", this.getQualifiedName(item));
            }
        }
        if (this.language == 128) {
            for (PLIVariable plivar : this.based) {
                long basehandle = plivar.getBasehandle();
                PLIVariable base = this.PLIpointers.get(basehandle);
                if (base == null) {
                    base = this.findBase(this.tree, basehandle);
                }
                plivar.setBase(base);
            }
            this.based = null;
        }
    }

    private PLIVariable findBase(TreeObject item, long basehandle) {
        PLIVariable plivar;
        if (item instanceof PLIVariable && (plivar = (PLIVariable)item).getHandle() == basehandle) {
            return plivar;
        }
        TreeObject[] treeObjectArray = item.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject child = treeObjectArray[n2];
            PLIVariable result = this.findBase(child, basehandle);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public TreeObject getVarLenTreeobject(TreeObject varLenTreeobject) {
        int varLenStmt = varLenTreeobject.getStatementNumber();
        HashMap<Integer, TreeObject> tos = new HashMap<Integer, TreeObject>(this.names.size());
        ArrayList<Integer> stmts = new ArrayList<Integer>();
        int i = 0;
        Object[] objectArray = this.names.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            String str = (String)obj;
            ArrayList<TreeObject> treeList = this.names.get(str);
            for (TreeObject treeobject : treeList) {
                int stmt = treeobject.getStatementNumber();
                tos.put(stmt, treeobject);
                stmts.add(stmt);
                ++i;
            }
            ++n2;
        }
        Object[] objstmt = new Object[i];
        objstmt = stmts.toArray();
        Arrays.sort(objstmt);
        int j = 0;
        while (j < objstmt.length) {
            TreeObject lenTree;
            int dptyp;
            TreeObject tree = (TreeObject)tos.get(objstmt[j]);
            if (tree.getName().equals(varLenTreeobject.getName()) && varLenStmt == (Integer)objstmt[j] && (dptyp = ((Integer)Attribute.getValue((String)"gt_dptyp", (Properties)(lenTree = (TreeObject)tos.get(objstmt[j + 1])).getAttributes())).intValue()) == 11) {
                return lenTree;
            }
            ++j;
        }
        return null;
    }

    private TreeObject buildTree(Element child, TreeObject parent) {
        if (child == null) {
            return parent;
        }
        TreeObject current = parent;
        String typeString = child.getTagName();
        TreeObject.ObjectType type = TreeObject.getType((String)typeString);
        switch (type) {
            case VARIABLE: {
                try {
                    switch (this.language) {
                        case 32: {
                            current = new CobolVariable(child);
                            break;
                        }
                        case 16: {
                            current = new ASMVariable(child);
                            break;
                        }
                        case 128: {
                            TreeObject pgm;
                            current = new PLIVariable(child);
                            PLIVariable plivar = (PLIVariable)current;
                            int hpvltp = (Integer)Attribute.getValue((String)"gt_pvltp", (Properties)current.getAttributes());
                            if ((hpvltp & 0x10) != 0) {
                                this.PLIpointers.put(plivar.getHandle(), plivar);
                            }
                            if (plivar.isBased()) {
                                this.based.add(plivar);
                            }
                            boolean more = !((pgm = parent) instanceof Label);
                            while (more) {
                                if (pgm == null || pgm instanceof Label) break;
                                pgm = (TreeObject)pgm.getParent();
                            }
                            plivar.setParentProc((Label)pgm);
                        }
                    }
                }
                catch (TTException e) {
                    this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                }
                ((Variable)current).setProgramName(this.protsymFile == null ? "" : this.protsymFile.getName());
                break;
            }
            case STRUCTURE: {
                current = new Structure(child);
                break;
            }
            case LABEL: {
                current = new Label(child);
            }
        }
        if (this.language == 16 && !parent.hasChildren() && parent.toString().equals(current.toString())) {
            return null;
        }
        parent.addChild(current);
        switch (current.getType()) {
            case VARIABLE: 
            case LABEL: {
                String key = current.getName();
                ArrayList<Object> array = this.names.get(key);
                if (array == null) {
                    array = new ArrayList(1);
                    this.names.put(key, array);
                }
                array.add(current);
            }
        }
        NodeList children = child.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.buildTree((Element)children.item(i), current);
            ++i;
        }
        return current;
    }

    public HashMap<String, ArrayList<TreeObject>> getNames() {
        return this.names;
    }

    private TreeObject getParent(String name, TreeObject child) {
        if (child == null) {
            return null;
        }
        TreeObject parent = (TreeObject)child.getParent();
        if (parent == null) {
            return null;
        }
        Integer level = (Integer)parent.getValue("level");
        if (level < 0) {
            return null;
        }
        if (parent.getName().equals(name)) {
            return parent;
        }
        return this.getParent(name, parent);
    }

    public String getQualifiedName(TreeObject treeObject) {
        int ilevel = (Integer)Attribute.getValue((String)"level", (Properties)treeObject.getAttributes());
        if (ilevel < 1) {
            return null;
        }
        String name = treeObject.getName();
        if (this.language == 16) {
            return name;
        }
        if (this.language == 32 && "FILLER".equalsIgnoreCase(name)) {
            return name;
        }
        TreeObject[] namelist = this.getQualifiedObjects(name);
        while (namelist.length > 1) {
            StringBuilder fullname = new StringBuilder(name);
            if ((treeObject = (TreeObject)treeObject.getParent()).getParent() == null) {
                namelist = new TreeObject[]{};
                continue;
            }
            String parentname = treeObject.getName();
            if (parentname != null) {
                switch (this.language) {
                    case 32: {
                        fullname.append(" OF ");
                        fullname.append(parentname);
                        break;
                    }
                    case 128: {
                        fullname.insert(0, '.');
                        fullname.insert(0, parentname);
                    }
                }
            }
            name = fullname.toString();
            namelist = this.getQualifiedObjects(name);
        }
        return name;
    }

    public TreeObject getPostedTreeObject(String name, int statement) {
        String key = statement > 0 ? String.format(FORMAT_NUMBER, statement, name) : name;
        TreeObject[] trees = this.getQualifiedObjects(key);
        return trees.length == 1 ? trees[0] : null;
    }

    public TreeObject[] getQualifiedObjects(String name) {
        String[] namelist;
        if (name == null) {
            return EMPTYTREE;
        }
        if ((name = name.trim()).length() == 0) {
            return EMPTYTREE;
        }
        if (this.language != 128) {
            name = name.toUpperCase();
        }
        name = name.replaceAll("[ ]+", " ");
        int statement = 0;
        if (name.length() > 7 && name.charAt(6) == ':') {
            try {
                statement = Integer.parseInt(name.substring(0, 6));
            }
            catch (NumberFormatException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            name = name.substring(7);
        }
        switch (this.language) {
            case 32: {
                namelist = name.split(COBOLDELIMITER);
                break;
            }
            case 128: {
                namelist = name.split(DEFAULTDELIMITER);
                break;
            }
            default: {
                namelist = new String[]{name};
            }
        }
        if (namelist.length == 0) {
            namelist = new String[]{name};
        }
        ArrayList<String> qnames = new ArrayList<String>(namelist.length);
        if (this.language == 32) {
            String[] stringArray = namelist;
            int n = namelist.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null) {
                    qnames.add(item);
                }
                ++n2;
            }
        } else {
            int i = namelist.length - 1;
            while (i >= 0) {
                if (namelist[i] != null) {
                    qnames.add(namelist[i]);
                }
                --i;
            }
        }
        if (qnames.size() == 0) {
            return EMPTYTREE;
        }
        String candidatename = (String)qnames.get(0);
        ArrayList<TreeObject> candidates = this.names.get(candidatename);
        if (candidates == null || candidates.size() == 0) {
            return EMPTYTREE;
        }
        if (candidates.size() > 1) {
            if (statement != 0) {
                for (TreeObject item : candidates) {
                    int newstatement = item.getStatementNumber();
                    if (statement != newstatement) continue;
                    return new TreeObject[]{item};
                }
            }
            candidates = new ArrayList<TreeObject>(candidates);
            qnames.remove(0);
            for (String qname : qnames) {
                if (candidates.size() <= 1) break;
                Iterator<TreeObject> it = candidates.iterator();
                while (it.hasNext()) {
                    TreeObject next = it.next();
                    TreeObject result = this.getParent(qname, next);
                    if (result != null) continue;
                    it.remove();
                }
            }
        }
        return candidates.toArray(new TreeObject[candidates.size()]);
    }

    public TreeObject getTree() {
        return this.tree;
    }

    public HashMap<Integer, Integer> getStatementXref() {
        return this.statementXref;
    }

    public int getLineNumber(int statement) {
        Integer result = this.statementXref.get(statement);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public int getLanguage() {
        return this.language;
    }

    public final Statement getStmtTree() {
        return this.stmtTree;
    }

    public final HashMap<String, NamedNodeMap> getAltVars() {
        return this.altvars;
    }

    public final HashMap<Integer, Integer> getLineXref() {
        return this.lineXref;
    }

    public int getStatementNumber(int liennumber) {
        Integer result = this.lineXref.get(liennumber);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public static final Outline getInstance(IFile file) throws TTException {
        ProtsymFile protsym = ProtsymFile.getInstance((IResource)file);
        if (protsym == null) {
            throw new TTException("Invalid Resource");
        }
        return Outline.getInstance(protsym);
    }

    public static final Outline getInstance(ProtsymFile protsymFile) throws TTException {
        if (protsymFile == null) {
            throw new TTException("Invalid PROTSYM File");
        }
        Outline outline = protsymFile.getOutline();
        if (outline == null) {
            outline = new Outline(protsymFile);
            protsymFile.setOutline(outline);
        }
        return outline;
    }

    public static Outline getInstance(InputStream inputStream, String filename, int language) throws TTException {
        Outline outline;
        if (files == null) {
            files = new HashMap();
        }
        if ((outline = files.get(filename)) == null) {
            outline = new Outline(inputStream, language);
            files.put(filename, outline);
        }
        return outline;
    }

    public Statement hasLinenumber(int linenumber) {
        return this.stmtTree.hasLinenumber(linenumber);
    }

    public Statement hasStatement(int statement) {
        return this.stmtTree.hasStatement(statement);
    }

    public Statement hasOffset(byte[] offset, StatementType type) {
        return this.stmtTree.hasOffset(offset, type);
    }

    public Collection<PLIVariable> getPLIPointerObjects() {
        return this.PLIpointers == null ? null : this.PLIpointers.values();
    }
}

