/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.core.IConstants;
import com.ca.testingtools.core.ResourceProperty;
import com.ca.testingtools.protsym.Activator;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class Decorator
implements ILabelDecorator {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String[] extensions = IConstants.FILE_EXTENSION_LIST;
    HashMap<String, Image> images = null;
    private boolean usetable = false;

    public Decorator(boolean usetable) {
        this.usetable = usetable;
        if (usetable) {
            this.images = new HashMap(10);
            String[] stringArray = new String[]{"COB_ICON", "ASM_ICON", "PLI_ICON", "GENERIC_ICON"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ImageDescriptor newimage = Activator.getDefault().getImageRegistry().getDescriptor(key);
                if (newimage != null) {
                    this.images.put(key, newimage.createImage(true));
                }
                ++n2;
            }
        }
    }

    public Decorator() {
        this(false);
    }

    public Image decorateImage(Image image, Object resource) {
        if (this.usetable) {
            return this.lookupImage(resource);
        }
        if (!(resource instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resource;
        if (file.isAccessible()) {
            ResourceProperty store;
            int isfile;
            String ext = file.getFileExtension();
            int n = isfile = ext == null ? -1 : Arrays.binarySearch(extensions, ext);
            if (isfile != -1 && Decorator.isProtsym(store = ResourceProperty.getInstance((IResource)file))) {
                ImageDescriptor newimage = null;
                Integer lang = store.getHex("gt_m_lang");
                switch (lang) {
                    case 32: {
                        newimage = Activator.getDefault().getImageRegistry().getDescriptor("COB_ICON");
                        break;
                    }
                    case 16: {
                        newimage = Activator.getDefault().getImageRegistry().getDescriptor("ASM_ICON");
                        break;
                    }
                    case 128: {
                        newimage = Activator.getDefault().getImageRegistry().getDescriptor("PLI_ICON");
                        break;
                    }
                    default: {
                        newimage = Activator.getDefault().getImageRegistry().getDescriptor("GENERIC_ICON");
                    }
                }
                if (newimage != null) {
                    return newimage.createImage(true);
                }
            }
        }
        return null;
    }

    private Image lookupImage(Object resource) {
        IFile file;
        ResourceProperty store;
        if (!(resource instanceof IResource)) {
            return null;
        }
        if (!((IResource)resource).exists()) {
            return null;
        }
        if (resource instanceof IFile && Decorator.isProtsym(store = ResourceProperty.getInstance((IResource)(file = (IFile)resource)))) {
            String key = null;
            Integer lang = store.getHex("gt_m_lang");
            switch (lang) {
                case 32: {
                    key = "COB_ICON";
                    break;
                }
                case 16: {
                    key = "ASM_ICON";
                    break;
                }
                case 128: {
                    key = "PLI_ICON";
                    break;
                }
                default: {
                    key = "GENERIC_ICON";
                }
            }
            if (key != null) {
                return this.images.get(key);
            }
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        String name;
        if (!(element instanceof IFile)) {
            return text;
        }
        ResourceProperty store = ResourceProperty.getInstance((IResource)((IResource)element));
        if (store != null && Decorator.isProtsym(store) && (name = store.getString("name")) != null && name.length() != 0) {
            String replace = Attribute.toString((String)"gt_m_lang", (String)store.getString("gt_m_lang"));
            return String.format("%s(%s)", name, replace);
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.images != null) {
            for (Image image : this.images.values()) {
                image.dispose();
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static boolean isProtsym(IResource res) {
        if (!(res instanceof IResource)) {
            return false;
        }
        if (!res.exists()) {
            return false;
        }
        ResourceProperty store = ResourceProperty.getInstance((IResource)res);
        return store == null ? null : Boolean.valueOf(Decorator.isProtsym(store));
    }

    public static String getShortName(IResource res) {
        String name = res.getName();
        if (res instanceof IFile) {
            ResourceProperty store = ResourceProperty.getInstance((IResource)res);
            name = store.getString("name");
        }
        return name;
    }

    public static boolean isProtsym(ResourceProperty store) {
        if (store == null) {
            return false;
        }
        boolean protsym = store.getBoolean("com.ca.protsym");
        if (!protsym) {
            protsym = store.getBoolean("com.ca.intertest");
        }
        return protsym;
    }

    public static String getShortName(ResourceProperty store) {
        String name = store.getString("name");
        if (name == null || name.length() == 0) {
            name = store.getResource().getName();
        }
        return name;
    }
}

